<?php
/*
  This action simply creates an associated list with formatted key/value pairs passed to it:
  You can use wiki markup in either keys or values but make sure not to break list layout.
  Later keys (names) might have a localization support and be automatically translated upon rendering.

    {{Description: defined in=autoload/style.php, inherits=UWikiBaseElement, see also=../UWikiBaseElem}}
    {{Description: type=string, case-sensitive}}      - flag (key without a value)

  If you suffix key with "%" no default formatting (defined by FormatDescription) will be applied:
    {{FormatDescription see also="(($==$))"}}
    {{Description: see also=API reference}}           - ((API reference==API reference))
    {{Description: see also%="((API reference))"}}    - ((API reference)) ("API" page, "reference" title)

  You can specify formatting of key parts using the second action ($ means "value"):
    {{FormatDescription see also=(($)), inherits={{Class $~}}, defined in%%$%%}}
*/

class Uformatdescription_Root extends UWikiBaseAction {
  public $runsImmediately = true;

  function Execute($format, $params) {
    foreach ($params as $key => $formatStr) {
      $format->settings->FormatDescription[$key] = $formatStr;
    }
  }
}

class Udescription_Root extends UWikiBaseAction {
  public $htmlTag = 'div';
  public $htmlClasses = array('description');

  function Execute($format, $params) {
    foreach ($params as $key => $value) {
      if ($value === true) {
        $value = '';
      } elseif (substr($key, -1) === '%') {
        $key = substr($key, 0, -1);
      } else {
        $formatStr = &$format->settings->FormatDescription[$key];
        if (!self::IsEmptyStr($formatStr)) {
          $value = self::SimpleFmt($formatStr, addslashes($value));
        }
      }

      $format->raw .= "  = $key==$value\n";
    }

    $format->raw !== '' and $format->AddFormat(UWikiWikiMarkup);
    $format->appendMe = true;
    $format->root = $this;
  }
}
