<?php
/*
  Accompanies %%mirror; adds popup hints to every element created on parse phase.
  Can be used both as formatter and as an action:

    {{DomHint}}             - will add hints to the parent document

    %%(DomHint; Wacko)      - limit to passed text; any formatter is supported (wacko by default)
      Hey, people of **the ((WP:Earth))**!
    %%

  Both forms support a boolean parameter (default false) to disable hinting nested documents:

    %%(DomHint nested=0)
      This is **hinted**.

      %%(wacko)
        This is //not//.
      ~%%
    %%

  Also, in both forms you can ignore certain elements like this:

    {{DomHint wacko_CompositePart}}     - ignores Uwacko_CompositePart
    {{DomHint wacko_CompositePart=0}}   - turns on hinting of Uwacko_CompositePart (e.g. useful in overriding DomClassesToNoHint)

    {{DomHint wacko CompositePart}}     - the same as first example (you can add spaces as
                                          you wish and also replace underscores with them)
    {{DomHint wacko composite part}}    - the same (char case doesn't matter)

    {{DomHint UWikiBaseReplacement}}    - this one ignores all children of given class because first
                                          letter is "U", otherwise it'd ignore that exact class name only
    {{DomHint UWikiBaseReplacement=1}} - the same as above but would work regardless of the first letter
    {{DomHint UWikiBaseReplacement=self}} - only works for exact class without its children

  This plugin requires common.js.

  CONFIGURATION - fields added to UWikiSettings:

    * $DomHintNestedDocs = default value for 'nested' parameter; if unset defaults to true;
    * $DomClassesToNoHint.
*/

class Udomhint_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = true;

  static $css, $js;
  public $ignoreElements = array('Uwacko_CompositePart' => true, 'wikitextfromraw' => 'self',
                                 'UWacko_DefnText' => true);
  public $maxTextLength = 10;

  function Attachments() {
    return array('css' => array('DomHint' => self::$css),
                 'js'  => array('DomHint' => self::$js));
  }

  function Parse() {
    parent::Parse();

    $this->children[] = $noscript = $this->NewElement('Udomhint_NoScript');

    $hookNested = @$this->settings->DomHintNestedDocs;
    $hookNested = (!isset($hookNested) or $hookNested);

    if (isset( $this->settings->DomClassesToNoHint )) {
      $this->ignoreElements = $this->settings->DomClassesToNoHint;
    }

    $markup = $this->DefaultStyle('wacko');

      if ($format = $this->settings->format) {
        $params = &$format->current['params'];

          $param = &$params['nested'];
          isset($param) and $hookNested = $param;

          foreach ($params as $elemName => $ignore) {
            if ($elemName !== 'nested') {
              if ($ignore === true and $elemName[0] !== 'U') { $ignore = 'self'; }
              $this->ignoreElements[ $this->UniformElementName($elemName) ] = $ignore;
            }
          }

        if ($format->raw === '') {
          $this->HookDoc($format->origDoc, $hookNested);
        } else {
          $format->root = $this;
          $format->IsEmpty() and $format->AddFormat($markup);
          $this->HookDoc($format->NextFormatDoc(), $hookNested);
        }
      } elseif ($doc = UWikiDocument::TryParsing($this->raw, $this->settings, $markup)) {
        $this->children[] = $doc->root;
        $this->HookDoc($doc, $hookNested);
      } else {
        $this->children[] = $this->FormatterError($markup);
      }

    $this->isBlock = $noscript->isBlock = $format ? $format->blockExpected : true;
  }

  function HookDoc(UWikiDocument $doc, $hookNested) {
    $hookNested and $doc->newDocumentHooks[] = array($this, 'HookDoc');
    $doc->onHtmlTagHooks['any'][] = array($this, 'OnHtmlTag');
  }

    function OnHtmlTag($obj, array &$attrs, &$contents, &$htmlPrefix, &$htmlSuffix) {
      $objElemName = $this->UniformElementName($obj->elementName);
      $selfState = &$this->ignoreElements[$objElemName];
      $ignore = $selfState === 'self';

      if (!$ignore) {
        foreach ($this->ignoreElements as $elemName => &$state) {
          if ($state === true and is_a($obj, $elemName)) {
            $ignore = true;
            break;
          }
        }
      }

      if (!$ignore) {
        $obj->htmlTag or $obj->htmlTag = ($obj->HasBlockChildren() and $this->isBlock) ? 'div' : 'span';

        $hint = $this->PrettyName($obj);
        $obj->isBlock and $hint = "<strong>$hint</strong>";
        $obj->IsRoot() and $hint = "<span class='root'>$hint</span>";
        $attrs['domhint'] = $hint;
      }
    }

  function PrettyName($element) {
    if ($element->IsRoot()) {
      $name = ucfirst($element->MarkupName());
    } else {
      $name = str_replace('_', ' ', $element->ElementName());

      $name = ltrim( preg_replace('/([A-Z][a-z])/', ' \1', $name) );
      $name = ucfirst( strtolower($name) );

        if (!$element->MarkupName() and substr($name, 0, 5) === 'Wiki ') {
          $name = ucfirst( substr($name, 5) );
        }

      if (($element instanceof UWikiTextFromRaw) or
          ($element instanceof UWikiBaseReplacement)) {
        $text = $element->originalRaw;
        if (mb_strlen($text) > $this->maxTextLength) {
          $text = trim( mb_substr($text, 0, $this->maxTextLength) ).'…';
        }

        $name .= ' <q>'.$this->QuoteHTML(trim($text)).'</q>';
      }
    }

    return $name;
  }

    function UniformElementName($elemName) {
      static $replaces = array(' ' => '', '_' => '');
      return strtr(strtolower($elemName), $replaces);
    }
}

  class Udomhint_NoScript extends UWikiStringMessage {
    public $htmlTag = 'noscript';
    public $htmlClasses = array('dom-hint');
    public $message = '%%domhint: js disabled';
    public $defaultMessage = 'With JavaScript you can see node parents by moving mouse over it.';
  }

Udomhint_Root::$css = <<<CSS
noscript.dom-hint {
  display: none;
  position: absolute;
  margin: -1em 0 0 1em;
  font-style: italic;
  color: #D00;
  border: 1px solid InactiveBorder;
  background: InfoBackground;
  padding: 0.4em;
  z-index: 2;
}
*:hover > noscript.dom-hint { display: block; }

#domHint {
  position: absolute;
  z-index: 3;
  background: InfoBackground;
  border: 1px outset ActiveBorder;
  color: InfoText;
  margin: 1px 0 0 1px;
  padding: 0.2em 0.2em 0.2em 1.5em;
  line-height: 2em;
  font-size: 75%;
  max-width: 50em;
  cursor: not-allowed;
}

#domHint > span > span { border: 1px dashed Highlight; cursor: help; padding: 0 0.2em; white-space: nowrap; }
#domHint > span > span:hover { color: GrayText; }
#domHint > span + span:before { content: " ← "; color: silver; }

#domHint .root { color: GrayText; }
#domHint .root:hover { color: InfoText; border-bottom: 1px solid; }
#domHint q { font-style: italic; }

.dom-hinted { border: 1px solid red; }
CSS;

Udomhint_Root::$js = <<<JAVASCRIPT
var lastHighlDomNode;

var domHint = document.createElement('div');
    domHint.id = 'domHint';

    domHint.onclick = function () {
      ModifyClassNameOf(lastHighlDomNode, 'dom-hinted', false);
      \$hide(domHint);
    }

\$hide(domHint);

function InitializeDomHint() {
  if (document.body) {
    document.body.appendChild(domHint);

  Event.AddTo(document.body, 'mousemove', function (e) {
    DomHint(OriginalEventTargetOf(e), e);
  });
  } else {
    setTimeout(InitializeDomHint, 50);
  }
}

function DomHint(node, e) {
  while (node && node.nodeType == 3) { node = node.parentNode; }

  if (!domHint.parentNode || !IsTheTag(node)) {
    return;
  } else {
    var parent = node;
    do {
      if (parent == domHint) {
        return;
      } else if (parent.hasAttribute('domhint')) {
        node = parent;
        break;
      }

      parent = parent.parentNode;
    } while (IsTheTag(parent));
  }

    if (node == lastHighlDomNode) {
      UpdateDomHintPosFrom(e);
      return;
    }

  var toShow = IsTheTag(node) && node.hasAttribute('domhint');

  DomHighlightFunc(toShow ? node : null)();

  if (toShow) {
    var nodes = [];

      var hintedNode = node;
      do {
        if (node.hasAttribute('domhint')) {
          var newNode = document.createElement('span');
              newNode.innerHTML = node.getAttribute('domhint');
              newNode.onmousemove = DomHighlightFunc(node);
              newNode.onmouseover = DomHighlightFunc(hintedNode);

          var newNodeCont = document.createElement('span');
          newNodeCont.appendChild(newNode);
          nodes.push(newNodeCont);
        }

        node = node.parentNode;
      } while (IsTheTag(node));

    RemoveChildrenOf(domHint);

    \$each(nodes, function (node, i) {
      domHint.appendChild(node);
    });
  }

  \$show(domHint, toShow ? 'block' : 'none');
  toShow && UpdateDomHintPosFrom(e);
}

  function UpdateDomHintPosFrom(e) {
    var pos = MousePosFrom(e);
    \$style(domHint, 'left', pos.x + 'px', 'top', pos.y + 'px');
  }

function DomHighlightFunc(node) {
  return function () {
    ModifyClassNameOf(lastHighlDomNode, 'dom-hinted', false);
    ModifyClassNameOf(node, 'dom-hinted');
    lastHighlDomNode = node;
  }
}

InitializeDomHint();
JAVASCRIPT;
