<?php
/*
  This action is intended more for example purposes than real use (albeit it can be used as usual).
  Our wiki markup is designed in the way the author doesn't need to bother about presentation of his texts
  so the more you avoid using this action the cleaner and more readable your texts look to a human being.

  Parameter names are case-insensitive except for setting names.

  Usage:  {{If format=html}}
          {{If not format=text}}
          {{If}}                                - passes thru (as if all conditions have passed)
          {{If format=html, version>=1.0}}      - you can combine any number of conditions for AND match.
          {{If not format=html, version>=1.0}}  - NOT only affects one condition.
          {{If setting}} or {{If setting=1}}    - checks for document setting.
          {{If nonexistingsetting}}             - condition fails.

  Of cause, real effect is achieved by combining it with some markup/action (if there's none 'wacko' is used):

    {{If version>=1.0; TOC}}

    %%(If enableHTML5)
    <time datetime="2010-10-22T14:15:03-05:10">2:15 P.M., October 22nd</time>
    %%

    %%(If not wackoWikiHighlDir=""; html)
    <html> <head> <style>
      tag.class#id { -moz-prop: value; }
    </style> </head> </html>
    %%
*/

class Uif_Root extends UWikiBaseAction {
  public $isFormatter = true;

  function Execute($format, $params) {
    $continue = true;

      foreach ($params as $param => $value) {
        $not = strtolower( substr($param, 0, 4) ) === 'not ';
        $not and $param = ltrim( substr($param, 4) );
        $lowerParam = strtolower($param);

        switch ($lowerParam) {
        case 'format':        $passed = $format->renderingIn === strtolower($value); break;
        case 'version>':      $passed = $this->doc->version >= $value; break;
        case 'build>':        $passed = $this->doc->build >= $value; break;
        default:              $passed = (isset($this->settings->$param) and $this->settings->$param == $value);
        }

        $continue &= $not ? !$passed : $passed;
        if (!$continue) { break; }
      }

    $format->stop = $continue === 0;

    if (!$format->stop and $format->IsEmpty()) {
      $format->AddFormat( $this->DefaultStyle() );
    }
  }

  function IsDynamic($format, $params) { return true; }
}
