<?php
/*
  These two actions let you dynamically load markup modules and markups. Call them before
  corresponding markup/modules are used. Multiple arguments (file locations) can be given.
  If current pager is a file pager then all relative file names (which don't start with any
  kind of slash) are prefixed with base directory of the pager.

  WARNING: these actions give access to the file system and no restriction on file location is
           imposed so use them only on trusted documents as they allow execution of arbitrary PHP files.

    {{LoadMod term, uwiki/actions/topdoc.php}}    - ".php" is optional, if extension differs
                                                    it is appended automatically.
    {{LoadMarkup markups/scripter}}               - markups are stored in individual directories
*/

class Uloadmod_Root extends Umeta_Root {
  public $runsImmediately = true;

  function Execute($format, $params) {
    foreach ($params as $module => $markup) {
      is_string($markup) or $markup = $module;

      if (self::IsPath('rel', $module) and $this->pager instanceof UWikiFilePager) {
        $module = $this->pager->GetBaseDir()."/$module";
      }

      $this->Load($markup, $module);
    }
  }

    function Load($markup, $module) {
      substr($module, -4) === '.php' or $module .= '.php';

      if (is_file($module) and is_readable($module)) {
        $this->doc->LoadModuleInto($markup, $module);
      } else {
        throw new ENoUWikiModule($module);
      }
    }
}

  class ENoUWikiModule extends EUverseWiki {
    function __construct($module) {
      parent::__construct("Cannot {{LoadMod}} UverseWiki module $module.");
    }
  }

class Uloadmarkup_Root extends Uloadmod_Root {
  function Load($markup) {
    try {
      $this->doc->LoadMarkup($markup);
    } catch (EUWikiCannotLoadMarkup $e) {
      throw new ENoUWikiMarkup($markup);
    }
  }
}

  class ENoUWikiMarkup extends EUverseWiki {
    function __construct($markup) {
      parent::__construct("Cannot {{LoadMarkup}} UverseWiki markup $markup.");
    }
  }
