<?php
/* This is a highlighter for the "Ono" language. Made for Freeman, http://freeman.tunilab.org. */

class Uono_Root extends UWikiBaseHighlighter {
  public $langName = 'ono';

  public $constructs = array(
    'string' => array(array("'", "'", true)),
    'comment' => array(array('//', '$'), array('/\*', '\*/', true)),
    array('({=[\s\S]*?=})' => 'wiki'),
  );

  public $keywords = array('all', 'alter', 'as', 'bool', 'by', 'case', 'catch',
                           'class', 'do', 'else', 'elsif', 'end', 'exit', 'false',
                           'finally', 'float', 'for', 'from', 'group', 'if', 'in',
                           'inherited', 'int', 'into', 'is', 'level', 'new', 'of',
                           'order', 'out', 'outer', 'override', 'path', 'protected',
                           'public', 'return', 'root', 'select', 'siblings', 'static',
                           'string', 'text', 'then', 'this', 'true', 'var', 'when',
                           'where', 'while', 'wiki', 'with', 'word', 'final',
                           'tuple', 'union', 'and', 'not', 'null', 'or', 'xor', 'repeat',
                           'until', 'ref');

  function CSS() {
    return <<<CSS
$ .string { color: navy; }
$ .comment { color: gray; font-style: italic; }
$ .keyword { font-weight: bold; }
$ .wiki { color: green; }
CSS;
  }
}
