<?php
/*
  Note that {{Priority}} can only lower the priority of following format(s)
  (for this reason there's no "highest" priority).

  Example: {{Dynamic; Priority low; Include Appendix-A}} {{TOC}}
           - headings of Appendix-A won't be included into TOC.
*/

class Upriority_Root extends UWikiBaseAction {
  public $isFormatter = true;
  static $priorityAliases = array('lowest' => 0, 'low' => 0.3, 'normal' => 0.5, 'high' => 0.7);
  public $parameterOrder = array('new');

  function Execute($format, $params) { }

  function Priority($format, $params) {
    $newPriority = $params['new'];
    if (!self::IsEmptyStr($newPriority)) {
      $alias = &self::$priorityAliases[$newPriority];
      isset($alias) and $newPriority = $alias;
      return (int) UWikiMaxPriority * (is_numeric($newPriority) ? $newPriority : 0.5);
    }
  }
}

// This action will simply make format(s) following it run on render-time.
class Udynamic_Root extends UWikiBaseAction {
  function Execute($format, $params) { }
  function IsDynamic($format, $params) { return true; }
}
