<?php
/*
  This formatter lets you insert portions of raw HTML code into the output page.
  It works both in block or inline forms.

    %%(rawhtml)
      <iframe width="480" height="390" src="http://www.youtube.com/embed/videotag"
              frameborder="0" allowfullscreen></iframe>
    %%

    Some %%(rawhtml)<b>HTML 4-bold</b>%% text.

  Note that inserting HTML is not checked in any way so:
  1. Only enable this formatter on trusted resources to avoid XSS and other HTML-based attacks;
  2. Insert proper HTML - don't use block tags in inline %%-form, close them and so on.
*/

class Urawhtml_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;

  function Parse() {
    $format = $this->settings->format;
    $this->isBlock = $format ? $format->blockExpected : true;
  }

  function SelfToHtmlWith($contents) {
    return parent::SelfToHtmlWith($this->raw);
  }
}
