<?php
/*
  This action adds term to be replaced in current document. It works similar to
  Wacko's (?Term Description?) but it flood-replaces Term regardless of $expandTerms
  and $minTermLengthToExpand settings. Any number of arguments is allowed.

    {{Term HTML=HyperText Markup Language, RTFM=Please see the manual.}}
    {{Term LOL}}                        - description is set to "LOL" (the term itself)
*/

class Uterm_Root extends UWikiBaseAction {
  function Execute($format, $params) {
    foreach ($params as $term => $desc) {
      $desc === true and $desc = $term;
      $format->origDoc->settings->FloodReplaceTerm($term, $desc);
    }
  }
}
