<?php

class OtherTaskError extends Exception {
  public function __toString() {
    return sprintf("Unexpected error <%s> has occurred:\n%s", get_class($this), $this->message);
  }
}

  class EUnknownTask extends OtherTaskError { }

class EEnvironmentCheck extends OtherTaskError {
  public $failedChecks;

  function __construct($failedChecks) { $this->failedChecks = $failedChecks; }

  function ThrowIfAny($errors) {
    if ($errors = array_filter($errors)) { throw new self($errors); }
  }

  public function __toString() {
    $pl1 = count($this->failedChecks) > 1 ? 's' : '';
    $pl2 = count($this->failedChecks) > 1 ? 've' : 's';
    return "Environment check$pl1 ha$pl2 failed:\n* ".join("\n* ", array_keys($this->failedChecks));
  }
}

class EInterface extends OtherTaskError { }

  class EDestInterfaceWrite extends EInterface {
    public $path, $baseName;

    function __construct($path, $baseName) {
      $this->path = $path;
      $this->baseName = $baseName;
    }

    function __toString() { return "Error writing {$this->baseName} to {$this->path} (see -y)."; }
  }

    class EDestInterfaceRemove extends EDestInterfaceWrite {
      function __toString() { return "Error removing {$this->baseName} in {$this->path} (see -y)."; }
    }

class EExternalCommand extends OtherTaskError {
  public $commandline, $exitCode;

  function __construct($commandline, $exitCode) {
    $this->commandline = $commandline;
    $this->exitCode = $exitCode;
  }

  public function __toString() {
    return "External command has failed with exit code {$this->exitCode}: `{$this->commandline}`";
  }
}
