<?php
// When requested from browser this script will redirect to first existing
// localization's dir (e.g. ru/). If a path was contained in its query part (?path/file)
// it'll redirect t here rather than to the language's start page.
// Standard UWiki's .htaccess will redirect requests like /docs/@/API/Class -> index.php?API/Class

@list(, $request) = explode('@', $_SERVER['REQUEST_URI'], 2);
isset($request) or @list(, $request) = explode('%40', $_SERVER['REQUEST_URI'], 2);
$root = str_repeat( '../', substr_count($request, '/') );

$redirTo = &$_SERVER['QUERY_STRING'];
$lang = DetectLanguage( $_SERVER['HTTP_ACCEPT_LANGUAGE'] );
header("Location: $root$lang/$redirTo");


  function DetectLanguage($accepts, $default = 'en') {
    $languages = array();

    $accepts = explode(',', $accepts);
    foreach ($accepts as $piece) {
      @list($lang, $quality) = explode(';', $piece);

      if (@$quality and substr($quality, 0, 2) == 'q=') {
        $quality = floatval(trim( substr($quality, 2) ));
      } else {
        $quality = 1.0;
      }

      $languages[ round($quality * 1000) ] = trim($lang);  // *1000 because ksort() discard float values.
    }

    krsort($languages);

    foreach ($languages as $lang) {
      $lang = substr(trim($lang), 0, 2);  // = ISO
      if (is_dir($lang)) { return $lang; }
    }

    return $default;
  }
