<?php

function IsEmptyStr(&$str) { return $str === '' or $str === false or $str === null; }

function ExtOf($file) {
  return preg_match('~[^\\/](\.\w{1,5})$~', $file, $matches) ? $matches[1] : '';
}

function CopyDirInto($destDir, $src, $destInterface, $regexp = null) {
    $src = rtrim($src, '\\/');
    $destDir = rtrim($destDir, '\\/');

  $files = FindFilesRecursiveIn($src, $regexp);
  foreach ($files as &$file) { $destInterface->CopyFile("$src/$file", "$destDir/$file"); }
}

// $regexp can be a callback.
function CopyDir($src, $destInterface, $regexp = null) {
  CopyDirInto('', $src, $destInterface, $regexp);
}

  // $regexp is only checked for files, not directories. $regexp also can be a callback
  // of format: function ($baseName, $fullPath)
  function FindFilesRecursiveIn($dir, $regexp = null, $omitDirName = true) {
    $dir = rtrim($dir, '\\/');
    $omitDirName === true and $omitDirName = strlen($dir) + 1;

    $files = array();

    if (is_dir($dir)) {
      $handle = opendir($dir);

      // duh, even if the manual says readdir() only returns false it'll return null on wrong $handle.
      while (($file = readdir($handle)) !== false and $file !== null) {
        if (is_dir("$dir/$file")) {
          if ($file != '.' and $file != '..') {
            $files = array_merge( $files, FindFilesRecursiveIn("$dir/$file", $regexp, $omitDirName) );
          }
        } elseif (is_callable($regexp) ? call_user_func($regexp, $file, "$dir/$file")
                                       : (IsEmptyStr($regexp) or preg_match($regexp, $file))) {
          $files[] = substr("$dir/$file", $omitDirName);
        }
      }

      closedir($handle);
    }

    return $files;
  }

function RmDirRecursive($path) {
  // note that realpath() will return CWD on NULL $path thus we're risking removing the root.
  if (is_string($path) and $path) {
    $path = realpath($path);

    if (is_string($path) and strlen($path) > 20) {
      if (is_dir($path)) {
        $dir = opendir($path);

          while (($file = readdir($dir)) !== false and $file !== null) {
            if ($file !== '.' and $file !== '..') { RmDirRecursive("$path/$file"); }
          }

        closedir($dir);

        rmdir($path);
          if (is_dir($path)) { throw new Exception("Cannot remove directory $path"); }
      } else {
        return unlink($path);
      }
    }
  }
}

function TempPath() {
  $temp = sys_get_temp_dir();
  if (!$temp) {
    $file = tempnam(null, null);
    if ($file) {
      unlink($file);
      $temp = dirname($file);
    }
  }

  return ($temp ? rtrim($temp, '\\/') : '.').'/';
}

  function MakeTempDir($prefix = 'wacko') {
      $baseName = TempPath().$prefix;
      $index = 0;
    do { $temp = $baseName.++$index; } while (is_dir($temp));

    mkdir($temp);
    if (!is_dir($temp)) { throw new Exception("Cannot create temp directory $temp"); }

    return "$temp/";
  }
