<?php

class BUverseWiki {
  protected static $settings;   // access via Settings().

  static function ToHTML($text, $file = null, $options = array()) {
    return self::Format($text, $file, array('asHTML' => true) + $options);
  }

  static function Load() {
    $settings = &self::$settings;

    if (!$settings and defined('UWikiRootPath')) {
      include_once UWikiRootPath.'/uversewiki.php';

      if (class_exists('UWikiSettings')) {
        UWikiDocument::$loadedHandlers['wacko']['link'][] = array(__CLASS__, 'CorrectUWikiLink');

        $settings = new UWikiSettings;
        self::SetupSettings($settings);
      }
    }

    if (!$settings) {
      throw new BException('Cannot load UverseWiki framework.', 'path: '.UWikiRootPath);
    }
  }

  static function Quote($str, $markup = 'wacko') {
    self::Load();
    return UWikiDocument::Quote($str, $markup);
  }

  static function Settings() { return self::$settings->FullClone(); }

  // $file (in UTF-8) tells UWiki the base path of $text (for links, images, etc.).
  static function Format($text, $file = null, $options = array()) {
    $options += array('markup' => 'wacko', 'asHTML' => false, 'pageForSelfAnchorLinks' => '',
                      'allowedFormats' => false, 'post' => null);

    self::Load();

    try {
      $doc = new UWikiDocument($text);
    } catch (EUWikiLastPCRE $e) {
      self::RethrowPCRE($e);
    }

    $doc->settings = self::Settings();
    self::SetupPagerFor($file, $doc->settings, $options);

    $options += array('asHTML' => false, 'pageForSelfAnchorLinks' => '');
    $doc->settings->pageForSelfAnchorLinks = &$options['pageForSelfAnchorLinks'];

    $doc->LoadMarkup($options['markup']);
    $options['file'] = $file;
    BEvent::Fire('on uwiki format', array($doc, &$options));

    try {
      $doc->Parse();
    } catch (EUWikiLastPCRE $e) {
      self::RethrowPCRE($e);
    }

    return $options['asHTML'] ? $doc->ToHTML() : $doc;
  }

    static function RethrowPCRE($e) {
      $code = $e->pcreErrorCode;
      throw new BException("Couldn't format text using UverseWiki - PCRE error #$code,".
                           ' make sure that source document\'s encoding is UTF-8.', '', $e);
    }

    static function SetupSettings($settings) {
      $settings->rootURL = BConfig::$postURL;
      $settings->mediaURL = $settings->smileyURL = BConfig::$siteHome;

      // todo: move uwiki settings applying to an event handler.
      self::LoadSettingsTo($settings);

      $settings->LoadFrom( BConfig::FromUTF8('file name', BConfig::$paths['uwiki config']) );
      $settings->linkExt = '';
      $settings->hideDocTitle = true;

      DefinePager();
      $settings->pager = new BUverseWikiPager(BConfig::$paths['posts']);
      $settings->pager->nameConvertor = array('BConfig', '*FromUTF8', 'file name');
    }

      static function LoadSettingsTo($settings) {
        $conf = LoadKeyValuesFrom(BConfig::$paths['config'].'/uversewiki.conf');

        foreach ($conf as $setting => $value) {
          $setValue = &$settings->$setting;

          if (isset($setValue)) {
            if (is_bool($setValue)) {
              $setValue = BConfig::ToBool($value);
            } elseif (is_string($setValue)) {
              $setValue = $value;
            }
          } elseif (method_exists($settings, $setting)) {
            $settings->$setting($value);   // e.g. modes: NovelMode(1)
          }
        }
      }

    static function SetupPagerFor($file, $settings, $options) {
      $settings->pager->allowedFormats = $options['allowedFormats'];

      if ($file === null) {
        $settings->pager->SetCurrent('');
        $settings->BaseURL('');
      } else {
        $settings->pager->SetCurrent("/$file");
        $settings->BaseURL( dirname($file) );
      }
    }

  // UWiki 'link' callback:
  static function CorrectUWikiLink(&$caption, $linkObj) {
    if (!$linkObj->IsExternal() and $linkObj->Interwiki() === '') {
      $path = $linkObj->LocalPath();

      // $path can be empty for self-anchor links: ((#anchor)).
      if ($path !== '') {
        if ($path[0] === '@') {
          $newPath = "/$path";
        } elseif ($path[0] === '=' and BTags::IsCategory( substr($path, 1) )) {
          $newPath = "/$path";

          if ($caption[0] === '=' and $linkObj->usedEndingSubst) {
            $caption = substr($caption, 1);
          }
        } elseif ($post = $linkObj->pager->GetPostBy($path)) {
          $newPath = '/'.BPosts::RelativeUrlOf($post);
        }

        if (isset($newPath)) {
          $linkObj->LocalPath($newPath);
          return true;
        }
      }
    }
  }
}

function DefinePager() {
  if (!class_exists('UWikiFilePager')) {
    throw new BException('Cannot define BUverseWikiPager because UverseWiki\'s UWikiFilePager isn\'t loaded.');
  }

  class BUverseWikiPager extends UWikiFilePager {
    function BaseCluster() {
      return strpos($this->current, '/') ? dirname($this->current) : '';
    }

    function FileOf($page, $format, $isDir = false) {
      $file = parent::FileOf($page, $format, $isDir);
      if (!is_string($file) and !$isDir and $post = $this->GetPostBy($page)) {
        return $this->ConvertFileName( BConfig::FileOf('posts', $post) );
      } else {
        return $file;
      }
    }

      // todo: make an event and move all handlers there.
      function GetPostBy($path) {
        $path = ltrim($path, '\\/');

          // by post title:
          $post = BPosts::ByUrlTitle($path);

          // by post file name:
          if (!isset($post)) {
            $post = ltrim($this->ExpandLocal($path).BConfig::$postFileExt, '/');
            BPosts::Exists($post) or $post = null;
          }

          // by post date in format [YY]YYMMDD:
          $dateRegExp = '/^(\d\d(?:\d\d)?)(\d\d)(\d\d)(?:-(\d\d?))?$/';
          if (!isset($post) and preg_match($dateRegExp, $path, $match)) {
            @list(, $year, $month, $day, $seq) = $match;
            $seq = isset($seq) ? $seq - 1 : 0;

            $time = mktime(0, 0, 0, $month, $day, $year);
            if ($time > 0) {
              $posts = BPosts::By(array( array('dateday', $time) ));
              isset($posts[$seq]) and $post = $posts[$seq];
            }
          }

        return $post;
      }

    function ClusterExists($page) {
      $isCategory = (isset($page[0]) and ($page[0] === '=' or substr($page, 0, 2) === '/='));
      return ($isCategory and BTags::IsCategory( trim($page, '/=') ))
             or parent::ClusterExists($page);
    }

    function GetClusterTitle($cluster) {
      if ($cluster[0] === '=') {
        $tag = substr($cluster, 1);
        if (BTags::IsCategory($tag)) {
          return BTags::CaptionOf($tag);
        }
      }

      return parent::GetClusterTitle($cluster);
    }
  }
}
