<?php

class Plugins {
  static function All($sort = true) {
    $list = BIndex::SelectFrom('plugins');
    $sort and ksort($list);
    return $list;
  }

  static function IsAnyInstalled() { return count(self::All(false)) > 0; }
  static function IsInstalled($name) { return (bool) BIndex::SelectFrom('plugins', $name); }

  static function Info($name, $field = null) {
    $info = BIndex::SelectFrom('plugins', $name);
    return $field ? @$info[$field] : $info;
  }

    static function UserFilesOf($plugin, $existingOnly = true) {
      $func = self::Info($plugin, 'user files');
      $list = $func ? BEvent::CallSingle($func, array($plugin)) : array();

        if (is_array($list)) {
          foreach ($list as &$file) { $file = ToAbsolutePath($file); }
        } else {
          $list = $list === null ? array() : ((array) $list);
        }

      $existingOnly and $list = array_filter($list, 'file_exists');
      return $list;
    }

  // $locale can be either false (get default caption), true (get suiting user's locale)
  //         and a string (the name of locale to get caption of).
  static function CaptionOf($plugin, $locale = true) {
    if ($locale and class_exists('BLocali')) {
      $str = "$plugin: plugin caption ".($locale === true ? BLocali::UserLang() : $locale);
      if (($tr = Translate($str)) !== $str) { return $tr; }
      return self::CaptionOf($plugin, false);
    } else {
      $str = "$plugin: plugin caption";
      return ($tr = Translate($str)) === $str ? ucfirst($plugin) : $tr;
    }
  }

  static function Install($file, $mode = 'install') {
    $inst = new PluginInstallator($file);
    $inst->mode = $mode;
    $inst->Run();
  }

  // 'on different plugin checksum' will be fired for inexistent files too (in this case $current will be '').
  static function Uninstall($plugin, $options = array()) {
    if (isset( $options['diffChecksumCallback'] )) {
      $hook = array(__CLASS__, 'DiffChecksumCallback', $plugin, $options['diffChecksumCallback']);
      BEvent::Hook('on different plugin checksum', $hook);
    }

    try {
      PluginInstallator::Uninstall($plugin);
    } catch (Exception $e) { $ex = $e; }

    isset($hook) and BEvent::Unhook('on different plugin checksum', $hook);
    if (isset($ex)) { throw $ex; }
  }

    static function DiffChecksumCallback($plugin, $file, $current, $md5, $reactOnPlugin, $callback) {
      if ($plugin === $reactOnPlugin) {
        BEvent::CallSingle($callback, array($plugin, $file, $current, $md5));
      }
    }

  static function JoinBack($plugin) {
    if (!self::IsInstalled($plugin)) {
      throw new BException('Cannot join back plugin '.$plugin.' because it\'s not installed.');
    }

    $code = self::RejoinPrefaceOf($plugin).
            self::RejoinFilesOf($plugin);

    $func = self::Info($plugin, 'on join back');
    $func and BEvent::CallSingle($func, array($plugin, &$code));

    BEvent::Fire('on join back', array($plugin, &$code));

    return $code;
  }

    static function &RejoinPrefaceOf($plugin) {
      $code = "<?php\n".PluginInstallator::GetRegSectionOf($plugin);
      $code = preg_replace('/\r?\n *BConfig::\$strings\[\''.$plugin.': plugin caption( [a-z]{2})?\'] = .+; *(?=\r?\n|$)/u', '', $code);

      $code .= "\n\n/* one-shot */\n  \$this->name = '".$plugin."';";

      foreach (BConfig::$strings as $name => &$str) {
        $prefix = "$plugin: plugin caption";
        if (strpos($name, $prefix) === 0 and $str !== null) {
          $lang = trim( substr($name, strlen($prefix)) );
          $lang and $lang = ", '$lang'";

          $str = var_export($str, true);
          $code .= "\n  \$this->Caption($str$lang);";
        }
      }

      foreach (array('on finish', 'on unisntall', 'user files') as $field) {
        if ($value = self::Info($plugin, $field)) {
          if (is_array($value)) {
            $str = '';
            foreach ($value as $key => $val) {
              is_int($key) or $str .= var_export($key, true).' => ';
              $str .= var_export($val, true).', ';
            }
            $value = 'array('.substr($str, 0, -2).')';
          } else {
            $value = var_export($value, true);
          }

          $code .= "\n  \$this->info['$field'] = $value;";
        }
      }

      return $code;
    }

    static function &RejoinFilesOf($plugin) {
      $files = self::Info($plugin, 'files');

        // moving class scripts so they will come before possible one-shot "return;" block.
        $autoload = array();
        foreach ($files as $file => $md5) {
          if (BConfig::FileOf('plugins', basename($file, '.php').'.php') === $file) {
            $autoload[$file] = $md5;
            unset($files[$file]);
          }
        }

        $files = $autoload + $files;

      $code = '';

        $isReturnPut = false;
        foreach ($files as $file => $md5) {
          $data = file_get_contents($file);

          $hasPhpExt = ExtOf($file) === '.php';
          if ($hasPhpExt and BConfig::FileOf('plugins', basename($file)) === $file) {
            $file = basename($file, '.php');

            $data = trim($data, "\r\n");
            substr($data, 0, 5) === "<?php" and $data = substr($data, 5);
          } else {
            if (strpos($file, BConfig::$enginePath) === 0) {
              $file = substr($file, mb_strlen(BConfig::$enginePath));
            }
            if (!$isReturnPut and (!$hasPhpExt or strpos($data, '<?php') !== false)) {
              $code .= "\n\n/* one-shot */\nreturn;\n?>";
              $isReturnPut = true;
            }
            if (self::IsBinary($data)) {
              $file = "base64:$file";
              $data = trim( chunk_split(base64_encode($data), 76, "\n") );
            }
          }

          $data = trim(str_replace("\r\n", "\n", $data), "\n");
          $code .= "\n\n/* install $file */\n".$data;
        }

      return $code;
    }

      static function IsBinary(&$data) {
        return preg_match('/[\x00-\x08\x0C\x0E-\x1F]/', substr($data, 0, 512));
      }
}
