<?php

class WikiCache {
  static function Exists($name) { return is_file( self::FileOf($name) ); }

  static function FileOf($name) {
    // ".php" extension is to prevent people from browsing cache like http://.../cache/wiki/...
    return BConfig::FileOf( 'cache', BConfig::FromUTF8('file name', "wiki/$name.php") );
  }

  // $name must contain paths that are valid for file system (use md5() if you need)
  //       and must be in UTF-8 rather than native file system encoding.
  static function Get($name, $fileToRead = null, $contents = null) {
    $file = self::FileOf($name);
    $cachedExists = is_file($file);
    $srcExists = ($fileToRead !== null and is_file($fileToRead));

    if ($cachedExists and $fileToRead !== null and !$srcExists) {
      self::Delete($name);
    } elseif ($cachedExists and ($fileToRead === null or
                                 filemtime($file) < filemtime($fileToRead))) {
      $data = file_get_contents($file);
      strtok($data, "\n");    // first line is "exit()", see Store().
      return strtok(null);
    } elseif ($srcExists) {
      $contents === null and $contents = file_get_contents($fileToRead);
      $html = self::Format($contents);
      self::Store($name, $html);
      return $html;
    }
  }

  static function Store($name, &$data) {
    $file = self::FileOf($name);
    MkDirOf($file);
    if (!is_int( file_put_contents($file, "<?php exit()?>\n".$data) )) {
      throw new BException('Cannot save wiki-cache file - make sure it\'s writable.', 'file: '.$file);
    }
  }

  static function Delete($name) { unlink(self::FileOf($name)); }

  // $file tells UWiki the base path of $text (for links, images, etc.).
  static function Format($wikiText, $file = null) {
    return BUverseWiki::ToHTML($wikiText, $file);
  }
}
