<?php
/* All paths/URLs of BConfig include trailing / */
mb_language('uni');
mb_internal_encoding('UTF-8');
mb_regex_encoding('UTF-8');

BEvent::HookFirst('on start', array('BConfig', 'LoadFrom'));
BEvent::HookFirst('on start', array('BConfig', 'LoadAutoInc'));
BEvent::Hook('on start', array('BConfig', 'InstallNew'));
BEvent::Hook('on output', array('BConfig', 'PrepareOutput'));

BEvent::Hook('post footer', array('BConfig', 'ViewSourceToFooter'));
BEvent::Hook('on tpl vars: common', array('BConfig', 'AddShareBoxTo'));
BEvent::Hook('on tpl vars: before filling', array('BConfig', 'RemoveTemplateMetadata'));
BEvent::Hook('normalize post', array('BConfig', 'AddPostHeaderFooter'));
BEvent::Hook('normalize comment', array('BConfig', 'RemoveHiddenCommentingFieldsFrom'));

BEvent::Hook('mail: send', array('BConfig', 'SimulateEMail'));
BEvent::Hook('mail: transmit', array('BConfig', 'TeeEMail'));

BEvent::Hook('event fired', array('BConfig', 'LogEvent'));
BEvent::Hook('is robot agent', array('BConfig', 'IsRobotAgent'));

// current dir changes to random values in shutdown handler when running PHP under Apache.
BEvent::$list['on end'] = (array) @BEvent::$list['on end'];
array_unshift(BEvent::$list['on end'], array('BConfig', 'SetRealCWD'));

class BConfig {
  static $defProps;
  // may be an empty string or absolute URL (start with http:// or /); is relative to $siteHome.
  static $engineUrlPath = '_blog';

  static $enginePath;
  static $baseURL, $engineURL;  // aliases to $siteHome/ and $siteHome/_blog/
  static $secret = "1_\4Ze)a!";

  // attention: all paths in $paths must be expanded (otherwise FileOf() will fail).
  static $paths = array('posts' => '../', 'thumbs' => 'thumbs/',
                        'stdtpl' => 'stdtpl/', 'template' => 'template/',
                        'config' => 'config/',
                        'static' => 'static/',
                        'template config' => 'template/config/',
                        'uwiki config' => 'uwiki/config/',
                        'plugins' => 'engine/autoload/plugins/',
                        'comments' => 'comments/', 'cache' => 'cache/',
                        'compiled' => 'cache/template/', 'index' => 'index/',
                        'avatars' => 'http://www.gravatar.com/avatar/{HASH}?s={SIZE}&d=identicon');
  static $postURL = '..';
  static $thumbsURL = 'thumbs';
  static $staticURL = 'static';
  static $cacheURL = 'cache';
  static $sidebarURL = 'config/sidebars';

  static $mail = array('from' => 'robot@example.com', 'returnPath' => 'robot@example.com',
                       'bodyEncoding' => 'base64', 'bodyCharsets' => array('iso-8859-1'),
                       'forceBodyCharset' => false, 'makeTextBodyFromHTML' => true,
                       'textBodyFormat' => 'flowed', 'headerEOLN' => "\n",
                       'sortHeaders' => true, 'params' => '', 'attachments' => '',
                       'tee' => '0', 'teePath' => 'mail/',
                       'extraHeaders' => array(), 'allowedHeaders' => array(),
                       'bodyMIME' => array());

  static $menus = array();

  // on Windows available charsets are listed in registry at HKCR\MIME\Database\Charset.
  static $charsets = array('file name' => 'ISO-8859-1');
  static $installations = true;  // true/false/'debug'; config/install-XXX.png
  static $reuseRenderedDoc = false;

  static $postsPerPage = 8;  // 0 = unlimited.
  static $shortenCount = 10; // 0 = unlimited.
  static $extraShortenCount = 3;  // 0 = no soft limit, always shorten if > shortenCount.
  static $shortenCountForThreads = 2;  // 0 = do not display post's text.

  static $commentMarkup = 'wiki';
  static $canCommentPosts = true, $enableThreads = true;
  static $commentsPerPage = 0;  // 0 = unlimited.
  static $commentNestingLimits = array(10, 5);
  static $maxCommentNesting = 6;
  static $consistentCommentIDs = true;
  static $commentSorting = 'TimeDesc';
  static $postFileExt = '.wiki';  // including leading period.
  static $extraCSS = array();
  static $categoryFromPath = true;
  static $maxPermalinkLength = 70;
  static $permalinkFormat = '$title';
  static $autoTail = true;    // wheither or not permalink will get 3-char tail appended.
  static $extraPostLinks = array();
  protected static $allowedFormatsForPosts = array();   // access via AllowedFormatsForPosts().
  protected static $hideCommentingFields = array();     // access via IsCommentingFieldEnabled().
  protected static $pageTitle = array();               // access via PageTitleFor().
  protected static $skipHtmlMetadata = array();         // used internally by RemoveTemplateMetadata().

  static $avatars = 'gravatar';
  static $avatarSizes = array(20, 40, 60, 80, 100);

  static $strings = array();
  static $stdTpl, $sessionMotto;
  static $lastCWD;

  static function LoadAutoInc() {
    $scripts = glob(self::$paths['config'].'load-*.php');
    foreach ($scripts as $file) {
      require_once $file;
    }
  }

  static function InstallNew() {
    if (self::$installations) {
      $plugins = glob(self::$paths['config'].'install-*.php');

      if ($plugins) {
        $wasLocked = (self::$installations !== 'debug' and
                      SiteLock::TryLocking('lock message: installing plugins', 2));
        try {
          foreach ($plugins as $file) {
            $install = new PluginInstallator($file);
            $install->deleteSetupFile = true;
            self::$installations === 'debug' and $install->mode = 'debug';

            $install->Run();
          }
        } catch (Exception $e) { $ex = $e; }

        $wasLocked and SiteLock::Unlock();
        if (isset($ex)) { throw $ex; }
      }
    }
  }

  static function PrepareOutput($page) {
    header("Content-Type: {$page->mime}; charset={$page->charset}");
    ob_start('ob_gzhandler');
  }

  static function SetRealCWD() { self::$lastCWD and chdir(self::$lastCWD); }

  static function ViewSourceToFooter(&$footer, $post) {
    if (is_file( self::FromUTF8('file name', self::FileOf('posts', $post)) )) {
      $wiki = self::$postURL.self::ToUTF8('file name', $post);
      $footer[] = '<strong><a rel="noindex nofollow" href="'.$wiki.'">'.Translate('View source').'</a></strong> '.
                  Translate('(wiki-text)');
    }
  }

  static function AddPostHeaderFooter(&$text, $post, &$info) {
    $root = self::$paths['config'];

    if (is_file( $file = $root.'postHeader'.self::$postFileExt )) {
      $text = file_get_contents($file)."\n\n".$text;
    }
    if (is_file( $file = $root.'postFooter'.self::$postFileExt )) {
      $text = $text."\n\n".file_get_contents($file);
    }
  }

  static function AddPostExtraLinks(&$text, $post, &$info) {
    foreach (self::$extraPostLinks as $format) {
      $info['links'][] = BPosts::FormatLinkFor($info, $format, $post);
    }
  }

  static function HideCommentingFieldsFrom(&$vars, $varPrefix, $post, $isEnabled) {
    $fields = &$vars[$varPrefix.'Fields'];

    if (is_array($fields)) {
      foreach ($fields as $i => $field) {
        if (!self::IsCommentingFieldEnabled($field['type'], $post)) { unset($fields[$i]); }
      }
    }
  }

    static function RemoveHiddenCommentingFieldsFrom(&$parent, &$comment, &$info) {
      foreach ($info as $field => &$value) {
        if (!self::IsCommentingFieldEnabled($field)) {
          $value = null;
        }
      }
    }

  static function LogEvent($event, $args) {
    static $evtNesting = 0;

    $nesting = str_repeat('  ', $evtNesting);
    $msg = $nesting."`$event`";

    if (in_array(substr($event, 0, 8), array('prehook:', 'posthook'))) {
      $msg .= ' <...>';
      if ($event[1] === 'r') {
        ++$evtNesting;
      } else {
        --$evtNesting;
        $msg .= ' |^|';
      }
    } else {
      $array = array();
      foreach ($args as $key => $arg) {
        $type = gettype($arg);

        if (is_object($arg)) {
          $arg = get_class($arg);
        } elseif (is_array($arg)) {
          $arg = 'length='.count($args);
        } elseif (!is_scalar($arg)) {
          $arg = '';
        }

        $array[] = "$nesting  $key. <$type> $arg";
      }

      $array and $msg .= "\n".join("\n", $array)."\n";
      $msg = $nesting."\n$msg";
    }

    $file = self::$enginePath.'events.log';
    if (is_file($file) and filemtime($file) < time() - 1) { unlink($file); }
    file_put_contents($file, $msg."\n", FILE_APPEND | LOCK_EX);
  }

  static function GetStdTpl() {
    if (!self::$stdTpl) {
      include_once self::$paths['stdtpl'].'templater.php';
      if (!class_exists('StdTpl')) {
        throw new BException('Cannot load StdTpl framework from '.self::$paths['stdtpl']);
      }

      self::$stdTpl = new StdTpl(self::$paths['template']);
      self::$stdTpl->dateLang = Translate('iso-2');
      self::$stdTpl->configPath = self::$paths['template config'];
      self::$stdTpl->compiledPath = self::$paths['compiled'];
    }

    return self::$stdTpl;
  }

  static function SessionMotto() {
    $phrase = &self::$sessionMotto;

      if (!isset($phrase)) {
        $file = self::$paths['config'].'mottos.txt';
        $contents = file_get_contents($file);
        if (mb_strpos($contents, "\n*")) {
          $isRobot = IsRobotAgent();

          $phrases = array();
          foreach (explode("\n", $contents) as $line) {
            if (trim($line) !== '' and !($line[0] === '*' xor $isRobot)) {
              $phrases[] = ltrim($line, '*');
            }
          }
        } else {
          $phrases = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        }

        $phrases and $phrase = trim($phrases[ array_rand($phrases) ]);
      }

    return $phrase;
  }

  static function LoadFrom($path = null) {
      $path or $path = self::$paths['config'];
      $path = rtrim($path, '\\/');

    static $complex = array('template url' => 'templateURL',
                            'license url'  => 'licenseURL',
                            'admin email' => 'adminEMail');

    $info = LoadKeyValuesFrom("$path/info.conf", '=') +
            LoadKeyValuesFrom("$path/other.conf", '=');

    foreach ($info as $name => $value) {
      $prop = &$complex[ strtolower($name) ];
      $prop or $prop = self::SettingNameToProp($name);

      if (@self::$defProps[$prop] === '' and $prop !== 'templateURL' and $prop !== 'licenseURL') {
        if ($value and (strpos($prop, 'URL') or strpos($prop, 'Home'))) {
          $value = rtrim($value, '\\/').'/';
        }

        if ($prop === 'siteHome') {
          self::SetSiteHomeTo($value);
        } else {
          self::$$prop = $value;
        }
      } else {
        self::SetNonVarOption($name, $value);
      }
    }

    self::Normalize();
    self::$lastCWD = getcwd();
    is_file("$path/blog lang.conf") and self::LoadLocalization("$path/blog lang.conf");

    self::LoadMenuFrom("$path/menu.conf");
  }

    static function SettingNameToProp($name) { return preg_replace('/ ([a-z])/e', 'strtoupper("\\1")', $name); }

    static function SetSiteHomeTo($siteHome) {
      self::$siteHome = $siteHome;
      self::$baseURL = $siteHome;

      if (((string) self::$engineUrlPath) === '') {
        self::$engineURL = $siteHome;
      } else {
        self::$engineURL = rtrim(ToAbsoluteURL(self::$engineUrlPath), '/').'/';
      }

      foreach (get_class_vars(__CLASS__) as $name => $value) {
        if (substr($name, -3) === 'URL') {
          self::$$name = ToAbsoluteURL( rtrim($value, '\\/').'/', self::$engineURL );
        }
      }
    }

    static function SetNonVarOption($name, $value) {
        $name = strtolower($name);

      if ($name === 'posts per page') {
        self::SetIntTo('postsPerPage', $value);
      } elseif ($name === 'shorten count') {
        self::SetIntTo('shortenCount', $value);
      } elseif ($name === 'shorten count for threads') {
        self::SetIntTo('shortenCountForThreads', $value);
      } elseif ($name === 'shorten soft limit') {
        self::SetIntTo('extraShortenCount', $value);
      } elseif ($name === 'max permalink length') {
        self::SetIntTo('maxPermalinkLength', $value);
      } elseif ($name === 'permalink format') {
        self::$permalinkFormat = $value;
      } elseif ($name === 'comment markup') {
        self::$commentMarkup = strtolower($value);
      } elseif ($name === 'avatars') {
        self::$avatars = strtolower($value);
      } elseif ($name === 'comments per page') {
        self::SetIntTo('commentsPerPage', $value);
      } elseif ($name === 'comment nesting limits') {
        $limits = preg_split('/[,>\s]+/', $value, -1, PREG_SPLIT_NO_EMPTY);

          foreach ($limits as $i => &$limit) {
            if (!is_numeric($limit)) { return; }
            $limit = (int) $limit;
            if ($limit === 0) {
              $limits = array_slice($limits, 0, $i);
              break;
            }
          }

        self::$commentNestingLimits = $limits;
      } elseif ($name === 'comment sorting') {
        self::$commentSorting = ucfirst( self::SettingNameToProp($value) );
      } elseif ($name === 'max comment nesting') {
        self::SetIntTo('maxCommentNesting', $value);
      } elseif ($name === 'can comment posts') {
        self::SetBoolTo('canCommentPosts', $value);
      } elseif ($name === 'enable threads') {
        self::SetBoolTo('enableThreads', $value);
      } elseif ($name === 'consistent comment ids') {
        self::SetBoolTo('consistentCommentIDs', $value);
      } elseif ($name === 'count events') {
        BEvent::$countEvents = self::ToBool($value);
      } elseif ($name === 'category from path') {
        self::SetBoolTo('categoryFromPath', $value);
      } elseif ($name === 'reuse rendered doc') {
        self::SetBoolTo('reuseRenderedDoc', $value);
      } elseif ($name === 'auto tail') {
        self::SetBoolTo('autoTail', $value);
      } elseif ($name === 'installations') {
        $value = strtolower($value);
        $value === 'debug' or $value = self::ToBool($value);
        self::$installations = $value;
      } elseif ($name === 'avatar sizes') {
        $sizes = array('20', '40', '60', '80', '100');
        self::SetEnumTo('avatarSizes', $value, $sizes);
        self::$avatarSizes or self::$avatarSizes = $sizes;
      } elseif ($name === 'uwiki path') {
        $value = rtrim($value, '\\/');

        if (!defined('UWikiRootPath')) {
          define('UWikiRootPath', ToAbsolutePath($value));
        }
      } elseif (substr($name, -5) === ' path' and
                isset(self::$paths[ substr($name, 0, -5) ])) {
        if (!strpos($value, '://')) {
          $value = ExpandLeaveLinks( ToAbsolutePath($value) );
        } else {
          $value = rtrim($value, '\\/');
        }

        self::$paths[ substr($name, 0, -5) ] = $value.'/';
      } elseif ($name === 'thumbs url' or $name === 'post url' or $name === 'static url'
                or $name === 'cache url' or $name === 'template url' or $name === 'license url'
                or $name === 'sidebar url') {
        $prop = strtok($name, ' ');
        $prop .= strtoupper( strtok(null) );

        if ($value === '') {
          self::$$prop = null;
        } else {
          if ($value[0] !== '/') {
            if (rtrim($value, '\\/') === '..') {    // this is handy for $postURL.
              $value = dirname(self::$engineURL);
            } else {
              $value = self::$engineURL.$value;
            }
          }

          $name === 'license url' or $value = rtrim($value, '\\/').'/';
          self::$$prop = $value;
        }
      } elseif (substr($name, -8) === ' charset' and
                isset(self::$charsets[ substr($name, 0, -8) ])) {
        self::$charsets[ substr($name, 0, -8) ] = $value;
      } elseif ($name === 'post file ext') {
        $value = trim($value, '.');
        self::$postFileExt = $value === '' ? '' : ".$value";
      } elseif ($name === 'extra css') {
        if ($value = trim($value)) {
          foreach (explode('|', $value) as $css) {
            self::$extraCSS[] = ToAbsoluteURL(trim($css), BConfig::$engineURL);
          }
        }
      } elseif ($name === 'secret') {
        self::$secret = $value;
      } elseif ($name === 'allowed formats for posts') {
        $value = strtolower($value);
        switch ($value) {
        case 'all':   $allowed = true; break;
        case 'none':  $allowed = false; break;

        default:
          $allowed = array();
          foreach (explode(' ', $value) as $ext) {
            $allowed[ trim($ext, '.') ] = true;
          }
        }

        self::$allowedFormatsForPosts = $allowed;
      } elseif ($name === 'extra post links') {
        $links = explode('|', $value);
        foreach ($links as &$link) { $link = trim($link); }
        self::$extraPostLinks = $links;
      } elseif ($name === 'hide commenting fields') {
        self::$hideCommentingFields = array_flip(array_filter( explode(' ', $value) ));
      } elseif (strpos($name, 'page title (') === 0 or strpos($name, 'skip html metadata (') === 0) {
        list($prop, $pageType) = explode('(', rtrim($name, ')'), 2);
        $prop = self::SettingNameToProp( trim($prop) );

          if ($prop === 'skipHtmlMetadata') {
            if ($value) {
              $value = explode(',', $value);
              foreach ($value as &$val) { $val = trim($val); }
            } else {
              $value = array();
            }
          }

        $prop = &self::$$prop;
        $prop[$pageType] = $value;
      } elseif ($name === 'new file perms' and $value !== '') {
        $umask = 0;

          if (is_numeric($value)) {
            $umask = octdec($value);
          } elseif ($scopes = explode(' ', $value) and count($scopes) === 3) {
            foreach ($scopes as $i => $scope) {
              strpos($scope, 'r') === false or $umask |= 4 << ((2 - $i) * 3);
              strpos($scope, 'w') === false or $umask |= 2 << ((2 - $i) * 3);
              strpos($scope, 'x') === false or $umask |= 1 << ((2 - $i) * 3);
            }
          }

        $umask > 0 and umask(~$umask);
      } elseif (strtok($name, ' ') === 'mail') {
        self::SetMailOpt(strtok(null), $value);
      }
    }

      static function SetMailOpt($name, $value) {
        static $special = array('make text body from html' => 'makeTextBodyFromHTML',
                                'header eoln' => 'headerEOLN', 'body mime' => 'bodyMIME');

        $name = isset($special[$name]) ? $special[$name] : self::SettingNameToProp($name);
        $setTo = &self::$mail[$name];

        if (is_bool($setTo)) {
          $setTo = self::ToBool($value);
        } elseif (is_string($setTo)) {
          if ($name === 'teePath') {
            $tail = substr($value, -1);   // ExpandLeaveLinks() removes trailing slash.
            $value = ExpandLeaveLinks( ToAbsolutePath($value) );

            if ($tail !== $value[strlen($value) - 1] and $tail === '/' or $tail === '\\') {
              $value .= '/';
            }
          }

          $setTo = $value;
        } elseif ($name === 'bodyCharsets') {
          $setTo = explode(' ', $value);
        } elseif ($name === 'extraHeaders') {
          $setTo = array();

          foreach (explode('|', $value) as $header) {
            list($hdrName, $hdrValue) = explode(':', $header, 2);

            if (isset($hdrValue)) {
              $hdrName = trim($hdrName);
              $hdrValue = trim($hdrValue);

              if (isset($setTo[$hdrName])) {
                is_array($setTo[$hdrName]) or $setTo[$hdrName] = array($setTo[$hdrName]);
                $setTo[$hdrName][] = $hdrValue;
              } else {
                $setTo[$hdrName] = $hdrValue;
              }
            }
          }
        } elseif ($name === 'allowedHeaders') {
          $setTo = array();

          if ($value !== '-') {
            $setTo['-'] = $value[0] === '-';

            $headers = explode(' ', ltrim($value, '-'));
            foreach ($headers as $header) { $header === '' or $setTo[] = $header; }
          }
        } elseif ($name === 'bodyMIME') {
          $setTo = explode(' ', $value);
        }
      }

      static function SetBoolTo($prop, $value) { self::$$prop = self::ToBool($value); }

        static function ToBool($value) {
          return in_array($value, array('1', 'on', 'yes', 'y'));
        }

      static function SetIntTo($prop, $value) {
        if (!is_numeric($value)) {
          $value = var_export($value, true);
          throw new BException("Value of $prop config options must be numeric, $value given.");
        } else {
          self::$$prop = (int) $value;
        }
      }

      static function SetEnumTo($prop, $str, $possible) {
        $given = preg_split('/[,\s]+/', strtolower($str), -1, PREG_SPLIT_NO_EMPTY);
        self::$$prop = array_intersect($given, $possible);
      }

    static function Normalize() {
      self::$templateURL === '' and self::$templateURL = self::$engineURL.'template/';
    }

    static function LoadMenuFrom($file) {
      self::$menus = array( array() );
      $menuIndex = 0;

      if (is_file($file)) {
        $stack = array( &self::$menus[0] );

        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
          if (!strpbrk($line[0], '#;') and ($line = rtrim($line)) !== '') {
            if (isset($line[2]) and trim($line, '-=*~') === '') {
              self::$menus[ ++$menuIndex ] = array();
              $stack = array( &self::$menus[$menuIndex] );
            } else {
              $level = mb_strlen($line);
              $line = ltrim($line);
              $level = (int) (($level - mb_strlen($line)) / 2);

                if ($level > count($stack)) {
                  ++$level;
                  throw new BException("Cannot load menu from $file - too much indentation (must".
                                       ' be of level '.count($stack)." of below, got $level.");
                } elseif ($level + 1 > count($stack)) {
                  $stack[] = &$menu['submenu'];
                }

              if ($line[0] === '[') {
                $iconName = strtok(substr($line, 1), ']');
                $line = strtok(null);
                $line === false and $line = $iconName;
                $iconName = strtolower($iconName);
              } else {
                $iconName = null;
              }

              @list($url, $caption) = explode('==', $line, 2);
              $url = rtrim($url);
              $caption = ltrim($caption);

                if ($caption === '') {
                  if ($url[0] === '/' or strpos($url, ':') !== false) {
                    $caption = $url;
                  } else {
                    $caption = BTags::CaptionOf($url);
                  }
                }

              if ($url[0] === '/') {
                $url = self::$siteHome.substr($url, 1);
              } elseif (strpos($url, ':') === false) {
                $url = self::$siteHome."=$url";
              }

              $submenu = array();

              array_splice($stack, $level + 1);
              $menu = &$stack[ count($stack) - 1 ][];
              $isCurrent = false;  // todo:
              $menu = compact('url', 'caption', 'submenu', 'isCurrent');

              if ($iconName) {
                $iconBase = self::FromUTF8('file name', self::FileOf('static', 'menu'));
                foreach (array(16, 24, 32, 64) as $size) {
                  if ($file = FindImage("$iconBase/$iconName-$size")) {
                    $menu['icon'.$size] = self::$staticURL.'menu/'.basename($file);
                  }
                }
              }
            }
          }
        }
      }
    }

  static function LoadLocalization($file) {
    self::$strings = LoadKeyValuesExt($file) + self::$strings;
  }

  static function FileOf($group, $file) {
    self::$lastCWD = getcwd();

    $base = self::$paths[$group];
    if (!isset($base)) { throw new BException('FileOf() - unknown $group '.$group); }

    $real = ExpandLeaveLinks($base.$file);
    if (strpos($real, strtr($base, '\\', '/')) !== 0) {
      throw new BException('FileOf() - $file '.$file.' pointed outside of base path ('.$base.').');
    }

    return $real;
  }

  static function ToUTF8($sourceType, $str) {
    return self::ConvertCharset(@self::$charsets[$sourceType], true, $str);
  }

  static function FromUTF8($destType, $str) {
    return self::ConvertCharset(@self::$charsets[$destType], false, $str);
  }

    static function ConvertCharset($charset, $toUTF8, $str) {
      if (strtolower($charset) === 'iso-8859-1') {
        $str = $toUTF8 ? utf8_encode($str) : utf8_decode($str);
      } elseif ($charset) {
        if (function_exists('iconv')) {
          $toUTF8 or $charset .= '//IGNORE';
          $str = iconv($toUTF8 ? $charset : 'UTF-8', $toUTF8 ? 'UTF-8' : $charset, $str);
        } else {
          throw new BException('Iconv PHP module is necessary for charset conversion to work.');
        }
      }

      if (is_string($str)) {
        return $str;
      } else {
        $to = $toUTF8 ? 'from' : 'to';
        throw new BException("Cannot convert charset $to $charset.");
      }
    }

  static function IsRobotAgent(&$result, $str) {
    static $list;

    if (!$list) {
      $list = file(self::FileOf('config', 'robots.txt'), FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
      foreach ($list as &$agent) { $agent = trim($agent); }
    }

    foreach ($list as &$agent) {
      if (strpos($str, $agent) !== false) {
        $result = true;
        return true;
      }
    }
  }

  static function AllowedFormatsForPosts() {
    $allowed = self::$allowedFormatsForPosts;
    if (is_array($allowed)) {
      $allowed[ ltrim(self::$postFileExt, '.') ] = true;
      $allowed = array('*dir' => true, 'wacko' => true,
                       ltrim(self::$postFileExt, '.') => true) + $allowed;
    }
    return $allowed;
  }

  static function IsCommentingFieldEnabled($fieldType, $post = null) {
    return $fieldType === 'message' or !isset( self::$hideCommentingFields[$fieldType] );
  }

  // $vars should include the prefix (e.g. "$" for "$VAR") if necessary.
  static function PageTitleFor($pageType, $default, $vars = array()) {
    $title = &self::$pageTitle[$pageType];
    trim($title) === '' and $title = $default;
    $title = htmlspecialchars8($title, ENT_QUOTES, false);

    static $infoVars = array('siteName', 'siteDesc', 'siteKeywords', 'copyright',
                             'licenseName', 'adminName', 'adminEMail');
    foreach ($infoVars as $name) { $vars['$'.$name] = self::$$name; }
    foreach ($vars as &$value) { $value = htmlspecialchars8($value, ENT_QUOTES); }

    return strtr($title, $vars);
  }

  static function AddShareBoxTo(&$vars) {
    $file = self::FileOf('config', 'share.html');
    is_file($file) and $vars['shareBox'] = file_get_contents($file);
  }

  static function RemoveTemplateMetadata($page, &$vars) {
    $toRemove = &self::$skipHtmlMetadata[$page];
    isset($toRemove) or $toRemove = &self::$skipHtmlMetadata['other'];

    if ($toRemove) {
      foreach ($toRemove as $name) { $vars['headMeta'][$name] = null; }
    }
  }

  static function SimulateEMail(EMail $email) {
    self::$mail['tee'] === 'simulate' and $email->simulateSending = true;
  }

  static function TeeEMail(&$subject, &$headers, &$body, EMail $email) {
    $headerCopy = $headers;
    $headerCopy['To'] = isset($headerCopy['To']) ? ((array) $headerCopy['To']) : array();
    $headerCopy['To'][] = $email->NormAddress( $email->to[0] );

    $eml = 'Subject: '.$email->OneLiner($subject).$email->eoln.
           $email->JoinHeaders($headerCopy, true).
           $body;

    $prefix = self::$mail['teePath'];
    $path = strpbrk(substr($prefix, -1), '\\/') ? $prefix : dirname($prefix);

    $index = is_dir($path) ? max(1, count(scandir($path)) - 1) : 1;
    while (is_file($file = "$prefix$index.eml")) { ++$index; }

    MkDirOf($file);
    file_put_contents($file, $eml, LOCK_EX);
  }

  /*
    ** Common StandardTemplate vars **
    MISSING: head/body-Header/Footer page pageTitle motto social searchURL
    searchName searchQuery primaryMenu secondaryMenu footerNotice generator*
    THESE ARE SET BY ACTIONS: page pageTitle footerNotice
    OTHERS - BY BTplVars::Set('common')
  */
  static $siteName = '', $siteHome = '';
  static $siteDesc = '', $siteKeywords = '';
  static $templateURL = '';
  static $logo16 = '', $logo24 = '', $logo32 = '', $logo48 = '', $logo64 = '', $logo128 = '';
  static $topmostImage = '';
  static $copyright = '', $licenseName = '', $licenseURL = '';
  static $adminName = '', $adminEMail = '';
}

BConfig::$defProps = get_class_vars('BConfig');

$enginePath = defined('BlogRootPath') ? BlogRootPath : dirname(dirname(__FILE__));
BConfig::$enginePath = rtrim($enginePath, '\\/').'/';

  foreach (BConfig::$paths as &$path) {
    if ($path === '../') {
      $path = dirname(BConfig::$enginePath);
    } else {
      $path = ToAbsolutePath($path);
    }
    $path = rtrim($path, '\\/').'/';
  }
