<?php

class BEvent {
  // will Fire event with given name before each event is fired making all event calls
  // much slower then normal so use for debug only.
  const OnEventEvent = null;  // 'event fired' event will log everything to events.log.

  // 'event' => array(array(call, able), ...); return true to stop the chain.
  // if callable is an array its 1-2 indexes are class/method while others - arguments to pass.
  static $list = array();

  static $countEvents = false;
  static $fireCounts = array();   // is only filled when $countEvents is enabled.

  static function Fire($event, $args = array()) {
    is_array($args) or $args = array($args);    // '(array) object' converts its props to array.

      if (self::OnEventEvent) {
        $logArgs = array($event, $args);
        foreach (self::$list[self::OnEventEvent] as $callback) {
          self::Call($callback, $logArgs);
        }
      }

      if (self::$countEvents and ($event[0] !== 'p' or
          (strpos($event, 'prehook: ') !== 0 and strpos($event, 'posthook: ') !== 0))) {
        isset(self::$fireCounts[$event]) ? ++self::$fireCounts[$event]
                                         : (self::$fireCounts[$event] = 1);
      }

    $handlers = &self::$list[strtolower($event)];
    if ($handlers) {
      foreach ($handlers as $callback) {
        $id = self::IdOfCallback($callback);

        self::Fire("prehook: $id", $args);
        $doBreak = self::Call($callback, $args);
        self::Fire("posthook: $id", $args);

        if ($doBreak !== null) { return $doBreak; }
      }
    }
  }

    static function IdOfCallback($callback) {
      if (is_array($callback)) {
        // e.g. CallInstanceOf() is called on self:
        $callback[0] === __CLASS__ and $callback = array_slice($callback, 2);
        return "$callback[0]>$callback[1]";
      } else {
        return $callback;
      }
    }

      // it has no &$arg.
      static function CallSingle($callback, array $args = array()) { return self::Call($callback, $args); }

      // from UWikiDocument::Call().
      static function Call($callback, array &$args) {
        if (is_array($callback) and count($callback) > 2) {
          $callArgsFirst = $callback[1][0] === '*';
          if ($callArgsFirst) {
            $callArgs = array_merge(array_splice($callback, 2), $args);
          } else {
            $callArgs = array_merge($args,  array_splice($callback, 2));
          }
        } else {
          $callArgs = $args;
        }

        is_array($callback) and $callback[1] = ltrim($callback[1], '*');
        return call_user_func_array($callback, $callArgs);
      }

  static function CanCall($callback) {
    if ($callback) {
      if (is_array($callback) and isset($callback[1])) {
        $callback = array_slice($callback, 0, 2);
        $callback[1] = ltrim($callback[1], '*');
      }
      return is_callable($callback);
    }
  }

  // $type: array, string, integer, bool.
  static function FireResult($type, $event, $args = array()) {
    switch ($type) {
    case 'array':   $result = array(); break;
    case 'bool':    $result = false; break;
    default:        $result = null;
    }

    $evtArgs = array(&$result);
    is_array($args) or $args = array($args);
    self::AppendByRefTo($evtArgs, $args);
    self::Fire($event, $evtArgs);

    $error = false;

      switch ($type) {
      case 'array':   $error = !is_array($result); break;
      case 'string':  $result === null or $result = (string) $result; break;

      case 'integer':
        if ($result !== null) {
          $error = !is_numeric($result);
          $result = (int) $result;
        }
        break;

      case 'bool':    return (bool) $result;
      default:        throw new BException('Unknown $type in '.__CLASS.'::FireResult().', '$type = '.$type);
      }

    if ($error) {
      throw new BException('Result of firing event "'.$event.'" was expected to be an '.$type.'.',
                           var_export($result, true).' was given');
    } else {
      return $result;
    }
  }

  // $type: '' (simply on event), prehook ($event is ID: ClassName>Method), posthook
  static function HookFirst($event, $callback, $type = '') {
    $event = strtolower($event);
    $type and $event = "$type: $event";
    isset( self::$list[$event] ) or self::$list[$event] = array();
    array_unshift(self::$list[$event], $callback);
  }

    static function Hook($event, $callback, $type = '') {
      $event = strtolower($event);
      $type and $event = "$type: $event";
      self::$list[$event][] = $callback;
    }

  static function Unhook($event, $callback, $type = '') {
    $event = strtolower($event);
    $type and $event = "$type: $event";
    $key = array_search(self::$list[$event], $callback);
    if ($key !== false) { unset( self::$list[$event][$key] ); }
  }

  static function Exists($event, $type = '') {
    $event = strtolower($event);
    $type and $event = "$type: $event";
    return !empty( self::$list[$event] );
  }

    static function Prefixed($pf) {
      $result = array();

        foreach (self::$list as $event => &$callbacks) {
          strpos($event, $pf) === 0 and $result[] = $event;
        }

      return $result;
    }

  // creates an instance only when its handler is about to be invoked (thus saving
  // resources); uses global array of instances per class so they're like singletons.
  // also: function ( $class, array($method, $arg_1, ...), $event )
  static function HookInstanceOf($class, $method, $event, $type = '') {
    self::Hook($event, array(__CLASS__, 'CallInstanceOf', $class, $method), $type);
  }

    // function (arg[, arg, ...], class, method)
    static function CallInstanceOf() {
      $args = debug_backtrace();    // func_get_args() looses by-reference passing.
      $args = $args[0]['args'];

        $method = array_pop($args);
        $class = array_pop($args);

      $method = (array) $method;
      array_unshift($method, SingleInstanceOf($class));
      self::AppendByRefTo($args, $method, 2);

      return call_user_func_array(array_slice($method, 0, 2), $args);
    }

      static function AppendByRefTo(&$to, &$from, $fromIndex = 0) {
        // array_splice($method, 2) won't work because it looses by-references as well.
        for (; isset( $from[$fromIndex] ); ++$fromIndex) { $to[] = &$from[$fromIndex]; }
      }

  // also: function ( $class, array($method, $arg_1, ...), $event )
  static function HookInstanceIfLoaded($class, $method, $event) {
    self::Hook($event, array(__CLASS__, 'CallLoadedInstanceOf', $class, $method));
  }

    static function CallLoadedInstanceOf($class, $method, $arg_1 = null) {
      if (class_exists($class, false)) {
        return call_user_func_array(array(__CLASS__, 'CallInstanceOf'), func_get_args());
      }
    }
}
