<?php

function ExceptionEvent($e) {
  header('HTTP/1.0 500 Internal Server Error');
  header('Status: 500 Internal Server Error');
  StaticPages::OutputAndExit('exception', compact('e'));
}

function SiteLockedPage() {
  header('HTTP/1.0 503 Service Temporarily Unavailable');
  header('Status: 503 Service Temporarily Unavailable');
  if ($sec = SiteLock::SecLeft()) {
    header('Retry-After: '.($sec + 5));  // +5 is just some time margin.
  }

  StaticPages::OutputAndExit('site locked');
}

BEvent::Hook('on exception', 'ExceptionEvent');
BEvent::Hook('on site lock', 'SiteLockedPage');
BEvent::Hook('on start', array('SiteLock', 'Check'));

BEvent::Hook('prepare plugin file', array('PluginInstallator', 'NormalizeFile'));
BEvent::Hook('plugin installed', array('PluginInstallator', 'Finish'));
BEvent::Hook('on plugin directive', array('PluginInstallator', 'Directive'));
BEvent::Hook('on plugin section', array('PluginInstallator', 'Base64Section'));
BEvent::Hook('on plugin section', array('PluginInstallator', 'OverwriteSection'));
BEvent::Hook('on plugin section', array('PluginInstallator', 'UnlessSectionExists'));
BEvent::Hook('on plugin section', array('PluginInstallator', 'Section'));

BEvent::Hook('on plugin uninstall', array('PluginInstallator', 'Unregister'));
BEvent::Hook('on plugin uninstall', array('PluginInstallator', 'RemoveFilesOf'));
BEvent::Hook('on plugin uninstall', array('BIndex', '*RemoveFrom', 'plugins'));

BEvent::Hook('normalize post', array('PostNormalizer', 'Format'));
BEvent::Hook('normalize post', array('PostNormalizer', 'NormCommonFields'));
BEvent::Hook('normalize post', array('PostNormalizer', 'NormMetaFields'));
BEvent::Hook('normalize post', array('BConfig', 'AddPostExtraLinks'));
BEvent::Hook('normalize post', array('PostNormalizer', 'NormImageFields'));
BEvent::Hook('normalize post', array('PostNormalizer', 'AddShortenFields'));

BEvent::Hook('on tpl vars: commenting', array('BConfig', 'HideCommentingFieldsFrom'));
BEvent::Hook('normalize comment', array('BComments', 'ApplyMaxDepth'));
BEvent::Hook('normalize comment', array('BComments', 'Normalize'));
BEvent::Hook('normalize comment', array('BComments', 'RememberInfoIfAdded'));

BEvent::Hook('post permalink', array('Permalink', 'GenerateFor'));
BEvent::Hook('format post link', array('Permalink', 'FormatLinkSimple'));

BEvent::Hook('posts by URL', array('Permalink', 'ByTailOf'));
BEvent::Hook('shorten', array('Shortener', 'Shorten'));
BEvent::Hook('shorten inline doc', array('Shortener', 'ShortenInlineDoc'));
BEvent::Hook('shorten inline text', array('Shortener', 'ShortenInlineText'));

BEvent::Hook('post moved', array('BComments', 'PostMoved'));
BEvent::Hook('comment moved', array('BComments', 'RenameParent'));

BEvent::Hook('tag desc', array('BTags', 'GetWikiDescOf'));
BEvent::Hook('tag desc', array('BTags', 'GetHtmlDescOf'));

BEvent::Hook('mail: send', array('EMail', 'SetConfigTo'));
BEvent::Hook('mail: send', array('EMail', 'SetHeadersTo'));
BEvent::Hook('mail: send', array('EMail', 'Mail'));

// standard $bodyEncoding's and $bodyCharset's are hardcoded in EncodeBody();
// however, extra values can be added by simply prepending new hook to this
// and checking $email->bodyEncoding/Charset - if they match the hook can
// modify $body, add $header['Content-Transfer-Encoding'] and set
// bodyEncoding/Charset to 'plain' - $body is not changed in this case and since
// the header is already set it will not be replaced by EncodeBody() either.
BEvent::Hook('mail: encode body', array('EMail', 'EncodeBody'));
BEvent::Hook('mail: encode attachment', array('EMail', 'DenyAttachment'));
BEvent::Hook('mail: encode attachment', array('EMail', 'EncodeAttachment'));

BEvent::Hook('mail: transmit', array('EMail', 'Transmit'));

BEvent::HookFirst('mail: send', array('BlockedemailsFileIndex', 'BlockIfListed'));
BEvent::Hook('mail: footer', array('BlockedemailsFileIndex', 'GetFooter'));

// $tpl will be null if formatting a string using Template::LiteFormat();
BEvent::Hook('template: prepare vars', array('Template', 'AddCommonVars'));
BEvent::Hook('template: prepare vars', array('Template', 'PrepareVars'));

BEvent::Hook('template: prepare template', array('Template', 'ProcessDirectives'));

BEvent::Hook('template: format', array('Template', 'FormatTXT'));
BEvent::Hook('template: format', array('Template', 'FormatHTML'));
BEvent::Hook('template: format', array('Template', 'FormatWiki'));
BEvent::Hook('template: format', array('Template', 'FormatPHP'));

BEvent::Hook('sidebars: get', array('Sidebars', 'GetAll'));
BEvent::Hook('sidebars: parse', array('Sidebars', 'Parse'));
// file name passed is in UTF-8.
BEvent::Hook('sidebars: find files', array('Sidebars', 'FindFiles'));
BEvent::Hook('sidebars: is regenerated', array('Sidebars', 'IsRegenerated'));

BEvent::Hook('sidebars: generate', array('Sidebars', 'HideIfHidden'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'GenerateFromCache'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'GenerateHtmlOf'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'GenerateWikiOf'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'GenerateByPlugin'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'ApplyPostGenerationSettings'));
BEvent::Hook('sidebars: generate', array('Sidebars', 'StoreInCache'));

BEvent::Hook('sidebars: show: on pages', array('Sidebars', 'ShowOnPages'));
BEvent::Hook('sidebars: show: on chance', array('Sidebars', 'ShowOnChance'));
BEvent::Hook('sidebars: show: on dates', array('Sidebars', 'ShowOnDates'));
BEvent::Hook('sidebars: show: on user agents', array('Sidebars', 'ShowOnAgents'));
BEvent::Hook('sidebars: show: on robots', array('Sidebars', 'ShowOnRobots'));
BEvent::Hook('sidebars: show: on ips', array('Sidebars', 'ShowOnIPs'));
BEvent::Hook('sidebars: show: on ports', array('Sidebars', 'ShowOnPorts'));
BEvent::Hook('sidebars: show: if were events', array('Sidebars', 'ShowIfWereEvents'));

BEvent::Hook('sidebars: regenerate: on age', array('Sidebars', 'RegenOnAge'));

BEvent::HookInstanceOf('BListPage', 'Generate', 'generate page: list');
BEvent::HookInstanceOf('BCommentPage', 'Generate', 'generate page: comment');
BEvent::HookInstanceOf('BThreadPage', 'Generate', 'generate page: thread');

// function (source); return HTML
BEvent::Hook('format comment: wiki', array('BUverseWiki', 'ToHTML'));

function FormatCommentAsText($str) { return nl2br(htmlspecialchars8($str)); }
BEvent::Hook('format comment: text', 'FormatCommentAsText');

// function (comment, size); return URL   - comment is a result of BComments::Get()
BEvent::Hook('avatar: gravatar', array('BComments', 'Gravatar'));


$indexes = array(
  'BlockedemailsFileIndex' => array('c'),
  'PluginsFileIndex' => array(),
  'SidebarcacheFileIndex' => array('c'),
  'SidebareventsFileIndex' => array('r'),

  'CommentcountsFileIndex' => array('r', 'comment added' => 'CommentAdded', 'comment deleted' => 'CommentRemoved',
                                   'comment moved' => 'CommentMoved', 'post moved' => 'Rename'),
  'CommentdatesFileIndex' => array('r', 'comment added' => 'CommentAdded', 'comment deleted' => 'Remove',
                                    'comment moved' => 'Rename', 'post moved' => 'PostMoved'),
  'PostcommentdatesFileIndex' => array('r', 'comment added' => 'CommentAdded', 'comment deleted' => 'CommentRemoved',
                                       'comment moved' => 'CommentMoved', 'post moved' => 'RenameKey'),

  'DatedayFileIndex' => array('r', 'post added' => 'PostAdded', 'post deleted' => 'PostDeleted',
                              'post moved' => 'PostMoved'),
  'DatemonthFileIndex' => array('r', 'post added' => 'PostAdded', 'post deleted' => 'PostDeleted',
                                'post moved' => 'PostMoved'),
  'DateyearFileIndex' => array('r', 'post added' => 'PostAdded', 'post deleted' => 'PostDeleted',
                               'post moved' => 'PostMoved'),

  'PostcacheFileIndex' => array('c', 'post updated' => 'Remove', 'post deleted' => 'Remove',
                                'post moved' => 'Rename'),
  'PostdocsFileIndex' => array('post added' => 'Add', 'post updated' => 'Add',
                               'post deleted' => 'Remove', 'post moved' => 'Rename'),
  'PostdatesFileIndex' => array('r', 'post added' => 'PostAdded', 'post updated' => 'PostAdded',
                                'post deleted' => 'Remove', 'post moved' => 'Rename'),
  'PostsFileIndex' => array('post added' => 'Add', 'post deleted' => 'Add',
                            'post moved' => 'Rename'),

  'TagcountsFileIndex' => array('r', 'post added' => 'PostAdded', 'post updated' => 'PostUpdated',
                                'post deleted' => 'PostDeleted'),
  'TagsFileIndex' => array('r', 'post added' => 'PostAdded', 'post updated' => 'PostUpdated',
                           'post deleted' => 'PostDeleted', 'post moved' => 'PostMoved'),

  // we intentionally don't delete old URL assignment on post update so old links will remain valid.
  'UrltitlesFileIndex' => array('r', 'post added' => 'PostAdded', 'post updated' => 'PostAdded',
                                'post deleted' => 'Remove', 'post moved' => 'PostMoved'),
  // no handler for 'post deleted' - it's not a good idea to lose the link between a post and its comments.
  'PostmasksFileIndex' => array('mask post' => 'Mask', 'unmask post' => 'Unmask',
                                'post moved' => 'Rename')
);

  foreach ($indexes as $class => $events) {
    $index = substr($class, 0, -9);
    BIndex::Add($index, 'file');

    foreach ($events as $event => $method) {
      if ($event === 0) {
        if (strrchr($method, 'c') !== false) {
          BEvent::HookInstanceOf($class, 'Clear', 'index: clear');
        }

        if (strrchr($method, 'r') !== false) {
          BEvent::HookInstanceOf($class, 'Rebuild', 'index: rebuild');
        }
      } else {
        BEvent::HookInstanceOf($class, $method, $event);
      }
    }
  }

$extraEvents = BConfig::$paths['config'].'plugins.php';
if (is_file($extraEvents)) { require_once $extraEvents; }

$sidebarEvents = BIndex::SelectFrom('SidebarEvents');
foreach ($sidebarEvents as $event => &$sidebars) {
  BEvent::HookFirst($event, array('Sidebars', '*OnEvent', $event));
}
