<?php
BEvent::Hook('on tpl vars: common', array('BTplVars', 'CommonTo'));
BEvent::Hook('on tpl vars: common', array('BTplVars', 'BlogCommonTo'));

BEvent::Hook('on tpl vars: post', array('BTplVars', 'PostTo'));
BEvent::Hook('on tpl vars: post list', array('BTplVars', 'PostListTo'));
BEvent::Hook('on tpl vars: commenting', array('BTplVars', 'CommentingTo'));
BEvent::Hook('on tpl vars: thread', array('BTplVars', 'ThreadTo'));

class BTplVars {
  static function Set($which, &$vars, $args = null) {
    $args = func_get_args();
    array_shift($args);
    $args[0] = &$vars;

    BEvent::Fire('on tpl vars: '.$which, $args);
  }

  static function BeforeFilling($page, &$vars) {
    BEvent::Fire('on tpl vars: before filling', array($page, &$vars));

    $meta = &$vars['headMeta'];
    if ($meta) {
      is_array($meta) and $meta = '    '.join("\n    ", $meta);

      isset($vars['headFooter']) or $vars['headFooter'] = '';
      $vars['headFooter'] .= $meta;
    }
  }

  static function CommonTo(&$vars) {
    foreach (BConfig::$defProps as $name => $default) {
      if ($default === '') { $vars[$name] = BConfig::$$name; }
    }

    $lang = Translate('iso-2');
    $vars['pageLang'] = strlen($lang) === 2 ? $lang : 'en';

    foreach (array('headHeader', 'headFooter', 'bodyHeader', 'bodyFooter') as $name) {
      $file = BConfig::$paths['config'].$name.'.html';
      isset($vars[$name]) or $vars[$name] = '';
      is_file($file) and $vars[$name] .= file_get_contents($file);
    }

      $vars['headHeader'] = '<base href="'.BConfig::$siteHome.'" />
                            <script type="text/javascript">
                              window.siteHome = "'.BConfig::$siteHome.'";
                              window.engineURL = "'.BConfig::$engineURL.'";
                            </script>'.
                            $vars['headHeader'];

      $vars['headFooter'] .= self::HtmlForCSS(BConfig::$extraCSS);

      isset($vars['headMeta']) or $vars['headMeta'] = array();
      $vars['headMeta'] += self::CommonMeta();

    $vars['selfURL'] = $_SERVER['REQUEST_URI'];
    $vars['templatePath'] = BConfig::$paths['template'];
    $vars['motto'] = BConfig::SessionMotto();

    $vars['social'] = self::Social();
    isset(BConfig::$menus[0]) and $vars['primaryMenu'] = BConfig::$menus[0];
    isset(BConfig::$menus[1]) and $vars['secondaryMenu'] = BConfig::$menus[1];

    $vars['searchURL'] = BConfig::$engineURL.'search.php';
    $vars['searchName'] = 'q';

    $vars['favicon'] = BConfig::$baseURL.'favicon.ico';

    $vars['generatorName'] = 'UverseWiki';
    $vars['generatorHome'] = 'http://uverse.i-forge.net/blog/';
    $vars['generatorIcon16'] = BConfig::$engineURL.'static/uwiki-16.png';
    $vars['generatorIcon32'] = BConfig::$engineURL.'static/uwiki-32.png';
  }

    static function CommonMeta() {
      $siteName = htmlspecialchars8(BConfig::$siteName, ENT_QUOTES);
      $meta = array('shortcut icon' => '<link rel="shortcut icon" type="image/x-icon" href="'.BConfig::$siteHome.'favicon.ico" />',
                    'index' => '<link rel="index" href="'.BConfig::$siteHome.'" title="'.$siteName.'" />',
                    'Content-Type' => '<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />',
                    'generator' => '<meta name="generator" content="UverseBlog &amp; UverseWiki" />');

      $hasIcon = false;
      foreach (array(16, 24, 32, 48, 64, 128) as $size) {
        $prop = "logo$size";
        if (BConfig::$$prop) {
          $meta['icon'.$size] = '<link rel="icon" href="'.ToAbsoluteURL(BConfig::$$prop).'"'.
                                       " sizes=\"{$size}x{$size}\" />";
          $hasIcon = true;
        }
      }

        if (!$hasIcon) {
          $meta['icon'] = '<link rel="icon" href="'.ToAbsoluteURL('favicon.ico').'" />';
        }

      if (BConfig::$licenseURL) {
        $body = 'href="'.BConfig::$licenseURL.'" title="'.BConfig::$licenseName.'"';
        // there seem to be a confusion between license and copyright rels - W3C defines
        // copyright (http://www.w3.org/TR/html401/types.html#type-links) but web pages
        // seem to use license everywhere, at least in <a> (e.g. Wikipedia's pages).
        $meta['license'] = '<link rel="license" '.$body.' />';
        $meta['copyright'] = '<link rel="copyright" '.$body.' />';
      }

      return $meta;
    }

    static function HtmlForCSS($files) {
      $files = (array) $files;
      if ($files) {
        $prefix = '<link rel="stylesheet" type="text/css" href="';
        $suffix = "\" />\n";
        return $prefix.join($suffix.$prefix, $files).$suffix;
      }
    }

      static function HtmlForJS($files) {
        $files = (array) $files;
        if ($files) {
          $prefix = '<script type="text/javascript" src="';
          $suffix = "\" />\n";
          return $prefix.join($suffix.$prefix, $files).$suffix;
        }
      }

    // todo: move social buttons, etc. to events
    static function Social() {
      return array();
    }

    static function BlogCommonTo(&$vars) {
      $vars['sidebar'] = self::Sidebars();
    }

      static function Sidebars() {
        $sidebars = BEvent::FireResult('array', 'sidebars: get');

          foreach ($sidebars as &$sidebar) {
            $sidebar += array('type' => 'other');

            $caption = &$sidebar['caption'];
            $caption = "$caption" === '' ? '' : Translate($caption);
          }

        return $sidebars;
      }

  static function PostListTo(&$vars, $posts) {
    $url = $vars['pageURL'];
    $cur = $vars['currentPage'];

    if ($url and $vars['totalPages']) {
      $vars['headMeta']['start'] = '<link rel="start" href="'.str_replace('$', 0, $url).'" title="'.$vars['criteria'].'" />';
      $cur > 0 and $vars['headMeta']['prev'] = '<link rel="prev" href="'.str_replace('$', $cur - 1, $url).'" />';
      $cur + 1 < $vars['totalPages'] and $vars['headMeta']['next'] = '<link rel="next" href="'.str_replace('$', $cur + 1, $url).'" />';
    }

    $metaDesc = null;

      if (!empty($vars['isMainPage'])) {
        $metaDesc = BConfig::$siteDesc;
        if (BConfig::$siteKeywords) {
          $vars['headMeta']['keywords'] = '<meta name="keywords" content="'.BConfig::$siteKeywords.'" />';
        }
      } elseif (isset($vars['listHeader'])) {
        $metaDesc = mb_substr(strip_tags($vars['listHeader']), 0, 350);
      }

      $metaDesc and $vars['headMeta']['description'] = '<meta name="description" content="'.htmlspecialchars8($metaDesc, ENT_QUOTES).'" />';
  }

  static function PostTo(&$vars, $post) {
    self::NormPostVars($vars, $post);
    self::Set('commenting', $vars, 'commenting', BComments::ReferrerFor($post),
              BConfig::$canCommentPosts);

    $vars['byDayFilterURL'] = array(__CLASS__, 'DateFilterURL', 'd');
    $vars['byMonthFilterURL'] = array(__CLASS__, 'DateFilterURL', 'm');
    $vars['byYearFilterURL'] = array(__CLASS__, 'DateFilterURL', 'y');

    isset($vars['headFooter']) or $vars['headFooter'] = '';
    $vars['headFooter'] .= self::HtmlForCSS( self::PostCssFiles($vars, $post) ).
                           self::HtmlForJS( self::PostJsFiles($vars, $post) );

    isset($vars['headMeta']) or $vars['headMeta'] = array();
    $vars['headMeta'] += array('start' => self::PostLinkRelFor(BPosts::First(), 'start'),
                               'prev' => self::PostLinkRelFor(BPosts::PreviousTo($post), 'prev'),
                               'next' => self::PostLinkRelFor(BPosts::NextTo($post), 'next'),
                               'canonical' => '<link rel="canonical" href="'.BPosts::UrlOf($post).'" />',
                               'author' => '<meta name="author" content="'.BPosts::Get($post, 'author').'" />');

      $vars['headMeta'] += self::MetaForPost($post);

      if ($short = BPosts::ShortUrlOf($post)) {
        $vars['headMeta']['shortlink'] = '<link rel="shortlink" href="'.$short.'" />';
        $vars['shortURL'] = $short;
      }
  }

    static function PostCssFiles(&$vars, $post) {
      $css = empty($vars['extracss']) ? array() : $vars['extracss'];

        foreach ($css as &$file) {
          $file = ToAbsoluteURL($file, BConfig::$postURL.dirname($post), BConfig::$postURL);
        }

      $cssFile = ChangeStrExt($post, '.css');
      if (is_file( BConfig::FileOf('posts', BConfig::FromUTF8('file name', $cssFile)) )) {
        $css[] = BConfig::$postURL.$cssFile;
      }

      return $css;
    }

      static function PostJsFiles(&$vars, $post) {
        return empty($vars['extrajs']) ? array() : $vars['extrajs'];
      }

    static function PostLinkRelFor($post, $rel) {
      if ($post) {
        return '<link rel="'.$rel.'" href="'.htmlspecialchars8(BPosts::UrlOf($post), ENT_QUOTES).'"'.
                      ' title="'.htmlspecialchars8(BPosts::TitleOf($post, false), ENT_QUOTES).'" />';
      }
    }

    static function MetaForPost($post) {
      $meta = array();

        $tags = htmlspecialchars8(join( ', ', BPosts::Get($post, 'tags') ), ENT_QUOTES);
        $tags and $meta['keywords'] = '<meta name="keywords" content="'.$tags.'" />';

        $desc = array();
        $info = BPosts::Get($post);

          $synopsis = $info['synopsis'];
          $synopsis === '' and $synopsis = $info['nutshell'];
          $synopsis === '' or $desc[] = $synopsis;

          if ($cat = $info['category']) {
            $cat = BTags::Translate($cat);
            $desc[] = Translate('Posted under:').' '.join(' » ', $cat);
          }

          if ($tags = $info['tags']) {
            $tags = array_diff($tags, $cat);
            $desc[] = Translate('Tagged:').' '.join(', ', $tags);
          }

        if ($desc) {
          $meta['description'] = '<meta name="description" content="'.htmlspecialchars8(join(' | ', $desc), ENT_QUOTES).'" />';
        }

      return $meta;
    }

    // $period = d|m|y
    static function DateFilterURL($time, $period) {
      switch ($period) {
      case 'd': $time = date('d-m-Y', $time); break;
      case 'm': $time = date('m-Y', $time); break;
      default:  $time = date('Y', $time);
      }

      return BConfig::$baseURL.'@'.$time;
    }

    static function NormPostVars(&$vars, $post) {
      self::NormTags($vars['tags']);
      self::NormTags($vars['category'], true);

      self::NormRelated($vars['related']);
    }

      static function NormTags(&$tags, $isCategory = false) {
        foreach ($tags as &$tag) {
          // todo: tags.conf
          // todo: popularity
          $tag = array('url' => BTags::UrlOf($tag),
                       'caption' => BTags::CaptionOf($tag),
                       'desc' => BTags::ShortDescOf($tag),
                       'popularity' => BTags::PopularityOf($tag),
                       'count' => BTags::Count($tag));
        }
      }

      static function NormRelated(&$posts) {
        foreach ($posts as &$post) {
          // todo:
          //$post = BPosts::Get($post);
        }
      }

    static function CommentingTo(&$vars, $varPrefix, $post, $isEnabled) {
      if ($isEnabled) {
        $vars[$varPrefix.'URL'] = BConfig::$engineURL.'comment.php';
        $vars[$varPrefix.'Query'] = compact('post');
        $vars[$varPrefix.'Fields'] = self::ComentingFields();
      } else {
        $vars[$varPrefix.'URL'] = '';
      }
    }

      static function ComentingFields() {
        $markupInfo = BEvent::Fire('comment markup legend: '.BConfig::$commentMarkup);
        $emt = BConfig::$avatars === 'gravatar' ? Translate('We\'re supporting Gravatars.') : '';

        $recalled = BComments::RecallInfo(true);
        $recalled['author'] === '' and $recalled['author'] = Translate('Anonymous');

        return array(
          array('type' => 'author', 'caption' => Translate('Your name:'),
                'value' => '<input type="text" name="author" value="'.$recalled['author'].'" />'),
          array('type' => 'email', 'caption' => Translate('Optional e-mail:'),
                'value' => '<input type="text" name="authorEMail" value="'.
                            $recalled['authorEMail'].'" title="'.$emt.'" />'),
          array('type' => 'home', 'caption' => Translate('Your homepage:'),
                'value' => '<input type="text" name="authorHome" value="'.
                           $recalled['authorHome'].'" />'),
          array('type' => 'message', 'caption' => Translate('Comment:'),
                'value' => '<textarea name="text" rows="2" cols="30"></textarea>'),
          array('type' => 'signature', 'caption' => Translate('Signature (optional):'),
                'value' => '<textarea name="signature" rows="2" cols="30">'.
                           $recalled['signature'].'</textarea>'),
          array('type' => 'markup',
                'caption' => Translate('Text &amp; signature markup:'),
                'value' => sprintf( Translate('markup: '.BConfig::$commentMarkup), $markupInfo ))
        );
      }

  static function ThreadTo(&$vars, $comment) {
    self::Set('commenting', $vars, 'reply', $comment, BConfig::$enableThreads);
    $post = BComments::PostOf($comment);

    isset($vars['headMeta']) or $vars['headMeta'] = array();
    $vars['headMeta'] += self::MetaForPost($post);

    foreach (BConfig::$avatarSizes as $size) {
      $vars['avatar'.$size] = BComments::AvatarFor($comment, $size);
    }

    $vars += array('profileURL' => false, 'reportURL' => false);
    // todo: move hiding/showing email to event (as part of "XXX var fill" event).
    $vars['authorEMail'] = null;
    $vars['threadURL'] = BPosts::UrlOf($post).'/thread?parent='.urlencode(BComments::CommentOf($comment));
  }
}
