<?php
/*
  {{Image pic.jpg}}
  {{Image pic.jpg, Our journey has started there...}}
  {{Image pic.jpg, The Peaks., width=600}}
  {{Image pic.jpg, What's it like?, 600x800}}  - or 600X800, 600*800, 600:800 (or 600 x 800, etc.).
  {{Image pic.jpg, 600x800}}                   - or 600X800, etc. (as above).
  {{Image pic.jpg, size=600x800}}              - or 600X800, etc. (as above).
  {{Image pic.jpg, width=600}}
  {{Image pic.jpg, height=800}}
  {{Image pic.jpg, 100x100, 600x800}}          - since 3nd arg (600x800) is a proper size, 2nd arg (100x100) is treated as title.

    You can also use built-in Russian aliases:
    {{Image файл=картинка.jpg, подпись="текст", размер=100x100, длина=100, высота=100}}

    You can specify more and/or in other languages in config/strings.conf by adding lines like:
    image_Root: param largura = width
    image_Root: param 幅 = width

  {{Image pic.jpg, title=You can use **wiki** here}}
  %%(Image pic.jpg)
    Convenient syntax for larger title/descriptions:
    * a list item,
    * another one.
  %%
  %%(Image pic.jpg, title=Actual title)
    The title= arg overrides whatever is written here.
  %%
  %%(Image pic.jpg; HTML)
    <html arg="value">Here we highlight some HTML</html>
  %%

  Alignment (center/left/right) for any form above is also supported:
    {{Image pic.jpg, align=left}}

    To prevent stacking use "clear" parameter (only works when Image is block):
    {{Image clear}}         - clears left and right alignment
    {{Image clear=left}}    - just left align
    {{Image clear=right}}   - just right align

  You can combine image with normal wiki link (notice "no link" flag):
    ((full-pic.jpg {{Image thumb.jpg, no link=1}}))     - links to picture
    ((Our products == {{Image thumb.jpg, no link=1}}))  - links to some page
    {{Image pic.jpg, no link=1}}                        - simply a non-clickable image
*/

class Uimage_Root extends UWikiBaseAction {
  public $htmlClasses = array('image-box');
  public $parameterAliases = array('файл' => 'file', 'подпись' => 'title', 'длина' => 'width',
                                   'высота' => 'height', 'размер' => 'size');

  public $width, $clear;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['int'][] = 'width';
    $props['bool'][] = 'clear';
  }

  function ApplyParameterOrderTo($params) {
      $keys = array_keys($params);
      $values = array_values($params);

    // "=== true" means argument was passed w/o the key: {{action argValue}} instead of {{action key=value}}.
    if (@$values[0] === true) { $params['file'] = $keys[0]; }

    if (@$values[2] === true and $this->IsSize($keys[2])) {
      $params['size'] = $keys[2];
      $sizePassed = true;
    }

    if (@$values[1] === true) {
      if (!isset($sizePassed) and $this->IsSize($keys[1])) {
        $params['size'] = $keys[1];
      } else {
        $params['title'] = $keys[1];
      }
    }

    return $params;
  }

    function IsSize($str) { return $this->SplitSize($str) != null; }

      function SplitSize($str) {
        $sep = preg_quote($this->settings->imageSizeSeparators, '/');
        if ($size = preg_match("/^(\d+)\s*[$sep]\s*(\d+)$/u", $str, $matches)) {
          $width = (int) $matches[1];
          $height = (int) $matches[2];
          if ($width and $height) { return compact('width', 'height'); }
        }
      }

  function Execute($format, $params) {
    $format->appendMe = true;

    $file = @$params['file'];
    $clear = &$params['clear'];
    if ($file === 'clear') {
      $clear = true;
      $file = '';
    }

    if ("$file" === '' and !$clear) {
      $this->children[] = $this->NewElement('Uimage_MissingFile');
    } elseif ("$file" !== '') {
      $imageElement = $this->children[] = $this->NewElement('Uimage_ImageFile');
      $imageElement->asLink = empty( $params['no link'] );

      $imageElement->file = $this->ToAbsolutePath($file);

        if ($size = $this->SplitSize( @$params['size'] )) { $params += $size; }

      $imageElement->width = &$params['width'];
      $imageElement->height = &$params['height'];

        if (!self::IsEmptyStr( $params['title'] )) { $format->raw = $params['title']; }

      if (self::IsEmptyStr( $format->raw )) {
        $format->blockExpected and $imageElement->htmlClasses[0] .= '-box';
      } else {
        $titleElement = $this->children[] = $this->NewElement('Uimage_Title');
        $format->IsEmpty() and $format->AddFormat( $this->DefaultStyle() );
        $format->root = $titleElement;
        $this->isBlock = $imageElement->isBlock = true;
        $this->htmlTag = 'div';
        $this->html5Tag = 'figure';
        $imageElement->width and $this->width = $imageElement->width + 10;
      }

        if ($align = &$params['align'] and
            in_array( $align, array('center', 'left', 'right') )) {
          if (isset($titleElement)) {
            $this->htmlClasses[] = "image-$align";
          } else {
            $imageElement->htmlClasses[] = "image-$align";
          }
        }
    }

    if ($clear and $this->isBlock) {
      $this->clear = $clear === true ? 'both' : $clear;
      if (!$this->htmlTag) {
        $this->htmlClasses = array('image-clear');
        $this->htmlTag = 'div';
      }
    }
  }

  function SelfHtmlAttributes() {
    $style = array();
    $this->width and $style[] = 'width: '.$this->width.'px';
    $this->clear and $style[] = 'clear: '.$this->clear;
    return array('style' => join('; ', $style));
  }
}

  class Uimage_MissingFile extends UWikiFormatErrorMessage {
    public $message = '{{image: no file passed';
    public $defaultMessage = 'No file name passed for {{Image}}.';
  }

  class Uimage_ImageFile extends UWikiBaseElement {
    public $htmlTag = 'img';
    public $isSingleHtmlTag = true;
    public $htmlClasses = array('image');

    public $asLink, $file, $width, $height;

    function SetupSerialize(array &$props) {
      parent::SetupSerialize($props);

      $props['bool'][] = 'asLink';
      $props['str'][] = 'file';
      $props['int'][] = 'width';
      $props['int'][] = 'height';
    }

    function SelfToHtmlWith($contents) {
      $contents = parent::SelfToHtmlWith($contents);

        if ($this->asLink) {
          $classes = join(' ', $this->htmlClasses);
          $contents = '<a class="'.$classes.'" href="'.$this->file.'">'.$contents.'</a>';
        }

      return $contents;
    }

      function SelfHtmlAttributes() {
        $attrs = array('src' => $this->file, 'alt' => $this->file);
        $this->width and $attrs['width'] = $this->width;
        $this->height and $attrs['height'] = $this->height;
        return $attrs;
      }
  }

  class Uimage_Title extends UWikiBaseElement {
    public $isBlock = true;
    public $htmlTag = 'div';
    public $htmlClasses = array('title');
  }
