<?php
  set_time_limit(25);
  error_reporting(-1);
  ignore_user_abort(false);
  ob_start('ob_gzhandler');
  mb_internal_encoding('UTF-8');
  header('Content-Type: text/html; charset=utf-8');

  $_REQUEST = $_POST + $_GET + $_COOKIE;
  $isDebug = (isset($argv) or $_SERVER['REMOTE_ADDR'] === '127.0.0.1');

  $text = &$_REQUEST['text'];
    trim($text) === '' and $text = "== UWiki sandbox ==\nEnter some text **here** to ##format##...";

  $sourceMarkup = &$_REQUEST['markup'];
    $sourceMarkup = $sourceMarkup ? strtolower($sourceMarkup) : 'wacko';

  $show = &$_REQUEST['show'];

    if (!is_array($show) or count(array_filter($show)) == 0) {
      $show = array();
    }
      $show['Tree'] = isset( $show['Tree'] ) ? $show['Tree'] : false;
      $show['HTML'] = isset( $show['HTML'] ) ? $show['HTML'] : true;
      $show['Source'] = isset( $show['Source'] ) ? $show['Source'] : true;
      $show['Annotated'] = isset( $show['Annotated'] ) ? $show['Annotated'] : false;
    ksort($show);

  $customCSS = null;

    if ($usePreviousCSS = &$_REQUEST['usePreviousCSS']) {
      $customCSS = &$_REQUEST['previousCSS'];
    } elseif (($cssFile = &$_FILES['css']['tmp_name']) and is_uploaded_file($cssFile)) {
      $customCSS = file_get_contents($cssFile);
    }

    if (strlen($customCSS) > (20 * 1024) or strpos($customCSS, '<?') !== false or !strpbrk($customCSS, '{}')) {
      $customCSS = null;
    }
    $customCssWithQuotedHTML = str_replace('&gt;', '>', htmlspecialchars($customCSS, ENT_NOQUOTES));

  require 'uversewiki.php';

  $action = 'show';
  foreach (array('download', 'serialize', 'unserialize', 'reserialize') as $act) {
    empty($_REQUEST[$act]) or $action = $act;
  }

    try {
      $settings = new UWikiSettings;
      $settings->LoadFrom(UWikiRootPath.'/config');

        if ($isDebug) {
          $settings->pager = new UWikiFilePager( dirname(__FILE__) );
          $settings->pager->allowedFormats['php'] = 'Extras';
        }

        $baseURL = dirname( $_SERVER['SCRIPT_NAME'] );
        $settings->rootURL = rtrim($baseURL, '\\/').'/';
        $settings->mediaURL = $settings->rootURL.'media/';
        $settings->smileyURL = $settings->mediaURL.'smilies/';

      if ($action === 'unserialize' and $file = $_FILES['serialized']['tmp_name']
          and is_uploaded_file($file) and filesize($file) < 50 * 1024) {
        $text = file_get_contents($file);

        $startedAt = microtime(true);
        try {
          $ser = true;
          $doc = UWikiDocument::Unserialize($text, array('unserializer' => &$ser, 'settings' => $settings));
          $doc->MergeAttachmentsOfNestedDocs();
        } catch (EUWikiSerialization $e) {
          EchoSerializationWarningsOf($ser, '<h2>Unserialization warnings</h2>');
          throw $e;
        }
        $formatTime = microtime(true) - $startedAt;
      } else {
        $doc = new UWikiDocument($text);
        $doc->settings = $settings;
        $doc->MergeAttachmentsOfNestedDocs();
        $doc->LoadMarkup($sourceMarkup);

        $startedAt = microtime(true);
          $doc->Parse();
        $formatTime = microtime(true) - $startedAt;
      }

      $objectIdsParsePhase = $doc->settings->GetObjectIDs();

      switch ($action) {
      case 'serialize':   break;

      case 'reserialize':
        try {
          $ser = true;
          $options = array('unserializer' => &$ser, 'settings' => $settings);
          $doc = UWikiDocument::Unserialize($doc->Serialize(), $options);
          $doc->MergeAttachmentsOfNestedDocs();
          $doc->settings->LoadFrom(UWikiRootPath.'/config');
        } catch (EUWikiSerialization $e) {
          EchoSerializationWarningsOf($ser, '<h2>Unserialization warnings</h2>');
          throw $e;
        }

        $html = $doc->ToHTML();
        break;

      default:
        $html = $doc->ToHTML();
        break;
      }
    } catch (Exception $e) { ?>
      <h1>Hey! An exception of class <kbd><?php echo get_class($e)?></kbd> has occurred.</h1>
      Maybe this info will help... <br />
      <pre><?php echo htmlspecialchars( $e->getMessage() )?></pre>
      &laquo; <strong><a href="." onclick="history.go(-1);">Get back</a></strong>
        to the sandbox of <em>UverseWiki3 "Object Wacko" framework</em>.
    <?php
      if ($isDebug) {
        echo '<hr /><pre>', $e->getTraceAsString(), '</pre>';
      }

      exit;
    }

  if ($action === 'download' or $action === 'serialize') {
    switch ($action) {
    case 'download':
      $name = 'Wiki page.html';
      $data = &$html;
      break;

    case 'serialize':
      $name = 'UWikiDocument.dat';

      $flags = 0;
      if (!empty( $_REQUEST['serialize_flags'] )) {
        foreach ($_REQUEST['serialize_flags'] as $flag) {
          $flag > 0 and $flags |= $flag;
        }
      }
      $data = $doc->Serialize(compact('flags'));

      header('Content-Type: application/octet-stream');
      break;
    }

    header('Content-Disposition: attachment; filename="'.$name.'"');
    // note: don't add Content-Length here because breaks output file due to gzhandler used.
    echo $data;

    exit;
  }

    function PrintTreeOf($obj) {
      if (!empty($obj->children)) {
        echo "<ul>\n";
          foreach ($obj->children as $child) {
            echo '<li> ';
              PrintElem($child);
              PrintTreeOf($child);
            echo " </li>\n";
          }
        echo "</ul>\n";
      }
    }

      function PrintElem($obj, $withID = true) {
        if ($obj) {
          $class = preg_replace('/[A-Z]/', ' \0', $obj->elementName);
          $class = strtr($class, '_', ':').' ';
          $withID and $class .= $obj->elementID;
          $obj->treePosition and $class .= '['.join('.', $obj->treePosition).']';
          $obj->isBlock and $class = "*$class";
          if ($obj->children) { echo "<strong>$class</strong>"; } else { echo $class; }

          $raw = $obj->source;

            if (!UWikiBaseElement::IsEmptyStr($raw)) {
              $raw = mb_substr($raw, 0, 15) .(mb_strlen($raw) > 15 ? '...' : '');
              $cont = SpacesToMiddleDotsIn( EscapeCtrlCharsIn($raw) );
                $cont = preg_replace('/(?<!^)&#x00B7;((&#x00B7;)*)/u', ' \\1', $cont);
              echo " <em>$cont</em>";
            }
        }
      }

      function SpacesToMiddleDotsIn($str) { return strtr($str, array(' ' => "&#x00B7;")); }
      function EscapeCtrlCharsIn($str) { return htmlspecialchars(addcslashes($str, "\00..\31"), ENT_COMPAT, 'UTF-8'); }

    function AnnotateHTML($html) {
      $html = preg_replace('~</(\w+)>~u', '<sup class="note">&laquo;\1.</sup>\0', $html);
        $html = preg_replace('/<(div|span) [^>]+? class="([^"]+)" [^>]* >/xu',
                             '\0<sup class="note">\2&raquo; </sup>', $html);

      return strtr($html, array('<br />' => '<span class="br">¶</span><br />'));
    }

    function EchoSerializationWarningsOf($ser, $header = '') {
      if ($ser->warnings) {
        echo $header, '<ul>';
        foreach ($ser->warnings as $warning) {
          echo "<li><strong>$warning[type] @".sprintf('%X', $warning['streamOffset']).":</strong> $warning[message]</li>";
        }
        echo '</ul>';
      }
    }

    function JoinAttachmentsOf(UWikiDocument $doc, $type, $indentation) {
      $result = '';

        if (is_array(@$doc->attachments[$type])) {
          foreach ($doc->attachments[$type] as $name => &$data) {
            is_int($name) and $name = "Unnamed #$name";
            $data = str_replace("\n", "\n$indentation", $data);
            $result .= "$indentation/* $name: */\n$indentation$data\n\n";
          }
        }

      return $result;
    }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>
      <?php
        if ($action === 'unserialize') {
          echo ucfirst($action);
        } else {
          echo htmlspecialchars(mb_substr($text, 0, 15), ENT_COMPAT, 'UTF-8'), '&hellip;';
        }
      ?>
      &mdash; UverseWiki3 sandbox
    </title>
    <style type="text/css">
    #html * { border-left: 2px solid lime; padding-left: 1px; }
      #html sup.note, #html span.br { border: 0; padding: 0; }
        #html sup.note { padding-left: 2px; color: green; }
        #html span.br { padding-left: 2px; color: green; }
    noscript.uwdemo { color: maroon; }
    .uwdemo-css { margin-top: 0.5em; padding-left: 20px; background: no-repeat left center url(media/demo-css.png); }
    .uwdemo-serialize { margin-top: 0.5em; padding-left: 20px; background: no-repeat left center url(media/demo-serialize.png); }
    table.mirror { width: 100%; }
    .format-name { display: none; }
    blockquote.inline cite { display: block; }
    .image-center { display: block; margin: 0 auto; }
      .image-left { float: left; }
      .image-right { float: right; }
    .nowrap { white-space: nowrap; }

<?php echo JoinAttachmentsOf($doc, 'css', '    '), $customCssWithQuotedHTML?>
    </style>

    <script type="text/javascript">
      function ByID(id) { return document.getElementById(id); }

      function OnSubmit(form) {
          var maxGetReqLength = 500;

        var method = ByID('formMethod').value;
        if (method == 'auto') { method = ByID('text').value.length < maxGetReqLength ? 'get' : 'post'; }
        if (ByID('css').value != '' || ByID('previousCSS')) { method = 'post'; }
        if (form.forcePOST) { method = 'post'; }

        form.method = method;
        form.enctype = method == 'get' ? '' : 'multipart/form-data';

        return true;
      }

      function OnTextKeyDown(elem, event) {
          var skip = [116, 16, 17, 18]; // F5 (refresh), single Ctrl/Alt/Shift.

        if (skip.indexOf(event.keyCode) == -1) {
          elem.rows = 20;
          if (event.ctrlKey && event.keyCode == 13 && elem.parentNode.onsubmit()) {
            elem.parentNode.submit();
          }
        }
      }

<?php echo JoinAttachmentsOf($doc, 'js', '      ')?>
    </script>
  </head>
  <body onload="ByID('text').focus();">
    <div style="float: right; width: 20em; background: white">
      <a target="_blank" href="<?php echo UverseWikiHomePage?>">
        <img style="border: 0" src="media/objectwacko.png" alt="ObjectWacko &quot;Swack&quot; logo" />
      </a>

      <?php
        if ($show['Tree']) {
          echo '<h2 style="margin-bottom: 0">Tree</h2>',
               '<div style="text-align: right"> <strong>has children</strong>
                                                | *block | ID [tree position] </div>',
               PrintTreeOf($doc->root),
               '<h3 style="margin-bottom: 0.25em">Object IDs (',count($objectIdsParsePhase),
                 '/',count($doc->settings->GetObjectIDs()),')</h3>',
               '<em style="text-align: right; display: block">Parse phase: ',
               join(' ', $objectIdsParsePhase), '</em>',
               '<ol style="margin-top: 0.5em">';

            $metObj = array();
            foreach ($doc->settings->GetObjectIDs() as $id) {
              $obj = $doc->settings->ObjectByID($id);
              $met = &$metObj[spl_object_hash($obj)];
              echo '<li value="'.$id.'">', $met ? '<strong><big>DUPLICATED</big></strong>'
                                                : PrintElem($obj, false),'</li>';
              $met = true;
            }

          echo '</ol>';
        } else {
          $metObj = array();
          foreach ($doc->settings->GetObjectIDs() as $id) {
            if (!empty( $metObj[spl_object_hash($doc->settings->ObjectByID($id))] )) {
              echo '<h4>Duplicated object IDs - use <em>Tree</em> view for details.</h4>';
              break;
            }
          }
        }
      ?>
    </div>

    <h1>
      UverseWiki3 sandbox
      | <a target="_blank" href="<?php echo UverseWikiHomePage?>">Framework homepage</a> &raquo;
    </h1>

    <p>
      <strong>Framework version is v<?php echo UverseWikiVersion?> [R<?php echo UverseWikiBuild?>]</strong>
      | <span style="color: gray">
          <?php printf('allocated %1.1f MiB of system mem (peak)', memory_get_peak_usage(true) / 1024 / 1024)?>
        </span>
      | <a href="?testInterval=0">Run tests</a> &raquo;
    </p>

      <?php
        $testInterval = &$_REQUEST['testInterval'];
        if (!$isDebug and !isset($_GET['testInterval'])) { $testInterval = 1; }
        isset($testInterval) or $testInterval = 50;

        if (!$testInterval) {
          $testInterval = 50;

          ob_start();
            $testsStartTime = microtime(true);
            $testsOK = include 'test_runner.php';
          $result = sprintf('<h2>Test runner <span style="color: gray;">- %1.1f sec</span> </h2>',
                            microtime(true) - $testsStartTime). ob_get_clean();

          if (!$testsOK or isset( $_GET['testInterval'] )) { echo $result; }
        } else {
          --$testInterval;
        }

        setcookie('testInterval', $testInterval);
      ?>

    <h2>
      Source (treat as
      <select onchange="ByID('markup').value = this.value;">
        <?php
          $formatters = UWikiDocument::ExistingFormatters();
          sort($formatters);

          $otherMarkups = array();

            foreach (UWikiDocument::ExistingMarkups() as $markup) {
              if (!in_array($markup, $formatters)) { $otherMarkups[] = $markup; }
            }

          sort($otherMarkups);

          $markups = array_merge($formatters, array('-'), $otherMarkups);

            foreach ($markups as $name) {
              if ($name === '-') {
                echo "<optgroup label='Non-formatters'>\n";
              } else {
                $suffix = UWikiDocument::IsAction($name) ? ' [action]' : '';
                $selected = $sourceMarkup === $name ? ' selected="selected"' : '';
                echo "<option value=\"$name\"$selected>",ucfirst($name).$suffix."</option>\n";
              }
            }

          if (!empty($otherMarkups)) { echo '</optgroup>'; }
        ?>
      </select>)
    </h2>
      <noscript class="uwdemo">[The selectbox above needs JavaScript to work]</noscript>

      <form id="form" action="." method="post" enctype="multipart/form-data" onsubmit="return OnSubmit(this);">
        <input type="hidden" id="markup" name="markup" value="<?=$sourceMarkup?>" />

        <textarea cols="80" rows="20" id="text" name="text"
                  onmousemove="this.rows = 20;" onkeydown="OnTextKeyDown(this, event);"
        ><?php echo htmlspecialchars($action === 'unserialize' ? '' : $text, ENT_COMPAT, 'UTF-8')?></textarea>
        <script type="text/javascript"> ByID('text').rows = 1; </script>

        <br />

        <strong>Ctrl+Enter</strong> &raquo;

        <img src="media/demo-form-method.png" alt="Method" title="Form sending method." />
        <select id="formMethod">
          <option value="auto" selected="selected" title="Will choose GET for short and POST for long texts.">Auto</option>
          <option value="post" title="Useful when you need to see the URL (e.g. to track anchors &amp; footnotes) and for long texts.">POST</option>
          <option value="get" title="Useful if you want to link to this URL with this exact text &amp; settings. Long text on GET will return with server error.">GET</option>
        </select>
        <noscript class="uwdemo">[needs JS]</noscript>
        &raquo;

        <input type="submit" value="Format this" style="font-weight: bold" />
        <button type="submit" name="download" value="html">Download formatted HTML</button>

        <?php foreach ($show as $what => $state) { ?>
          <input type="hidden" name="show[<?php echo $what?>]" value="0" />
          <input type="checkbox" id="cb_<?php echo $what?>" name="show[<?php echo $what?>]"
                 value="1" <?php echo ($state ? 'checked="checked"' : '')?> />
          <label for="cb_<?php echo $what?>"><?php echo $what?></label>
        <?php } ?>

        <div class="uwdemo-css">
          Display using <strong>custom CSS</strong>:
          <input type="file" id="css" name="css" onchange="document.getElementById('usePreviousCSS').checked = false;" />

          <?php if ($customCSS) { ?>
            |
            <label for="usePreviousCSS"><strong>Use previously uploaded styles</strong></label>
            <input type="checkbox" id="usePreviousCSS" name="usePreviousCSS" value="1"
                    <?php echo (($customCSS or $usePreviousCSS) ? 'checked="checked"' : '')?> />
            <textarea rows="0" cols="0" id="previousCSS" name="previousCSS" style="display: none"> <?php echo $customCssWithQuotedHTML?> </textarea>
          <?php } ?>
        </div>

        <div class="uwdemo-serialize">
          <input type="submit" name="serialize" value="Format &amp; serialize" />
          the above text
          <input type="checkbox" id="serFlag1" name="serialize_flags[]" value="<?=UWikiSerializer::CRC32?>" />
          <label for="serFlag1">CRC32</label>
          <input type="checkbox" id="serFlag2" name="serialize_flags[]" value="<?=UWikiSerializer::GZ?>" />
          <label for="serFlag2">GZ</label>
          |
          <input type="submit" name="unserialize" value="Unserialize" onclick="ByID('form').forcePOST = true;" />
          this:
          <input type="file" name="serialized" />
          |
          <input type="submit" name="reserialize" value="Reserialize" title="Format, serialize and then unserialize - used to test if serialization works properly." />
        </div>
      </form>

    <?php
      if (strpos($action, 'serialize') and isset($ser)) {
        EchoSerializationWarningsOf($ser, '<h2>Unserialization warnings</h2>');
      }
    ?>

    <h2> HTML
         <span style="color: gray">
           - <?php printf('%s %.2f KiB in %.3f sec (%.3f sec per 1 KiB).',
                          $action === 'unserialize' ? 'unserialized' : 'formatted',
                          strlen($text) / 1024, $formatTime, $formatTime / strlen($text) * 1024); ?>
         </span>
         &nbsp;
         <a class="valid-xhtml" href="http://validator.w3.org/check?uri=referer">
           <img style="border: 0" src="media/valid-xhtml.png" alt="Valid XHTML 1.0 Transitional" />
         </a>
    </h2>
      <?php
        if ($show['HTML']) {
          echo '<div style="background: InactiveCaptionText; border: 1px solid InactiveBorder; padding: 0 1em">',
                $html,
                '<div style="clear: both"></div></div>';
        }
        if ($show['Source']) {
          echo '<h3>HTML source</h3>',
               '<textarea readonly="readonly" onfocus="this.select();" cols="80" rows="20">', htmlspecialchars($html, ENT_COMPAT, 'UTF-8'), '</textarea>';
        }
        if ($show['Annotated']) {
          echo '<h3>Annotated HTML; &nbsp; ¶ = line break </h3>',
               '<div id="html">', AnnotateHTML($html), '</div>';
        }
      ?>
  </body>
</html>
