<?php
include_once 'paragraph.php';

  self::$loadedHandlers[$markup]['inline'][] = array('\(?\(\? (?!\?\))', 'Uwacko_Definition', Uwacko_StartTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\?\)', 'Uwacko_Definition', Uwacko_EndTag | Uwacko_Callback);

  self::$loadedHandlers[$markup]['inline'][] = array('\(\( (?!\)\))', 'Uwacko_Link', Uwacko_StartTag | Uwacko_NoTokensForFirstPart);
  self::$loadedHandlers[$markup]['inline'][] = array('\)\)', 'Uwacko_Link', Uwacko_EndTag | Uwacko_Callback);

  self::$loadedHandlers[$markup]['inline'][] = array('\[\[ (?!\]\])', 'Uwacko_SquareLink', Uwacko_StartTag | Uwacko_NoTokensForFirstPart);
  self::$loadedHandlers[$markup]['inline'][] = array('\]\]', 'Uwacko_SquareLink', Uwacko_EndTag | Uwacko_Callback);

  // format: function (&$caption, $link); $link - instance of Uwacko_Link.
  self::$loadedHandlers[$markup]['link'][] = array('Uwacko_Link', 'ResolveNumberlink');
  self::$loadedHandlers[$markup]['link'][] = array('Uwacko_Link', 'ResolveInterwiki');

  // format: function ($link); $link - instance of Uwacko_Link.
  isset( self::$loadedHandlers[$markup]['linkOnRender'] ) or
    self::$loadedHandlers[$markup]['linkOnRender'] = array();

  // format: function (&$settings)   - is called statically so there's no Uwacko_Link.
  self::$loadedHandlers[$markup]['linkOnToken'] = array();

  // format: function (&$info, $link, &$replaceWith)
  self::$loadedHandlers[$markup]['linkOnParse'] = array();
  self::$loadedHandlers[$markup]['linkOnParse'][] = array('Uwacko_Link', 'SetFootnoteReference');
  self::$loadedHandlers[$markup]['linkOnParse'][] = array('Uwacko_Link', 'ReplaceWithFootnote');
  self::$loadedHandlers[$markup]['linkOnParse'][] = array('Uwacko_Link', 'ReplaceWithAnchor');
  self::$loadedHandlers[$markup]['linkOnParse'][] = array('Uwacko_Link', 'ReplaceWithSelfLink');

class Uwacko_CompositePart extends Uwacko_InlineElement { }

abstract class Uwacko_Composite extends Uwacko_Base {
  public $partClass = 'Uwacko_CompositePart';

  // Splits $raw into 2 parts by == (respects ~ escaping) or by ' ' or returns array($raw, $raw) if both fails.
  static function SplitAs($partClass, $owner, $raw, $settings = array()) {
      $raw = trim($raw);
      if ($raw === '') { return; }

    $settings += array('allowEmptyRight' => false, 'spaceSeparated' => true,
                       'appendPartIfNone' => true, 'parseChildren' => true);

    $parts = explode(Uwacko_CompoundTokenSepar, $raw);

    foreach ($parts as $i => &$part) {
      if (isset( $parts[$i + 1] )) {
        if (self::DeleteIfUnevenTail(Uwacko_TildeToken, $part)) {
          $part .= Uwacko_CompoundTokenSepar;
        } else {
          // we found an unescaped delimiter.
          if ($settings['allowEmptyRight'] and isset( $parts[$i + 1] )) {
            $settings['spaceSeparated'] = $settings['appendPartIfNone'] = false;
          }

          $sides = array(rtrim(join( array_slice($parts, 0, $i + 1) )),
                         ltrim(join( Uwacko_CompoundTokenSepar, array_slice($parts, $i + 1) )));
          break;
        }
      }
    }

      if (self::IsEmptyStr($sides[1]) and $settings['spaceSeparated']) {
        $sides = explode(' ', $raw, 2);
        $sides[0] = rtrim($sides[0]);
        $sides[1] = ltrim(@$sides[1]);
      }
      if (self::IsEmptyStr($sides[1]) and $settings['appendPartIfNone']) {
        $sides = array($raw, $raw);
      }

    if (!self::IsEmptyStr($sides[1]) or $settings['allowEmptyRight']) {
      if ($settings['parseChildren']) {
        foreach ($sides as &$side) {
          $raw = $side;

          $side = $owner->NewElement($partClass);
          $side->SetRaw($raw);
          $side->Parse();
        }
      }

      return $sides;
    }
  }

  function Parse() {
    parent::Parse();
    $this->children = self::SplitAs($this->partClass, $this, $this->raw);
  }

  function AllToHTML() {
    return $this->SelfToHtmlWith( $this->children[0]->AllToHTML() );
  }
}

class Uwacko_Definition extends Uwacko_Composite {
  public $htmlTag = 'abbr';
  public $partClass = 'Uwacko_DefnCompositePart';

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
    if ($flags & Uwacko_StartTag) {
      // workaround for "Table of Contents ((?TOC Table of Contents/))" which must be
      // "Table of Contents (<dfn>TOC</dfn>)" but "((" matches as link token and nesting breaks.
      if ($token === '((?') {
        ++$pos;
        $token = '(?';
      }
    } elseif ($stack and $stack[0][0] === 'Uwacko_Link' and $raw[ $pos + strlen($token) ] === ')') {
      // a workaround for "((a b?))" - "?)" matches by PCRE but "))" isn't since in
      // "?)" the ")" was first matched.
      ++$pos;
      $token = '))';

      Uwacko_Link::FindTokenCallback($doc, $raw, $positions, $stack, $token, $pos, $flags);
      return Uwacko_ForceCloseCurrent;
    }
  }

  function Parse() {
    parent::Parse();

    // todo: use ToText() here when we'll support it.
    $textCaption = strip_tags( $this->children[0]->AllToHTML() );

    if (mb_strlen($textCaption) >= $this->settings->minTermLengthToExpand
        and $this->settings->expandTerms) {
      $this->settings->FloodReplaceTerm($textCaption, $this);
    }
  }

  function SelfHtmlAttributes() {
    // todo: use ToText instead of strip_tags when it's implemented.
    $textTerm = strip_tags( $this->children[1]->AllToHTML() );
    return array('title' => $this->QuoteHTML($textTerm, ENT_COMPAT));
  }
}

  class Uwacko_DefnCompositePart extends Uwacko_CompositePart {
    public $defaultTokenClass = 'Uwacko_DefnText';
  }

  class Uwacko_DefnText extends Uwacko_Text {
    public $skipReplaceObjClasses = array('UWikiReplacedTerm' => true);
  }

class Uwacko_Link extends Uwacko_Composite {
  public $kind = 'link';
  public $htmlTag = 'a';
  public $htmlClasses = array('round-brackets');

  // Deprecated props; hold no value but are made private so that PHP will generate a
  // Fatal Error upon accessing them. Use methods with the same name instead of the props.
  private $isExternal, $isAnchorLink;

  public $wasCaptionExplicit;   // true if there was an explicit caption supplied: ((u r l==)) or ((url caption)).
  public $wasAutoCaption;       // true if user didn't supply any caption and it was autogenerated.
  public $usedEndingSubst;      // true if "+" syntax was processed and tail (after "))") was used: ((pl+us))ic.

  protected $passedURL, $rawURL, $url;
  protected $title;
  protected $footnote, $fnoteOriginIndex;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);

    array_push($props['bool'], 'wasCaptionExplicit', 'wasAutoCaption', 'usedEndingSubst');
    array_push($props['str'], 'passedURL', 'rawURL', 'url', 'title');
    $props['element'][] = 'footnote';
    $props['int'][] = 'fnoteOriginIndex';
  }

  static function IsExternalURL($url) {
    return self::IsPath('ext', $url) or substr($url, 0, 7) === 'mailto:';
  }

  static function IsRelativeURL($url) { return self::IsPath('rel', $url); }
  static function IsAnchorLinkURL($url) { return isset($url[1]) and $url[0] === Uwacko_AnchorChar; }

  static function InlineFootnoteTextFrom($url) {
    if ($url[0] === Uwacko_FootnoteChar) {
      $text = trim(substr($url, 1));
      return self::IsEmptyStr($text) ? null : $text;
    }
  }

  // returns null if $url isn't a footnote URL; returns 0+ (note: integer 0 and up) otherwise.
  static function FootnoteIndexFrom($url) {
    if (isset($url[0]) and trim($url, Uwacko_FootnoteChar) === '') {
      return strlen($url) - 1;
    }
  }

  function IsExternal() { return self::IsExternalURL($this->URL()); }
  function IsRelative() { return self::IsRelativeURL($this->URL()); }
  // True if links to anchor on *current* page: ((#anchor ...))
  function IsAnchorLink() { return self::IsAnchorLinkURL($this->URL()); }
  function FootnoteIndex() { return self::FootnoteIndexFrom($this->URL()); }

  function Title($newTitle = null) {
    $newTitle === null or $this->title = $newTitle;
    return $this->title;
  }

  // unlike raw/passed URLs this is the final (current) URL that <a href="..."> points to.
  function URL($newURL = null) {
    $newURL === null or $this->url = $newURL;
    return $this->url;
  }

    // after calling 'link' hook handlers (this is interwiki, numberlinks, etc.).
    function RawURL() { return $this->rawURL; }
    // almost exactly as it was entered by user in ((passedURL[==]caption...)) - URl is
    // only normalized (e.g. trailing "#" is removed) without further convertions.
    function PassedURL() { return $this->passedURL; }

    // the following 3 methods return null if the link is external or '' if it contains no component.
    function Interwiki($newValue = null) { return $this->LocalUrlProp('interwiki', $newValue); }
    function LocalPath($newValue = null) { return $this->LocalUrlProp('path', $newValue); }
    function LocalAnchor($newValue = null) { return $this->LocalUrlProp('anchor', $newValue); }

      function LocalUrlProp($prop, $newValue = null) {
        if (!$this->IsExternal()) {
          $info = UWackoLinkParser::ParseLocalURL($this->url);
          if ($newValue !== null) {
            $info[$prop] = $newValue;
            $this->url = UWackoLinkParser::MakeUrlFrom($info);
          }

          return $info[$prop];
        }
      }

    function LocalPathWithoutQuery() {
      return strtok($this->LocalPath(), '?');
    }

    // $anchor can be ''; unlike LocalAnchor() it works both for external and internal URLs.
    function UrlAnchor($anchor) {
      $delim = $this->IsExternal() ? '#' : Uwacko_AnchorChar;

      $url = strtok($this->URL(), $delim);
      self::IsEmptyStr($anchor) or $url .= $delim.$anchor;
      return $this->URL($url);
    }

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags, $modSettings = array()) {
    $modSettings += array('selfClass' => __CLASS__);  // there's no late static binding before PHP 5.3.

    if ($stack and $stack[0][0] === $modSettings['selfClass'] and count($stack) === 1) {
      $contents = substr($raw, $stack[0][1], $pos - $stack[0][1]);

      if ($contents[0] !== Uwacko_FootnoteChar) {
        $modSettings = array();
        $doc->settings->handlers->Call('linkOnToken', array(&$modSettings));

        $wordCh = $doc->settings->wordCharacters;
        $maxEndLen = $doc->settings->longestLinkEnding;
        $regexp =  "/^
                      (?: ([$wordCh]{1,$maxEndLen}) [^$wordCh] | ([^$wordCh]) )
                    /xu";
        // Why "+ 10"? First, we need to include at least 1 char following the possible ending to
        // test if it's a word boundary (e.g. non-letter char). But mb_strcut() accepts $length in
        // bytes and cuts off half-cut char in the end; having more than 1 trailing char isn't
        // a problem thus we pass larger length to be sure nothing will be left out.
        // BUT we can't use 4 for that (albeit it's the max char length in UTF-8): for some reason
        // mb_strcut SOMETIMES will still return shorter string. "+ 10" must be enough to make it work.
        $possibleNewEnd = mb_strcut($raw, $pos + strlen($token), $doc->settings->longestLinkEnding + 10);
        if (preg_match($regexp, "$possibleNewEnd ", $matches)) {
          $newEnding = isset( $matches[2] ) ? '' : $matches[1];
          $link = UWackoLinkParser::Parse($contents, $newEnding, $doc->settings, $modSettings);

          $link['usedEndingSubst'] and $token .= $newEnding;
        } else {
          $link = UWackoLinkParser::Parse($contents, null, $doc->settings, $modSettings);
        }

        $positions[ $stack[0][4] ][2] = &$link;  // = callbackResult
      }
    }
  }

  function Parse() {
    $info = &$this->callbackResult;

    $replaceWith = null;
    $this->settings->handlers->Call('linkOnParse', array(&$info, $this, &$replaceWith));

    if ($replaceWith !== null) {
      // (array) $anObject converts $anObject's fields to array instead of array($anObject).
      is_array($replaceWith) or $replaceWith = array($replaceWith);

        foreach ($replaceWith as $obj) {
          if (! $obj instanceof UWikiBaseElement) {
            throw new EUverseWiki($this->className.'::$onParsingHooks\' $replaceWith'.
                                  ' contains wrong or no object (must an UWikiBaseElement).');
          }
        }

      return $replaceWith;
    } else {
      $this->url = $this->passedURL = $this->title = $info['url'];
      if (($iw = ((string) $this->Interwiki())) !== '') {
        $this->htmlClasses[] = 'interwiki-'.mb_strtolower($iw);
      }

        $this->wasCaptionExplicit = $info['isCaptionExplicit'];
        $this->wasAutoCaption = $info['isAutoCaption'];
        $this->usedEndingSubst = $info['usedEndingSubst'];

      if ($this->settings->handlers->HasAny('url')) {
        // note: arg list change - no &$url anymore.
        $this->Deprecated('"url" handler');
      }
      $this->settings->handlers->Call('link', array(&$info['caption'], $this));

        $this->rawURL = $this->URL();

      $captionElement = $this->NewElement($this->partClass);
      $captionElement->SetRaw( trim($info['caption']) );
      $captionElement->Parse();
      $this->children = array($captionElement);
    }
  }

    static function SetFootnoteReference(&$info, $linkObj, &$replaceWith) {
      if (($index = self::FootnoteIndexFrom($linkObj->raw)) !== null) {
        // ((*)) always links to first footnote regardless of its "*" count. It's the same with footnote definitions.
        $index === 0 and $index = count($linkObj->settings->footnoteReferrers);
        $linkObj->settings->footnoteReferrers[$index][] = $linkObj;
        $linkObj->htmlClasses[] ='footnote';
        $info = array('url' => $linkObj->raw, 'caption' => $linkObj->raw[0],
                      'isCaptionExplicit' => false, 'isExternal' => false,
                      'isAnchor' => false, 'isAutoCaption' => false, 'usedEndingSubst' => false,
                      'interwiki' => '', 'path' => '', 'anchor' => '');
        return true;
      }
    }

    static function ReplaceWithFootnote(&$info, $linkObj, &$replaceWith) {
      $footnoteText = self::InlineFootnoteTextFrom($linkObj->raw);
      if (!$replaceWith and $footnoteText !== null) {
        $replaceWith = $footnote = $linkObj->NewElement('Uwacko_InlineFootnote', 'sibling');
        $footnote->SetRaw($footnoteText);
        $footnote->Parse();
      }
    }

    static function ReplaceWithAnchor(&$info, $linkObj, &$replaceWith) {
      if (!$replaceWith and $info['isAnchor']) {
        $replaceWith = $linkObj->NewElement($linkObj->anchorClass, 'sibling');
        $replaceWith->SetUniqueNameFrom($info['anchor']);
      }
    }

    static function ReplaceWithSelfLink(&$info, $linkObj, &$replaceWith) {
      if (!$replaceWith and $info['isAutoCaption'] and !$info['isExternal'] and
          $info['interwiki'] === '' and $info['anchor'] === '') {
        if ($linkObj->pager->IsCurrent($info['path'])) {
          $replaceWith = $linkObj->NewElement('Uwacko_SelfLink');
          $replaceWith->SetRaw($info['caption']);
          $replaceWith->Parse();
        }
      }
    }

  function LinkToFootnote($obj, $selfIndex) {
    $this->footnote = $obj;
    $this->URL( Uwacko_AnchorChar.$obj->AnchorName() );
    $this->fnoteOriginIndex = $selfIndex;
  }

  function SelfToHtmlWith($contents) {
    if ($this->settings->handlers->HasAny('urlOnRender')) {
      // note: arg list change - no &$url anymore.
      $this->Deprecated('"urlOnRender" handler');
    }
    $this->settings->handlers->Call('linkOnRender', array($this));

    if (substr($this->URL(), 0, 7) === 'mailto:') {
      $this->htmlClasses['ext-int'] = 'mailto';
    } else {
      $this->htmlClasses['ext-int'] = $this->IsExternal() ? 'external' : 'internal';
    }

    $this->htmlAttributes += array('href' => '', 'title' => $this->Title());

      if ($this->IsExternal()) {
        $href = $this->URL();
        if (substr($href, 0, 7) !== 'mailto:') {
          $this->htmlAttributes['target'] = $this->settings->extLinksTarget;
        }
      } else {
        // using $href instead of setting URL() because link may be rendered several times
        // (e.g. by {{TOC}} or to get its contents for anchor's name when it's placed
        // in a heading: ==((link))==) and if we change self URL it won't work on next self render.
        $this->PrepareOnRenderInt($href);
      }

      $this->htmlAttributes['href'] = $href;

    return parent::SelfToHtmlWith($contents);
  }

    function PrepareOnRenderInt(&$href) {
      if ($this->footnote) {
        $anchor = $this->footnote->originAnchors[$this->fnoteOriginIndex];
        $this->htmlAttributes['name'] = $this->settings->anchorPrefix.$anchor;
      }

      if ($this->IsAnchorLink()) {
        $anchor = $this->LocalAnchor();
        $this->settings->anchors->IsFree($anchor) and $this->htmlClasses[] = 'missing-anchor';

        $href = $this->settings->pageForSelfAnchorLinks.
                Uwacko_AnchorChar.$this->settings->anchorPrefix.$anchor;
      } elseif ($this->FootnoteIndex() !== null and !$this->footnote) {
        $this->MissingTarget('footnote', $this->URL());
        $href = '';
      } elseif ($missingInterwiki = $this->Interwiki()) {
        // if interwiki reached render phase without being resolved it's considered undefined.
        $oldURL = $this->URL();

          $this->Interwiki('');
          $path = $this->URL() === '' ? '' : sprintf($this->strings['missing interwiki path'], $this->URL());
          $this->MissingTarget('interwiki', $missingInterwiki, $path);

        $this->URL($oldURL);
        $href = '';
      } else {
        @list($path, $query) = explode('?', $this->LocalPath(), 2);

        if ($this->pager->PageExists($path) === UWikiPager::NotFound and
            $this->pager->ClusterExists($path) === UWikiPager::NotFound) {
          $this->htmlClasses[] = 'missing-page';
        }

        if (substr($path, -1 * strlen($this->settings->linkExt)) !== $this->settings->linkExt and
            substr($path, -1) !== '/' and !$this->settings->pager->ClusterExists($path)) {
          isset($query) and $query = "?$query";
          $this->LocalPath($path.$this->settings->linkExt.$query);
        }

        $href = $this->ToAbsolutePath($this->URL());
      }
    }

      function MissingTarget($type, $titleFmtArg_1 = null) {
        $this->htmlTag = 'span';
        $this->htmlClasses[] = 'missing-'.$type;

        $fmt = func_get_args();
        $fmt[0] = $this->strings['missing '.$type];
        $this->htmlAttributes['title'] = call_user_func_array('sprintf', $fmt);
      }

  static function ResolveInterwiki(&$caption, $linkObj) {
    $prefix = mb_strtolower($linkObj->Interwiki());
    $query = $linkObj->LocalPath();
    $anchor = $linkObj->LocalAnchor();

      $target = &$linkObj->settings->interwiki[$prefix];
      if (!$target and $query === '' and $anchor === '') {
        // ((numberlink:#)) or ((num:)) - access root URL of a numberlink via interwiki's handler.
        $target = &$linkObj->settings->numberlinks[$prefix];
      }

    if ($target) {
      $replace = array('{URL}' => urlencode($query), '{PATH}' => $query);
      $url = self::MakeInterwikiURL($target, $query, $replace);

      $linkObj->URL($url);
      self::IsEmptyStr($anchor) or $linkObj->UrlAnchor($anchor);

      return true;
    }
  }

    static function MakeInterwikiURL($target, $query, $urlReplaces) {
      $targetURL = $target['target'];
      if ($query === '') {
        $url = $target['root'];
        if ($url === '') {
          $pos = strrpos($targetURL, '/');
          $url = substr($targetURL, 0, $pos > strpos($targetURL, '://') + 3 ? $pos + 1 : 9999);
        }
      } else {
        $url = $targetURL;
      }

      $new = strtr($url, $urlReplaces);
      $new === $url and $new .= array_shift($urlReplaces);
      return $new;
    }

  static function ResolveNumberlink(&$caption, $linkObj) {
    $prefix = mb_strtolower($linkObj->Interwiki());
    if ($target = &$linkObj->settings->numberlinks[$prefix]) {
      // ((inter:path)) or ((inter:#path))
      $query = $linkObj->LocalPath();
      if ($query === '') {
        // ((inter:#)) or ((inter:)).
        $query = $linkObj->LocalAnchor();
      } elseif ($linkObj->LocalAnchor() !== '') {
        // ((inter:not#numlink))
        $query = '';
      }

      // Empty anchor part (linking to root) is handled by ResolveInterwiki().
      if ($query !== '' and is_numeric($query)) {
        $replace = array('{URL}' => $query, '{PATH}' => $query);
        $url = self::MakeInterwikiURL($target, $query, $replace);

        $linkObj->URL($url);
        if ($linkObj->wasAutoCaption) {
          $caption = sprintf($linkObj->strings['numberlink #'], $query);
        }
        return true;
      }
    }
  }
}

  class Uwacko_SquareLink extends Uwacko_Link {
    public $htmlClasses = array('square-brackets');

    static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags, $modSettings = array()) {
      parent::FindTokenCallback($doc, $raw, $positions, $stack, $token, $pos, $flags,
                                array('selfClass' => __CLASS__));
    }
  }

  class Uwacko_SelfLink extends Uwacko_Text {
    public $htmlTag = 'strong';
    public $htmlClasses = array('self-link');
  }

class UWackoLinkParser {
  static function IsExternalURL($url) { return Uwacko_Link::IsExternalURL($url); }
  static function IsAnchorLinkURL($url) { return Uwacko_Link::IsAnchorLinkURL($url); }
  static function IsEmptyStr($str) { return Uwacko_Link::IsEmptyStr($str); }
  static function DeleteIfUnevenTail($char, &$text) { return UWikiBaseElement::DeleteIfUnevenTail($char, $text); }

  static function MakeUrlFrom($info) {
    $url = $info['path'];
    self::IsEmptyStr($info['interwiki']) or $url = $info['interwiki'].UWikiInterwikiSeparator.$url;
    self::IsEmptyStr($info['anchor']) or $url .= Uwacko_AnchorChar.$info['anchor'];

    return $url;
  }

  static function QuoteWacko($str) {
    return UWikiDocument::Quote(html_entity_decode($str, ENT_QUOTES, 'UTF-8'), 'wacko');
  }

  // accounts for "~" escaping. returns null if str can't be split using given $delim
  // (i.e. if there are no occurrences of $delim or all of them are escaped).
  static function SplitUsing($delim, $str, $limit = 2) {
    $sides = array();

    $parts = explode($delim, $str);
    foreach ($parts as $i => &$part) {
      // url==~ -> (2) 'url', ''   but:   url~ -> (1) 'url~'
      if (isset( $parts[$i + 1] )) {
        if (self::DeleteIfUnevenTail(Uwacko_TildeToken, $part)) {
          $part .= $delim;
        } else {
          $sides[] = join( array_slice($parts, 0, $i + 1) );
          $lastIndex = $i;
          if (count($sides) + 1 >= $limit) {
            break;
          }
        }
      }
    }

    if (!empty($sides)) {
      $sides[] = join( $delim, array_slice($parts, $lastIndex + 1) );
      return $sides;
    }
  }

  static function NormalizeInfo(&$info, $settings) {
    if (!$info['isExternal']) {
      $info['path'] = str_replace('\\', '/', $info['path']);
      $info['anchor'] = mb_strtolower($info['anchor']);
    }
  }

  // Returns array with keys:
  // * isCaptionExplicit - did original link use == or not OR "+" syntax was processed;
  // * isExternal;
  // * isAnchor - whether or not this ((#construct)) is an inline anchor rather than a link;
  // * isAutoCaption - was caption omit or empty: ((url==)) or ((url));
  // * usedEndingSubst - whether or not "+" syntax was processed (and $tail used);
  // * url, caption;
  // * interwiki, path, anchor - parsed URL; interwiki and anchor can be null.
  // If $tail is null "+" syntax is not processed; if it's empty is just means a blank ending.
  static function Parse($str, $tail, $settings, $modSettings = array()) {
    $modSettings += array('inlineAnchors' => $settings->inlineAnchors);

    // possible delimiters: "==", " "; the first can be ~escaped.
    $info = self::ParseLinkStr($str);

      $url = &$info['url'];
      $caption = &$info['caption'];

    $info['isExternal'] = self::IsExternalURL($url);

    if ($info['isExternal']) {
      @list($path, $anchor) = explode('#', $url, 2);
      $info += array('interwiki' => '', 'path' => $path, 'anchor' => isset($anchor) ? $anchor : '');
    } else {
      $info += self::ParseLocalURL($url);
    }

    $info['usedEndingSubst'] = false;
    if (!$info['isExternal'] and !$info['isCaptionExplicit'] and $tail !== null) {
      $subst = self::DoEndingSubst($info, $tail, $settings);
      if ($subst !== null) {
        list($caption, $url) = $subst;
        $info['usedEndingSubst'] = true;
        $info['isCaptionExplicit'] = true;
      }
    }

    if (self::IsAnchorLinkURL($url) and $modSettings['inlineAnchors'] and $str === $url) {
      // ident. = anchor  < ((#anchor)) >  link = non-ident.
      $info['isAnchor'] = true;
    } else {
      $info['isAnchor'] = false;

      // e.g.: ((url)), ((u r l==)) or ((url )) (which doesn't make sense but is still fine).
      $info['isAutoCaption'] = trim($caption) === '';
      if ($info['isAutoCaption']) {
        self::MakeAutoCaption($info, $tail, $settings);
      }
    }

    self::NormalizeInfo($info, $settings);
    $info['url'] = self::MakeUrlFrom($info);

    return $info;
  }

  static function ParseLinkStr($str) {
    $info = array();

    $sides = self::SplitUsing(Uwacko_CompoundTokenSepar, $str);
    empty($sides) and $sides = explode(' ', $str, 2);

    $expl = $info['isCaptionExplicit'] = (isset($sides[1]) and !self::IsEmptyStr( $sides[1] ));
    $expl or $sides[] = '';

    return array('url' => trim($sides[0]), 'caption' => trim($sides[1])) + $info;
  }

  static function ParseLocalURL($url, $field = null) {
    $pieces = explode(UWikiInterwikiSeparator, $url, 2);
    isset($pieces[1]) and list($interwiki, $url) = $pieces;
    @list($path, $anchor) = explode(Uwacko_AnchorChar, $url, 2);

      isset($interwiki) or $interwiki = '';
      isset($anchor) or $anchor = '';

    return $field ? $$field : compact('interwiki', 'path', 'anchor');
  }

  static function DoEndingSubst(&$info, $tail, $settings) {
    if (!strpos($info['url'], Uwacko_LinkEndingSeparChar)) {
      return null;
    }

    foreach (array('interwiki', 'path', 'anchor') as $component) {
      $sides = self::SplitUsing(Uwacko_LinkEndingSeparChar, $info[$component], 3);
      if (count($sides) > 2) {
        return null;    // ambiguous, just ignore "+" syntax.
      } elseif ($sides) {
        list($common, $urlTail) = $sides;
        @list($urlTail, $commonTail) = explode(' ', $urlTail, 2);
        $commonTail = isset($commonTail) ? " $commonTail" : '';

          $wordCh = '/^['.$settings->wordCharacters.']+$/uS';
        if (mb_strlen($urlTail) > $settings->longestLinkEnding or
            ($tail === '' and $urlTail === '') or      // e.g. ((abc+)).none
            ($urlTail !== '' and !preg_match($wordCh, $urlTail)) or   // e.g. ((ab+c!))
            trim( mb_substr($common, -1) ) === '') {   // e.g. ((2 + 2==)) - not an ending.
          return null;
        } else {
          $info[$component] = $common.$urlTail.$commonTail;
          return array($common.$tail.$commonTail, self::MakeUrlFrom($info));
        }
      }
    }
  }

  static function MakeAutoCaption(&$info, $tail, $settings) {
    if ($info['isExternal']) {
      $info['caption'] = self::MakeAutoCaptionExt($info, $settings);
    } else {
      $info['caption'] = self::MakeAutoCaptionInt($info, $tail, $settings);
    }
  }

  static function MakeAutoCaptionExt(&$info, $settings) {
    $caption = null;

    if ($settings->fetchRemoteTitles) {
      $caption = self::FetchRemoteTitle($info['url'], $settings->fetchRemoteTitlesMaxSize);
    }

    if (self::IsEmptyStr($caption)) {
      $url = parse_url($info['url']);

      if ($url['host']) {
        $scheme = empty($url['scheme']) ? 'http' : strtolower($url['scheme']);
        if ($scheme !== 'http') { $caption = "$scheme://"; }
        $caption .= $url['host'];
      } else {
        $caption = mb_substr($info['url'], 0, 15).'…';
      }
      $caption = sprintf($settings->strings['bare url'], $caption);
    }

    return self::QuoteWacko($caption);
  }

    static function FetchRemoteTitle($url, $maxSize) {
      $result = null;

      if (stripos($url, 'http://') === 0 or stripos($url, 'https://') === 0) {
        $h = fopen($url, 'rb');
        if ($h) {
          $html = fread($h, min($maxSize, 512));

          if (strpos($html, '<html') !== false) {
            while (strlen($html) <= $maxSize) {
              if (($start = strpos($html, '<title>')) !== false and
                  ($end = strpos($html, '</title>', $start)) !== false) {
                $start += 7;
                $result = trim( substr($html, $start, $end - $start) );

                $headers = stream_get_meta_data($h);
                $result = self::PrepareRemoteTitle($result, $headers['wrapper_data']);

                break;
              } elseif (strpos($html, '</head>') !== false) {
                break;
              }

              $html .= fread($h, 1024);
            }
          }

          fclose($h);
        }
      }

      return $result;
    }

      static function PrepareRemoteTitle($title, $headers) {
        $lastCharset = null;

          foreach ($headers as $header) {
            if (stripos($header, 'Content-Type') === 0) {
              @list(, $charset) = explode('charset=', $header, 2);
              empty($charset) or $lastCharset = $charset;
            }
          }

        if ($lastCharset and function_exists('iconv')) {
          $title = iconv($lastCharset, 'UTF-8//IGNORE', $title);
        }

        if (preg_match('/./u', $title) and preg_last_error() === PREG_NO_ERROR) {
          return $title;
        }
      }

  static function MakeAutoCaptionInt(&$info, $tail, $settings) {
    $caption = self::MakeCaptionUsingUrlComponents($info, $settings);
    return $caption;
  }

    static function MakeCaptionUsingUrlComponents($info, $settings) {
      $doQuote = true;

      if (!self::IsEmptyStr($info['anchor'])) {
        $caption = $info['anchor'];
      } elseif (!self::IsEmptyStr($info['path'])) {
        if (self::IsEmptyStr($info['interwiki'])) {
          $caption = $settings->pager->GetTitleof($info['path']);
          if (is_object($caption)) {
            $caption = strip_tags( $caption->ChildrenToHTML(false) );
          } else {
            $doQuote = $settings->pager->FormatFrom($info['path']) !== $settings->markupName;
          }
        } else {
          $caption = '';
        }

        if (self::IsEmptyStr($caption)) {
          $caption = basename($info['path']);
          self::IsEmptyStr($caption) and $caption = rtrim($info['path'], '\\/');
          self::IsEmptyStr($caption) and $caption = $info['path'];
        }
      } elseif (!self::IsEmptyStr($info['interwiki'])) {
        $caption = $info['interwiki'];
      } else {
        $caption = $info['url'];
      }

      $doQuote and $caption = self::QuoteWacko($caption);
      return $caption;
    }
}
