<?php
include_once 'composite.php';   // needed for associative (dl/dt/dd) lists.

    $lineHandlers = &self::$loadedHandlers[$markup]['line'];
  $lineHandlers['Uwacko_ListItem'] = 50;
  // Note that order matters; Line class must be the last since it will handle any line.
  arsort($lineHandlers);

class Uwacko_AssocListItemPart extends Uwacko_CompositePart {
  public $isSingleLineHTML = true;
}

class Uwacko_ListItem extends Uwacko_Line {
  const SoftLineBreakChar = "\n\3";

  public $kind = 'listItem';

  static $markers = array('*' => array('maxMarkLen' => 1, 'htmlTag' => 'ul', 'type' => 'disc'),
                          '#' => array('maxMarkLen' => 1, 'htmlTag' => 'ul', 'type' => 'square'),
                          '-' => array('maxMarkLen' => 1, 'htmlTag' => 'ul', 'type' => 'circle'),
                          '=' => array('maxMarkLen' => 1, 'htmlTag' => 'dl', 'type' => 'assoc'),

                          '.1234567890' => array('maxMarkLen' => 2, 'htmlTag' => 'ol', 'type' => 'decimal'),
                          '.ivx' => array('maxMarkLen' => 5, 'htmlTag' => 'ol', 'type' => 'lower-roman'),
                          '.IVX' => array('maxMarkLen' => 5, 'htmlTag' => 'ol', 'type' => 'upper-roman'),
                          '.abcdefghijklmn' => array('maxMarkLen' => 1, 'htmlTag' => 'ol', 'type' => 'lower-alpha'),
                          '.ABCDEFGHIJKLMN' => array('maxMarkLen' => 1, 'htmlTag' => 'ol', 'type' => 'upper-alpha'));
  static $orderedMarkerEndChars = '.)';

  public $htmlTag = 'li';
  // browsers display new lines as spaces around list items if they have display: inline.
  public $isSingleLineHTML = true;

  public $listHtmlTag;

  public $marker, $level, $markerType;
  public $markerValue;     // is only set for ordered lists; is null for unordered.
  // if true will leave out $markerValue thus incrementing previous marker's value.
  public $isSuccessive;    // is set by Uwacko_List.
  public $groupClass = 'Uwacko_List';

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);

    array_push($props['str'], 'listHtmlTag', 'marker', 'markerValue', 'markerType');
    $props['int'][] = 'level';
    $props['bool'][] = 'isSuccessive';
  }

  static function CanHandleLine($line, $doc) { return self::ListInfoFrom($line) != null; }

  function ContinuesIf($newLine, $doc) {
    $info = $this->ListInfoFrom($this->raw);
    if (!$this->CanHandleLine($newLine, $doc) and $info and
        self::CountLeftWhiteSpace($newLine) >= $info['leftSpaceLength'] + 2) {
      return $this->settings->breakListsOnNewline ? self::SoftLineBreakChar : true;
    } else {
      return false;
    }
  }

    static function ListInfoFrom(&$line) {
        $leftSpaceLength = self::CountLeftWhiteSpace($line);

      $level = (int) ($leftSpaceLength / 2);
      $level and $marker = self::MarkerFrom( substr($line, $leftSpaceLength) );

      return (($level and $marker) ? compact('level', 'leftSpaceLength') + $marker : null);
    }

      static function MarkerFrom($line) {
        foreach (self::$markers as $charSet => &$info) {
          $endChars = $charSet[0] === '.' ? self::$orderedMarkerEndChars : null;
          $endChars === null or $charSet = substr($charSet, 1);

            isset( $info['_charArray'] ) or $info['_charArray'] = array_flip( str_split($charSet) );

          $maxLength = $info['maxMarkLen'];
          $marker = '';

          $type = $info['type'];
          if ($type === 'decimal' and $line[0] === '0') {
            $marker .= '0';
            $type = 'decimal-leading-zero';
          }

          for ($i = strlen($marker); $i < $maxLength and isset($line[$i]); ++$i) {
            if (isset( $info['_charArray'][$line[$i]] )) {
              $marker .= $line[$i];

              $value = null;
              if ($endChars === null) {
                if ($line[$i + 1] !== ' ') { continue; }
              } else {
                if (@strpos($endChars, $line[$i + 1]) !== false and $line[$i + 2] === ' ') {
                  $value = $marker;
                  $marker .= $line[$i + 1];
                } else {
                  continue;
                }
              }

              return compact('marker', 'type', 'value') + $info;
            } else {
              break;
            }
          }
        }
      }

  function Parse() {
    $itemContents = $this->raw;
    $this->SetSettingsFrom($itemContents);

    if ($this->markerType === 'assoc') {
      $this->raw = &$itemContents;

      $settings = array('allowEmptyRight' => true, 'appendPartIfNone' => false);
      $this->children =
        Uwacko_Composite::SplitAs('Uwacko_AssocListItemPart', $this, $this->raw, $settings);

        if (!$this->children) {
          // list item with neither == nor space: "  = something".
          $title = $this->children[0] = $this->NewElement('Uwacko_AssocListItemPart');
          $title->SetRaw($this->raw);
          $title->Parse();

          $this->children[1] = $this->NewElement('Uwacko_AssocListItemPart');
        }

      $this->children[0]->htmlTag = 'dt';
      $this->children[1]->htmlTag = $this->children[1]->children ? 'dd' : null;
      $this->children[0]->isBlock = $this->children[1]->isBlock = true;
    } else {
      parent::Parse();
    }
  }

    function SetSettingsFrom(&$raw) {
        $info = $this->ListInfoFrom($raw);
        if (!$info) { throw new EUverseWiki('List item created for a non-list line?'); }

      $this->marker = $info['marker'];
      $this->markerValue = $info['value'];
      $this->level = $info['level'];
      $this->listHtmlTag = $info['htmlTag'];
      $this->markerType = $info['type'];
      $this->isSuccessive = false;

      $raw = substr($raw, $info['leftSpaceLength'] + strlen( $info['marker']) );
      $raw = ltrim($raw);
    }

  function Anchorize($baseAnchorName = null) {
    if ($this->markerType === 'assoc') {
      return $this->children[0]->Anchorize($baseAnchorName);
    } else {
      return parent::Anchorize($baseAnchorName);
    }
  }

    function AnchorizeIfNeeds($baseAnchorName = null) {
      if ($this->markerType === 'assoc') {
        return $this->children[0]->AnchorizeIfNeeds($baseAnchorName);
      } else {
        return parent::AnchorizeIfNeeds($baseAnchorName);
      }
    }

  function AllToHTML() {
    if ($this->markerType === 'assoc') {
      $this->htmlTag = null;

      if ($extraChildren = array_splice( $this->children, 2, count($this->children) )) {
        $this->children[1]->children = array_merge($this->children[1]->children, $extraChildren);
      }
    }

    return parent::AllToHTML();
  }

    function SelfToHtmlWith($contents) {
      $html = parent::SelfToHtmlWith($contents);
      if ($this->settings->breakListsOnNewline) {
        $html = str_replace(self::SoftLineBreakChar, '<br /><span class="soft-break"></span>', $html);
      }
      return $html;
    }

      function SelfHtmlAttributes() {
        return array('class' => $this->markerType,
                     'value' => $this->isSuccessive ? null : $this->markerValue);
      }

  // for use with extensions (e.g. {{AnchorizeAssocLists}}):
  function TermElement() { return $this->children[0]; }
  function DefinitionElement() { return $this->children[1]; }
}

class Uwacko_List extends Uwacko_Lines {
  public $kind = 'list';

  function ParseLines() {
    parent::ParseLines();

    $items = $this->children;
    $this->children = array( $this->BuildListFrom($items, 'Uwacko_ListPadItem', 'Uwacko_SubList') );
  }

    function PrepareItem($item, &$stack) {
      if (!empty( $stack[0]->children )) {
        $value = $item->markerValue;

        if (!self::IsEmptyStr($value)) {
          $prevValue = self::LastIn($stack[0]->children)->markerValue;
          $item->isSuccessive = ($prevValue !== null and $prevValue === $value);
        }

        if ($value and strpbrk($value[0], 'iI')) {
          // Resolving ambiguity between latin & Roman lists
          // (e.g. "A. B. C... I. J." - I/i are Roman markers).
          $case = ($value[0] === 'i' ? 'lower' : 'upper');
          if ($stack[0]->children[0]->markerType === "$case-alpha") {
            $item->markerType = "$case-alpha";
          }
        }
      }
    }
}

  class Uwacko_ListPadItem extends Uwacko_ListItem {
    function Pad($item) {
      $padText = str_repeat('  ', $this->level)." {$item->marker} .";
      $this->SetSettingsFrom($padText);
    }
  }

  class Uwacko_SubList extends Uwacko_Base {
    public $isBlock = true;
    public $isSingleLineHTML = true;
    public $level;

    function SetupSerialize(array &$props) {
      parent::SetupSerialize($props);
      $props['int'][] = 'level';
    }

    function Group($childItem) {
      $this->htmlTag = $childItem->listHtmlTag;
    }
  }
