<?php
/*
  %%(caps) XyzZi%%  => <big>X</big>yz<big>Z</big>i

  Useful in archieving effect of large-capitalized & rest-capitalized with CSS
  (text-transform: uppercase and <big> letters are already larger in size then the rest).
  Only works with plain text, no markup.
*/

class Ucaps_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;

  public $htmlTag = 'span';
  public $htmlClasses = array('caps');

  function Parse() { }

  function SelfToHtmlWith($contents) {
    $chars = $this->settings->wordCharacters;
    return parent::SelfToHtmlWith( preg_replace('/['.$chars.']/u', '<big>\0</big>', $this->raw) );
  }
}
