<?php
/*
  Options:
    * replace - a template used to replace the original U+XXXX[XX] sequence
    * hint - a boolean flag enabling HTML hint box on hover; can be 'auto' to enable hinting on rendering into HTML
    * match - regular expression used to match the Unicode code (U+...)

  Replacements:
    * $char - raw Unicode char
    * $html - the same char but HTML-escaped (<, >, &, " and ')
    * $dec - decimal character code without padding
    * $hex - uppercase hexadecimal code padded to 4 or 6 characters
    * $hexup1 .. $hexup6 - uppercase hex code padded to 1..6 chars respectively
    * $hexlow1 .. $hexlow6 - the same as $hexupX but in lower case
*/

$GLOBALS['unichar'] = array(
  'wacko html'  => array(
    'replace'   => '$html (U+$hex)',
    'hint'      => true,
  ),
  '*'           => array(
    'hint'      => 'auto',
  ),
);

UWikiDocument::$afterRenderingHooks[] = 'ExpandUnicodeChars';

function ExpandUnicodeChars($format, &$result, UWikiDocument $doc) {
  global $unichar, $unicharCSS, $unicharJS;

  $markup = $doc->LoadedMarkup();

  $options = &$unichar["$markup $format"];

  if (!isset($options)) {
    foreach ($unichar as $cond => $options) {
      if (fnmatch($cond, "$markup $format")) {
        break;
      }
    }
  }

  $options += array(
    'match'       => '~\bU\+([a-fA-F0-9]{4}([a-fA-F0-9]{2})?)\b~u',
    'replace'     => false,
    'hint'        => false,
  );

  if ($options['replace'] or $options['hint']) {
    $options['hint'] === 'auto' and $options['hint'] = strpos($format, 'html') === 0;

    $unichar[''] = $options;
    $result = preg_replace_callback($options['match'], 'UnicodeCharsReplacer', $result);

    if (!empty($unichar['']['attach'])) {
      $doc->Attach('css', $unicharCSS, 'unichar');
      $doc->Attach('js', $unicharJS, 'unichar');
    }
  }
}

  function UnicodeCharsReplacer($match) {
    global $unichar;

    $opts = &$unichar[''];

    $result = $match[0];

    $hex = strtoupper($match[1]);
    $hex = sprintf('%0'.(strlen($hex) > 4 ? 6 : 4).'s', $hex);

    $dec = hexdec($hex);
    $char = pack('H*', $hex);
    $html = "&#x$hex;";

    if ($opts['replace']) {
      $vars = array('$char' => $char, '$html' => $html, '$dec' => $dec, '$hex' => $hex);

      for ($i = 1; $i <= 6; ++$i) {
        $vars["\$hexup$i"] = str_pad($hex, $i, '0', STR_PAD_LEFT);
        $vars["\$hexlow$i"] = str_pad(strtolower($hex), $i, '0', STR_PAD_LEFT);
      }

      $result = strtr($opts['replace'], $vars);
    }

    if ($opts['hint']) {
      $opts['attach'] = true;

      $call = "Unichar(event, '$html', 'U+$hex'";
      $result = '<span class="unichar" onmousemove="'.$call.', true);"'.
                       ' onmouseout="'.$call.', false);">'.
                  $result.
                '</span>';
    }

    return $result;
  }

$GLOBALS['unicharCSS'] = <<<CSS
span.unichar {
  cursor: help;
  border-bottom: 1px dashed green;
}

#unichar {
  position: absolute;
  z-index: 100;
  margin-top: 0.4em;
  background: #DDD;
  border: 1px outset;
  padding: 0.5em;
}

#unichar span {
  background: white;
  font-size: 3em;
  padding: 0 2px;
}

#unichar kbd {
  font-size: 1.5em;
  padding: 0 0.1em 0 0.5em;
  float: right;
  margin-top: 0.9em;
}
CSS;

$GLOBALS['unicharJS'] = <<<JAVASCRIPT
function Unichar_PageYFrom(event) {
  if (event.pageY) {
    return event.pageY;
  } else if (event.clientY) {
     return event.clientY + (document.documentElement.scrollTop ? document.documentElement.scrollTop
                                                                 : document.body.scrollTop);
  } else {
    return 0;
  }
}

function Unichar_PageXFrom(event) {
  if (event.pageX) {
    return event.pageX;
  } else if (event.clientX) {
     return event.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft
                                                                 : document.body.scrollLeft);
  } else {
    return 0;
  }
}

function Unichar(event, char, code, show) {
  var box = window.unichar;

    if (!box) {
      box = document.createElement('div');
      window.unichar = box;
      box.innerHTML = '<span></span><kbd></kbd>';
      document.body.appendChild(box);

      box.id = 'unichar';
    }

  box.firstChild.innerHTML = char;
  box.lastChild.innerHTML = code;

  box.style.left = Unichar_PageXFrom(event) + 'px';
  box.style.top = Unichar_PageYFrom(event) + 'px';
  box.style.display = show ? 'block' : 'none';
}
JAVASCRIPT;
