<?php
/*
   This script will convert all wiki files in current directory from class heading
  mode (==Doc title== ===Subheading=== and so on) into shifted or extended modes.
  For more info about heading modes see the description of headingMode setting.

  In particular it takes all wiki files (including those in subdirectories) and removes
  1 leading and 1 trailing equality signs for lines looking like heading lines.
  If $firstHeading (below) is set to true the first heading will be left intact -
  just what extended heading mode needs.

  > WARNING: FILES WILL BE CHANGED IN-PLACE (overwriting source files). <
*/

  $files = Fix('', glob('*.wiki'));

  function Fix($path, $files) {
    foreach ($files as $file) {
      $lines = file($file, FILE_IGNORE_NEW_LINES);

        // set this to true for headingMode = 'extended'; set to false for 'shifted'.
        $firstHeading = true;
        foreach ($lines as &$line) {
          if (substr($line, 0, 2) === '==' and substr($line, -2) === '==') {
            if ($firstHeading) {
              $firstHeading = false;
            } else {
              $line = substr($line, 1, -1);
            }
          }
        }

      file_put_contents($file, join("\n", $lines));
      echo "Done with $file.\n";
    }

    foreach (glob($path.'*', GLOB_ONLYDIR | GLOB_MARK) as $sub) {
      Fix($sub, glob($sub.'*.wiki'));
    }
  }
