<?php
  $selfUpDirsToEngineRoot = 1;
  require '../engine/page.php';
  set_time_limit(180);
  ignore_user_abort(false);

  echo '<h1>Index maintenance</h1>';

  if (!empty($_REQUEST['submit'])) {
    echo PerformIndexAction('rebuild'),
         PerformIndexAction('clear'),
         '<strong>Done.</strong>';
  }
?>

<form action="indexes.php" method="get">
  <?php
    echo HtmlForIndexAction('rebuild'), HtmlForIndexAction('clear');
  ?>

  <input type="submit" name="submit" value="Perform" />
</form>

<?php
  function HtmlForIndexAction($action) {
    $result = '';

      foreach (BEvent::$list['index: '.$action] as &$callback) {
        $cbID = BEvent::IdOfCallback($callback);
        $chk = empty($_REQUEST[$action][$cbID]) ? '' : ' checked="checked"';

        $cbID = htmlspecialchars($cbID);
        $id = "{$action}_$cbID";
        $label = str_replace('&gt;', ' - ', $cbID);

        $result .= '<li><input type="checkbox" name="'.$action.'['.$cbID.']"'.
                             ' value="1" id="'.$id.'"'.$chk.' />'.
                       '<label for="'.$id.'">'.$label.'</label></li>';
      }

    $result and $result = '<h2>'.ucfirst($action).'</h2><ol>'.$result.'</ol>';
    return $result;
  }

  function PerformIndexAction($action) {
    $result = '';

    if ($cb = &$_REQUEST[$action]) {
      foreach ($cb as $id => $value) {
        foreach (BEvent::$list['index: '.$action] as &$callback) {
          if (BEvent::IdOfCallback($callback) === $id) {
            $result .= "<li>$id&hellip;";
            BEvent::CallSingle($callback);
            $result .= '<strong>OK</strong></li>';

            break;
          }
        }
      }

      $result and $result = '<h2>'.ucfirst($action).'</h2><ol>'.$result.'</ol>';
    }

    return $result;
  }
