<?php
  $selfUpDirsToEngineRoot = 1;
  require '../engine/page.php';
  set_time_limit(0);  // we never know how large posts and how many of them there might be.
  ignore_user_abort(false);

  // utf8 gets broken during transmission if not explicitly urlencoded.
  $current = urldecode( @$_REQUEST['current'] );
  $new = urldecode( @$_REQUEST['new'] );

  if (BPosts::Exists($current) and $new and !BPosts::Exists($new)) {
    BPosts::Move($current, $new);
    echo '<strong>Moved '.htmlspecialchars8($current).' -> '.htmlspecialchars8($new).'</strong>';
    exit;
  }
?>

<form action="move-posts.php" method="post">
  <p> <input type="submit" /> </p>

  <p> <strong>Existing posts:</strong> </p>
  <?php
    $id = 1;
    foreach (BPosts::All() as $post) {
      echo '<input type="radio" name="current" value="'.urlencode($post).'" id="c'.$id.'" />',
           '<label for="c'.$id++.'">'.$post.'</label><br />';
    }
  ?>

  <p> <strong>Posts to repair with:</strong> </p>
  <?php
    foreach (GetNewPostsIn(BConfig::FromUTF8('file name', BConfig::$paths['posts'])) as $post) {
      echo '<input type="radio" name="new" value="'.urlencode($post).'" id="c'.$id.'" />',
           '<label for="c'.$id++.'">'.$post.'</label><br />';
    }
  ?>

  <p> <input type="submit" /> </p>
</form>

<?php
  // todo: almost the same as GetChangedPostsIn of update-posts.php.
  function GetNewPostsIn($dir, $prefix = '') {
    $dir = rtrim($dir, '\\/');
    $files = scandir($dir);

    $new = array();

      foreach ($files as $file) {
        if (ExtOf($file) === BConfig::$postFileExt and is_file("$dir/$file")) {
          $post = BConfig::ToUTF8('file name', $prefix.basename("$dir/$file"));
          if (!BPosts::Exists($post)) {
            $new[] = $post;
          }
        }
      }

    $engineRoot = BConfig::FromUTF8('file name', BConfig::$enginePath);
    $engineRoot = rtrim($engineRoot, '\\/');

      foreach ($files as $subdir) {
        if ($subdir !== '.' and $subdir !== '..' and
            is_dir("$dir/$subdir") and $engineRoot !== "$dir/$subdir") {
          $new = array_merge($new, GetNewPostsIn("$dir/$subdir", $prefix.$subdir.'/'));
        }
      }

    return $new;
  }
