<?php
require_once 'engine/page.php';

$filter = BFilter::Parse(@$_REQUEST['filter'], $action);
$posts = BPosts::By($filter);

$criteriaDesc = '';
$criteriaType = 'filter';

  switch (count($filter)) {
  case 0:   $criteria = Translate('Recent posts'); $criteriaType = 'recent'; break;
  default:  $criteria = Translate('Posts matching your filter'); break;

  case 1:
    list($field, $arg) = $filter[0];

    $lang = 'criteria: '.$field;
    switch ($field) {
    // @dd.mm.yy:
    case 'dateday':   $arg = DateFmt::Format('AGO-AT[s-d]IF>7[d# M__ y##]', $arg); break;
    // @mm.yy:
    case 'datemonth': $arg = DateFmt::Format('AT[M__ y##]', $arg); break;
    // @yy:
    case 'dateyear':  $arg = date('Y', $arg); break;

    case 'tags':
      $criteriaDesc = BTags::DescOf($arg);
      $arg = BTags::CaptionOf($arg);
    }

    $criteria = sprintf(Translate($lang), $arg);
  }

$origRequest = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

$page = new BPage;
$action or $action = 'list';
isset($isMainPage) or $isMainPage = false;
$page->Run($action, array( compact('posts', 'criteria', 'criteriaType', 'criteriaDesc', 'origRequest', 'isMainPage') + $_REQUEST ));
