<?php

class BListPage {
  // $options for many posts - array of commons + these: criteria, criteriaDesc (opt.).
  // common $options: posts, origRequest, isMainPage.
  function Generate($page, $options) {
    $posts = $options['posts'];

    $options += GetPageVars( count($posts) === 1 ? '#comments' : '' );

    if (count($posts) === 1) {
      // todo: move url messing to events.
      // Possible URL forms user agents might use:
      // 1. UTF-8 + urlencode - that's what we use in redirections;
      // 2. ASCII (utf8_decode) + urlencode;
      // 3. just ASCII.
      $orig = trim(@$options['origRequest'], '/');
      $orig = trim(strtok($orig, '?'));

        if ($orig !== '') {
          $permalink = trim(BPosts::UrlOf($posts[0]), '/');  // UTF-8 + urlencode

          if ($orig !== $permalink and urldecode($orig) !== $permalink and
              utf8_decode(urldecode($orig)) !== $permalink) {
            RedirectTo($permalink, 'permanent');
          }
        }

      $tpl = 'blog post';
      $vars = $this->OnePost($posts[0], $options);
    } else {
      $tpl = 'blog list';
      $vars = $this->ManyPosts($posts, $options);
    }

    $page->FillAs($tpl, $vars);
  }

  static function TotalCountFrom($total, $perPage) {
    if ($perPage === 0) {
      return $total ? 1 : 0;
    } else {
      return (int) ceil($total / $perPage);
    }
  }

  static function GetFooterNotice($type, $posts) {
    $notice = BEvent::FireResult('array', "$type footer", array($posts));
    return join(' | ', $notice);
  }

  function ManyPosts($posts, $options) {
    BPosts::SortAs('TimeDesc', $posts);

    $current = $options['currentPage'] > 0 ? $options['currentPage'] : 0;
    $total = self::TotalCountFrom(count($posts), BConfig::$postsPerPage);

    $count = BConfig::$postsPerPage ? BConfig::$postsPerPage : count($posts);
    $posts = array_slice($posts, $current * BConfig::$postsPerPage, $count);

    BEvent::Fire('posts viewed', array($posts));

    $listHeader = array(@$options['criteriaDesc']);
    BEvent::Fire('posts list header', array($posts, &$listHeader));

    $vars = array('$criteria' => $options['criteria']);
    $pageTitle = BConfig::PageTitleFor('blog list', '$criteria &mdash; $siteName', $vars);

    $vars = array('pageTitle' => $pageTitle, 'criteria' => $options['criteria'],
                  'isMainPage' => !empty($options['isMainPage']) and !$current,
                  'listHeader' => join($listHeader),
                  'listFooter' => join( BEvent::FireResult('array', 'posts list footer', array($posts)) ),
                  'pageURL' => $options['pageURL'], 'totalPages' => $total,
                  'currentPage' => $current, 'posts' => self::GetPosts($posts),
                  'footerNotice' => self::GetFooterNotice('posts', $posts));

    BTplVars::Set('post list', $vars, $posts);
    return $vars;
  }

    function GetPosts($posts) {
      $postVars = BPosts::Get($posts);

        foreach ($postVars as $i => &$post) {
            $name = $posts[$i];

          $post['page'] = &$post['shortened'];
          $post['commentCount'] = BComments::TotalOf($name);
          BTplVars::Set('post', $post, $name);
        }

      return $postVars;
    }

  function OnePost($post, $options) {
    $vars = BPosts::Get($post);

      if (!$vars) { throw new BException("Post $post doesn't exist."); }
      BEvent::Fire('post viewed', $post);

    $vars += array(
      'pageTitle' => $this->PageTitleFor($post, $options),
      'footerNotice' => self::GetFooterNotice('post', $post),
      'comments' => $this->CommentsOf(BComments::ReferrerFor($post), $options),
      'commentCount' => BComments::TotalOf($post)
    );

    BTplVars::Set('post', $vars, $post);
    return $vars;
  }

    function PageTitleFor($post, $options) {
      $vars = array();

        if ($tags = BPosts::Get($post, 'tags')) {
          $tags = BTags::Translate($tags);
          $vars += array('$spaceTags' => join(' ', $tags), '$commaTags' => join(', ', $tags));
        }

      if ($cat = BPosts::Get($post, 'category')) {
        $cat = BTags::Translate($cat);
        $vars += array('$categoryAQ' => join(' » ', $cat),
                       '$categoryRevAQ' => join(' « ', array_reverse($cat)));

        $title = BConfig::PageTitleFor('blog post', '$rawTitle &mdash; $categoryRevAQ', $vars);
      } else {
        $title = BConfig::PageTitleFor('blog post without category', '$rawTitle', $vars);
      }

      return BPosts::FormatLinkOf($post, $title);
    }

    // $parent - referrer (i.e. masked post+thread).
    function CommentsOf($parent, $options) {
      $total = BComments::TotalOfComment($parent);
      $total = self::TotalCountFrom($total, BConfig::$commentsPerPage);

      $limits = BConfig::$commentNestingLimits;
      array_unshift($limits, BConfig::$commentsPerPage);
      $options['sort'] = BConfig::$commentSorting;

      return array(
        'pageURL' => $options['pageURL'], 'totalPages' => $total,
        'currentPage' => ($options['currentPage'] > 0 ? $options['currentPage'] : 0),
        'items' => BComments::Of($parent, compact('limits') + $options)
      );
    }

  function LastChangeToFooter(&$footer, $post) {
    $fmt = ' <strong>AGO[s-d]IF-FAR[d#my]</strong>';
    $footer[] = Translate('Changed').DateFmt::Format($fmt, BPosts::Get($post, 'lastChanged'));
  }
}

BEvent::Hook('post footer', array('BListPage', 'LastChangeToFooter'));
