<?php

abstract class BaseSidebar {
  static $confShortcuts = array();

  public $type = 'other';   // sidebar type for the template.
  public $hasExtConfig = false;

  protected $info, $generalConfig, $config;

  static function InstallationConfShortcuts() {
    BEvent::HookFirst('on plugin section', array(__CLASS__, 'ExpandConfShortcuts'));
  }

    static function ExpandConfShortcuts($installator, &$code) {
      $installTo = $installator->installTo;
      if ($installTo and ExtOf($installTo) === '.conf' and
          mb_strpos($installTo, BConfig::FileOf('config', 'sidebars').'/') === 0) {
        $code = strtr($code, self::$confShortcuts);
      }
    }

  function Generate(array &$info) {
    $this->info = &$info;
    $this->generalConfig = &$info['config'];
    $this->config = $this->ParseConfig($info['rawContent']);

    $info['type'] = $this->type;
    $info['content'] = $this->DoGenerate();

    $this->NormalizeSidebar();
  }

    function ParseConfig(&$str) {
      return $this->hasExtConfig ? ParseKeyValuesExt($str) : ParseKeyValues($str, '=');
    }

    function NormalizeSidebar() { }

    abstract function DoGenerate();
}

BaseSidebar::$confShortcuts["\n#=shortener\n"] = <<<SHORTENER

# max comment body length shown on the sidebar.
shorten max = 150
# if last word preceding the cut is cut in the middle and if it's just 'shorten soft'
# chars longer than the limit ('shorten max') - exceed the limit anyway.
shorten soft' = 10
# text appearing in the end of cut, if there's still some full text left.
shorten cut = 
# text replacing paragraph breaks.
shorten paragraph = \\x20&nbsp;
# comma-separated list of UverseWiki inline node Kinds removed from the output (non-recursive).
shorten skip = anchor, format, footnote\n
SHORTENER;
