<?php
// holds e-mail addresses which should not receive any messages (see BConfig::MailTo()).
class BlockedemailsFileIndex extends BaseBoolHashFileIndex {
  public $indexName = 'blocked-emails';

  static function BlockIfListed(EMail $email) {
    self::FilterBlockedEMailsFrom($email->to);
    self::FilterBlockedEMailsFrom($email->copyTo);
    self::FilterBlockedEMailsFrom($email->bccTo);
  }

    static function FilterBlockedEMailsFrom(array &$list) {
      foreach ($list as $i => $addr) {
        if (self::IsBlocked($addr)) { unset($list[$i]); }
      }
    }

  static function IsBlocked($addr) {
    return BIndex::SelectFrom('BlockedEMails', EMail::ExtractFrom($addr));
  }

  static function GetFooter(array &$footers, array $bodies, EMail $email) {
    $total = count($email->to) + count($email->copyTo) + count($email->bccTo);
    if ($total != 1) { return; }

    $email->to and $addr = $email->to[0];
    $email->copyTo and $addr = $email->copyTo[0];
    $email->bccTo and $addr = $email->bccTo[0];

    $vars = array('email' => $addr, 'link' => self::BlockingUrlOf($addr));
    $footer = Template::Format('email - footer', $vars);

      $key = self::BlockingKeyOf($addr);
      foreach ($bodies as $format => &$body) {
        if (mb_strpos($body, $key) !== false) {
          unset($footer[$format]);
        }
      }

    $footers[] = &$footer;
  }

  static function BlockingUrlOf($email, $tail = '') {
    "$tail" === '' or $tail = "&$tail";
    return BConfig::$engineURL."no-mail.php?email=$email&key=".self::BlockingKeyOf($email).$tail;
  }

    static function BlockingKeyOf($email) {
      return MD5_24( BConfig::$secret."\0".strtolower($email) );
    }
}
