<?php
// total number of comments added to a post.
class CommentcountsFileIndex extends BaseIntHashFileIndex {
  public $indexName = 'comment-counts';

  function CommentAdded($comment) { parent::Add( BComments::PostOf($comment) ); }
  function CommentRemoved($comment) { parent::Remove( BComments::PostOf($comment) ); }

  function CommentMoved($comment, $newName, &$info) {
    $this->Remove($comment);
    $this->Add($newName);
  }

  function Rebuild() {
    $this->Clear();

    foreach (BComments::AllRecursive() as $post => $comments) {
      $this->Add($post, count($comments));
    }
  }
}
