<?php

class EMailVars {
  static function MakeVars(array &$vars, $prefix) {
    $res = array();
    foreach ($vars as $key => &$value) { $res[ $prefix.ucfirst($key) ] = &$value; }
    return $res;
  }

  static function CommonFor($email) {
    $name = ucfirst(strtok($email, '@'));
    strpbrk($name, '_.-') and $name = preg_replace('~[_.-](.)~e', 'strtoupper(\' \1\')', $name);

    return array('recepientEMail' => $email, 'recepientName' => $name);
  }

  static function ForPost($post) {
    $vars = self::MakeVars(BPosts::Get($post), 'post');

    return array('F!postTitle' => array('.txt' => $vars['postTextTitle'],
                                        '.html' => $vars['postPostTitle']),
                 'F!postText' => array('.wiki' => $vars['postSource']),
                 'T!postLastChanged' => $vars['postLastChanged'],
                 'U!postPermalink' => $vars['postPermalink'],
                 'U!postThumbnail' => $vars['postThumbnail']) + $vars;
  }

  static function ForComment($comment, $prefix, $commentPath = null) {
    if (!is_array($comment)) {
      $commentPath = $comment;
      $comment = BComments::Get($comment);
    }

    if ($comment['formatter'] === 'wiki') {
      $text = array('.wiki' => $comment['source']);
      $signature = array('.wiki' => $comment['signatureSource']);
    } else {
      $text = array('.txt' => $comment['source'], '.html' => $comment['text']);
      $signature = array('.txt' => $comment['signatureSource'], '.html' => $comment['signature']);
    }

    return array("{$prefix}URL" => BComments::UrlOf($commentPath),
                 "F!{$prefix}Text" => $text, "F!{$prefix}Signature" => $signature)
           + self::MakeVars($comment, $prefix);
  }

  static function OnNewComment($parent, $comment, array $info, &$event) {
    $post = BComments::PostOf($parent);

    $event = 'new comment';
    BComments::Exists($parent) and $event .= ' reply';

    $vars = self::ForPost($post) + self::ForComment($info, 'comment', $comment);
    BComments::Exists($parent) and $vars += self::ForComment($parent, 'parentComment');

    return $vars;
  }
}
