<?php
// all blog comments ordered by time and grouped by post.
class PostcommentdatesFileIndex extends BaseHashOfDatesFileIndex {
  public $indexName = 'post-comment-dates';

  function CommentAdded($parent, $comment, &$info) {
    $this->Add( array(BComments::PostOf($comment), $comment) );
  }

  function CommentRemoved($comment) {
    $this->Remove( array(BComments::PostOf($comment), $comment) );
  }

  function CommentMoved($comment, $newName, &$info) {
    $this->CommentRemoved($comment);
    $this->CommentAdded($comment);
  }

  function Rebuild() {
    $this->Clear();

    foreach (BComments::AllRecursive() as $post => $comments) {
      foreach ($comments as $comment) {
        $time = BComments::Get($comment, 'time');
        $this->Add(array(BComments::PostOf($comment), $comment), $time);
      }
    }
  }
}
