<?php
// a link between short post "ID" used e.g. to generate folder names in _blog/comments and
// actual post name (containing slashes, non-ANSI symbols and other unsafe characters).
class PostmasksFileIndex extends BaseArrayFileIndex {
  const SuffixLength = 30;
  public $indexName = 'post-masks';

  function Mask(&$masked, $post) {
    $masked = $this->Select($post);
    $masked or $masked = $this->Add($post);
    $masked .= $this->SuffixFor($post);
  }

    // it doesn't matter if suffix is corrupted during transmission (between masking and
    // unmasking) - what matters is leading number so we can use national chars.
    function SuffixFor($post) {
      $extLen = strlen(BConfig::$postFileExt);
      $post = mb_substr($post, -1 * self::SuffixLength - $extLen, -1 * $extLen);
      // braces are potentionally unsafe chars for glob().
      $post = strtr($post, '[]{}./\\\'"', '_________');
      return '-'.$post;
    }

  // using (int) because $masked may contain a suffix, e.g.: "34-my-post" - useful for
  // identification of posts when browsing through _blog/comments folder manually.
  function Unmask(&$post, $masked) {
    $post = $this->SelectByIndex((int) $masked);
    if (!$post) {
      throw new BException('Cannot find post name for mask "'.$masked.'".');
    }
  }
}
