<?php
// count of posts tagged with given tag.
class TagcountsFileIndex extends BaseIntHashFileIndex {
  public $indexName = 'tag-counts';

  function Select($tag) { return parent::Select( mb_strtolower($tag) ); }
  function Add($tag) { parent::Add( mb_strtolower($tag) ); }
  function Remove($tag) { parent::Remove( mb_strtolower($tag) ); }

  function Rename($tag, $newName) {
    parent::$this->Rename(mb_strtolower($tag), mb_strtolower($newName));
  }

  function PostAdded($post, $doc) {
    foreach ($doc['tags'] as $tag) { $this->Add($tag); }
  }

  function PostUpdated($post, $doc, $oldDoc) {
    $this->PostDeleted($post, $oldDoc);
    $this->PostAdded($post, $doc);
  }

  function PostDeleted($post, $doc) {
    foreach ($doc['tags'] as $tag) { $this->Remove($tag); }
  }

  function Rebuild() {
    $this->Clear();

    foreach (BPosts::All() as $post) {
      foreach (BPosts::Get($post, 'tags') as $tag) { $this->Add($tag); }
    }
  }
}
