<?php

class Template {
  static $tplExts = array('.txt' => 1, '.html' => 1, '.wiki' => 1, '.php' => 1);

  static $readTplCache = array();

  static protected $directiveCbVars;    // used by ProcessDirectives().
  static protected $lastDirectiveVars;  // used by ProcessDirectives().

  static function FileOf($tpl, $suffix = '') {
    if (ltrim($tpl.ltrim($suffix, '.'), 'a..zA..Z0..9_- ') === '') {
      return BConfig::FileOf('config', "templates/$tpl$suffix");
    }
  }

  static function Read($tpl, $suffix) {
    $source = &self::$readTplCache["$tpl$suffix"];

    if (!isset($source)) {
      $file = self::FileOf($tpl, $suffix);

      if (is_file($file)) {
        $source = trim(file_get_contents($file), "\r\n");

        if ($source === '') {
          throw new BException("Error reading an $ext template.", $file);
        }
      }
    }

    return $source;
  }

    static function ReadAndFormat($tpl, $suffix, array $vars) {
      $str = self::Read($tpl, $suffix);
      if ($str !== null) {
        BEvent::Fire('template: prepare template', array(&$str, &$tpl, &$suffix, &$vars));
        return self::FormatStr($str, $vars, strrchr($suffix, '.'));
      }
    }

      static function FormatStr($str, array $vars, $format) {
        foreach ($vars as $key => $value) {
          if (!is_string($value) and $key[0] !== '_') {   // 'F!var', 'I!var' - array variables.
            $type = array_shift($value);

            if ($type === 'I') {
              $file = array_shift($value);
              $tpl = self::Read($file, $format);

              $includedTplVars = $value + $vars;
              unset($includedTplVars[$key]);

              if ($tpl === null) {
                $value = self::Format($file, $includedTplVars);
              } else {
                $value = self::FormatStr($tpl, $includedTplVars, $format);
              }
            }

            if (is_array($value)) {
              if (isset($value[$format])) {
                $value = &$value[$format];
              } elseif ($wiki = &$value['.wiki']) {
                $value = BUverseWiki::ToHTML($wiki);
                $format === '.txt' and $value = strip_tags($value);   // todo: no plain text rendering yet.
              } elseif ($format === '.html') {
                $value = isset($value['.txt']) ? $value['.txt'] : array_shift($value);
                $value = htmlspecialchars8($value);
              } elseif (isset($value['.txt'])) {
                $value = $value['.txt'];
              } else {
                $value = isset($value['.html']) ? strip_tags($value['.html']) : array_shift($value);
              }
            }
          }

          isset($$key) or (is_string($value) and $$key = $value);
        }

        return eval('return "'.addcslashes($str, '\\\"').'";');
      }

      static function ProcessDirectives(&$str, &$tpl, &$suffix, array &$vars) {
        if (mb_strpos($str, '{?') !== false) {
          if (isset(self::$directiveCbVars)) {
            throw new BException('Non-empty self::$directiveCbVars when calling ProcessDirectives().');
          }

          self::$directiveCbVars = $vars;

            $regexp = '~\{\?(!?)(\$\w*(?: +\$\w+)*)\s(.+?)\s(\$?\?})~us';
            $str = preg_replace_callback($regexp, array(__CLASS__, 'DirectiveCallback'), $str);

          self::$directiveCbVars = null;
        }
      }

        static function DirectiveCallback($match) {
          $isNot = $match[1] === '!';

          $var = strtok($match[2], ' ');

            if ($var === '$') {
              $prefix = strtok(' '.$match[3], '$');
              if ($prefix !== false and ($prefix = strtok(' ')) !== false) {
                $suffix = ltrim($prefix, 'a..zA..Z0..9_');
                $prefix = substr($prefix, 0, strlen($prefix) - strlen($suffix));

                if ($prefix !== '') {
                  $var = $prefix;
                  self::$lastDirectiveVars = $var;
                }
              }

              strtok(null);
            } else {
              self::$lastDirectiveVars = $match[2];
            }

            if ($var === '$') {
              if (self::$lastDirectiveVars) {
                $var = strtok(self::$lastDirectiveVars, ' ');
              } else {
                throw new BException('Error finding variable name for shortcut template'.
                                     ' directive ({?$...'.$match[4].').', $match[0]);
              }
            }

          do {
            $value = &self::$directiveCbVars[ trim($var, '$?') ];
            $isEmpty = is_array($value) ? empty($value) : ( ltrim((string) $value) === '' );

            if ($isNot ^ $isEmpty) { return ''; }
          } while (($var = strtok(' ')) !== false);

          return $match[3];
        }

  static function ReadPHP($basename, array $vars, array &$result) {
    $file = self::NormalizePHP($basename);
    $file === null or self::ReadPhpFile($file, $vars, $result);
  }

    static function NormalizePHP($basename) {
      $origTpl = $file = self::FileOf($basename, '.php');

      if (is_file($file)) {
        if (!ini_get('short_open_tag')) {
          $file = BConfig::FileOf('cache', "templates/$basename.php");

          if (!is_file($file) or filemtime($file) < filemtime($origTpl)) {
            $tplStr = self::Read($basename, '.php');
            $tplStr = preg_replace_callback('~<\?((?:php|=)?)~u', array(__CLASS__, 'NormPhpCallback'), $tplStr);

            MkDirOf($file);
            if (!file_put_contents($file, $tplStr)) {
              throw new BException('Cannot write normalized .php template.', $file);
            }
          }
        }

        return $file;
      }
    }

      static function NormPhpCallback($match) {
        return '<?php '.($match[1] === '=' ? 'echo ' : '');
      }

    static function ReadPhpFile($_file, array $_vars, array &$TPL) {
      extract($_vars, EXTR_SKIP);

      $_oblevel = ob_get_level();

      ob_start();
      include($_file);

      while (ob_get_level() > $_oblevel) { ob_end_clean(); }
    }

  static function LiteFormat($str, array $vars = array(), $isText = true) {
    BEvent::Fire('template: prepare vars', array(null, &$vars));

    return self::FormatStr($str, $vars, $isText ? '.txt' : '.html');
  }

  static function &Format($tpl, array $vars) {
    BEvent::Fire('template: prepare vars', array($tpl, &$vars));

    $res = BEvent::FireResult('array', 'template: format', array(&$tpl, &$vars));
    if (!$res) {
      throw new BException('Cannot format template.', "tpl: $tpl; vars: ".var_export($vars, true));
    }

    return $res;
  }

    static function AddCommonVars($tpl, array &$vars) {
      foreach (BConfig::$defProps as $name => $default) {
        if ($default === '') {
          $key = $name;

            if ($key[0] !== 's' or substr($key, 0, 4) !== 'site') {
              $key = 'site'.ucfirst($key);

              substr($key, 4, 4) === 'Logo' and $key = "U!$key";
            }

          $vars[$key] = BConfig::$$name;
        }
      }
    }

    static function PrepareVars($tpl, array &$vars) {
      $prepared = array();

        foreach ($vars as $key => &$var) {
          if (is_int($key) or "$key" === '' or $key[0] === '!') {
            continue;
          }

          if (isset($key[1]) and $key[1] === '!') {
            $isTime = $key[0] === 'T';
            $isURL = $key[0] === 'U';

            $bypassArray = (($key[0] === 'F' and is_array($var)) or $key[0] === 'I') ? $key[0] : false;
            $bypassArray and $var = (array) $var;

            $key = substr($key, 2);
          } else {
            $pf4 = substr($key, -4);

            $isTime = $pf4 === 'Time';
            $isURL = (substr($key, -3) === 'URL' or $pf4 === 'Home' or substr($key, -5) === 'Image');
            $bypassArray = false;
          }

          if (isset($prepared[$key]) and !$bypassArray and is_array($prepared[$key])) {
            continue;
          }

          $prepared['_'.$key] = $var;

            if ($bypassArray) {
              array_unshift($var, $bypassArray);
            } else {
              if (is_array($var)) {
                $joiner = &BConfig::$strings[$tpl.' template: joiner: '.$key];
                isset($joiner) or $joiner = &BConfig::$strings['template: joiner: '.$key];
                isset($joiner) or $joiner = &BConfig::$strings['template: joiner'];
                isset($joiner) or $joiner = ', ';

                $var = join($joiner, $var);
              } elseif (is_bool($var)) {
                $str = &BConfig::$strings[ $tpl.' template: bool '.((int) $var) ];
                isset($str) or $str = &BConfig::$strings[ 'template: bool '.((int) $var) ];
                isset($str) or $str = ((int) $var);

                $var = $str;
              } elseif ($isTime) {
                $fmt = &BConfig::$strings[ $tpl.' template: time '.$var ];
                isset($fmt) or $fmt = &BConfig::$strings[ 'template: time '.$var ];
                isset($fmt) or $fmt = 'd##my h##m';

                $var = DateFmt::Format($fmt, $var);
              } elseif ($isURL) {
                "$var" === '' or $var = ToAbsoluteURL($var);
              }

              $var = (string) $var;
            }

          $prepared[$key] = $var;
        }

      $vars = $prepared;
    }

    static function FormatTXT(array &$res, &$tpl, array &$vars) {
      isset($res['text']) or $res['text'] = self::ReadAndFormat($tpl, '.txt', $vars);
    }

    static function FormatHTML(array &$res, &$tpl, array &$vars) {
      if (!isset($res['html'])) {
        $htmlVars = $vars;
        foreach ($htmlVars as &$var) { is_string($var) and $var = htmlspecialchars8($var); }

        $res['html'] = self::ReadAndFormat($tpl, '.html', $htmlVars);
      }
    }

    static function FormatWiki(array &$res, &$tpl, array &$vars) {
      isset($res['html']) or $res['html'] = self::WikiTo('html', $tpl, $vars);

      // todo: plain text rendering isn't implemented in UWiki yet:
      //isset($res['text']) or $res['text'] = self::WikiTo('text', $tpl);
      isset($res['text']) or $res['text'] = strip_tags( self::WikiTo('html', $tpl, $vars) );
    }

      static function WikiTo($format, $tpl, array &$vars) {
        $source = self::ReadAndFormat($tpl, '.wiki', $vars);
        if ($source !== null) {
          return BUverseWiki::Format($source)->RenderIn($format);
        }
      }

    static function FormatPHP(array &$res, &$tpl, array $vars) {
      self::ReadPHP($tpl, $vars + array('_tpl' => $tpl), $res);
    }

  static function &FormatWrapping($tpl, array $vars) {
    $fmt = self::Format($tpl, $vars);
    self::Wrap($fmt, $tpl, $vars);
    return $fmt;
  }

    static function Wrap(array &$formattedTpl, $tpl) {
      static $extToFormat = array('html' => 'html', 'txt' => 'text');

      $wrappers = self::AttachableFiles($tpl, true);
      foreach ($wrappers as $name => $file) {
        $format = $extToFormat[ strtok($name, '.') ];
        if (isset($formattedTpl[$format])) {
          $str = file_get_contents($file);
          if ("$str" === '') {
            throw new BException("Error reading an $ext template wrapper.", $file);
          }

          $formattedTpl[$format] = str_replace('$body', $formattedTpl[$format], $str, $count);
          if ($count < 1) {
            throw new BException('Template wrapped contains no "$body".', "template: $tpl; wrapper: $str");
          }
        }
      }
    }

  static function AttachmentsOf($tpl) {
    $files = self::AttachableFiles($tpl);

      foreach ($files as $name => &$file) {
        $isRelated = $name[0] !== '!';
        $isRelated or $name = substr($name, 1);
        $file = array('data' => file_get_contents($file)) + compact('isRelated', 'name');
      }

    return $files;
  }

    static function &AttachableFiles($prefix, $onlyTPL = false) {
      static $all = array();

      if (!isset( $all[$onlyTPL] )) {
        $path = BConfig::FileOf('config', 'templates').'/';
        $files = scandir($path);

        foreach ($files as $file) {
          if ($file[0] !== '.' and is_file($path.$file)) {
            $ext = strrchr($file, '.');

            if ($onlyTPL ? ($ext === '.tpl')
                         : (!isset(self::$tplExts[$ext]) and $ext !== '.tpl')) {
              $all[$onlyTPL][ BConfig::ToUTF8('file name', $file) ] = $path.$file;
            }
          }
        }
      }

      $prefixes = array('' => true);
      $pf = strtok($prefix, ' ');

        while (true) {
          $prefixes[$pf] = true;

          $new = strtok(' ');
          if ($new === false) { break; }

          $pf .= " $new";
        }

      $res = $scope = array();

        foreach ($all[$onlyTPL] as $name => $file) {
          $tail = strrchr($name, ' ');

          if ($tail === false) {
            $tail = $name;
            $pf = '';
          } else {
            $pf = strtok(substr($name, 0, -1 * strlen($tail)), '.');
            $tail = ltrim($tail);
          }

          if (isset($prefixes[$pf]) and ( !isset($res[$tail]) or $scope[$tail] < strlen($pf) )) {
            $res[$tail] = $file;
            $scope[$tail] = strlen($pf);
          }
        }

      return $res;
    }

}
