<?php
// title used in referring URLs, e.g. /my-post => post file name.
class UrltitlesFileIndex extends BaseHashFileIndex {
  public $indexName = 'URL-titles';

  function Add($post, $link) {
    // dots are used in .htaccess - requests containing them won't be redirected.
    $link = ltrim(strtr($link, '.', '_'), '=@_');

    $index = &self::Load($this->indexName);
    $index[$link] = $post;
    $this->Modified();
  }

  function Remove($post) {
    $index = &self::Load($this->indexName);
    foreach ($index as $link => $memberPost) {
      if ($memberPost === $post) {
        $index[$link] = null;  // unset() will cause foreach() to start iterating again.
        $this->Modified();
      }
    }
  }

  function PostAdded($post, &$doc) {
    $links = (array) $doc['links'];
    $links[] = $doc['textTitle'];
    foreach ($links as $link) { $this->Add($post, mb_strtolower($link)); }

    $this->Add($post, $doc['permalink']);   // don't lower-case it - link tail is case-sensitive.
  }

  function PostMoved($oldPost, $newName, &$doc) {
    $index = &self::Load($this->indexName);
    foreach ($index as $title => $post) {
      $post === $oldPost and $index[$title] = $newName;
    }
    
    $this->Modified();
  }
}
