<?php
spl_autoload_register('AutoloadBlogClasses');
set_error_handler('ThrowPhpError', E_USER_ERROR | E_RECOVERABLE_ERROR);
register_shutdown_function('ThrowSeverePhpError');

  function AutoloadBlogClasses($class) {
    if (strpbrk($class, './\\') === false) {
      $real = realpath( dirname(__FILE__)."/autoload/$class.php" );
      $real or $real = realpath( BConfig::$paths['plugins']."$class.php" );

      if ($real) {
        require_once $real;
      } else {
        BEvent::Fire('autoload', array(&$class));
      }
    }
  }

  function ThrowPhpError($severity, $message, $file, $line) {
    throw new BPhpError($severity, $message, $file, $line);
  }

  // as suggested by periklis in PHP doc's comments: http://www.php.net/manual/en/function.set-error-handler.php#99193
  function ThrowSeverePhpError() {
    $error = error_get_last();
    $ignore = E_WARNING | E_NOTICE | E_USER_WARNING | E_USER_NOTICE | E_STRICT | E_DEPRECATED | E_USER_DEPRECATED;
    if (($error['type'] & $ignore) == 0) {
      $ex = new BSeverePhpError($error['type'], $error['message'], $error['file'], $error['line']);
      BEvent::Fire('on exception', array($ex));
    }
  }

class BException extends Exception {
  public $message, $details;

  function __construct($message, $details = '', $previous = null) {
    parent::__construct($message, 0, $previous);

    $this->message = $message;
    $this->details = $details;
  }

  function __toString() { return '['.get_class($this).'] '.$this->message; }
}

  class BPhpError extends BException {
    public $msg = 'PHP error';

    function __construct($severity, $message, $file, $line) {
      parent::__construct($this->msg, "level: $severity in $file on line $line, message: $message");
    }
  }

    class BSeverePhpError extends BPhpError {
      public $msg = 'Severe PHP error';
    }

$coreClassDir = dirname(__FILE__).'/';

  require_once $coreClassDir.'utils.php';
  require_once $coreClassDir.'event.php';
  require_once $coreClassDir.'config.php';
  require_once $coreClassDir.'tplvars.php';
  require_once $coreClassDir.'index.php';
