<?php
/*
  This formatter will colorize the text inside it. You can use formatting - the default
  markup is 'wacko' (or whatever is assigned to "color_Root" in style_aliases.conf).
  You can use chaining like %%(color, pre) to render source in different formats.

    %%(color red) outputs in red%%        - valid color names as those of CSS
                                            (http://www.w3schools.com/css/css_colors.asp)
    %%(color #FFF) in white%%             - short RGB notation (1 char per color) is allowed
    %%(color #CffcFE) full RGB%%          - character case is ignored
    %%(color $00FFFF) Pascal notation%%   - octets are reversed, the same as #FFFF00
    %%(color) nothing changes%%
*/

class Ucolor_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;
  public $htmlTag = 'span';
  public $htmlClasses = array('color');
  public $parameterOrder = array('color');

  function Parse() {
    if ($format = $this->settings->format) {
      if ($this->settings->format->blockExpected) {
        $this->isBlock = true;
        $this->htmlTag = 'div';
      }

      $this->SetColor( $format->current['params']['color'] );

      $format->root = $this;
      $format->IsEmpty() and $format->AddFormat( $this->DefaultStyle() );
    } elseif ($doc = UWikiDocument::TryParsing($this->raw, $this->settings, $this->DefaultStyle())) {
      $this->children[] = $doc->root;
    } else {
      $pre = $this->NewElement("Upre_Root");
      $pre->SetRaw($this->raw);
      $pre->source = &$pre->originalRaw;
      $this->children[] = $pre;
    }
  }

    function SetColor(&$color) {
      $color = trim($color);
      if (!$color) {
        $this->htmlTag = null;
      } else {
        if ($color[0] === '$' and strlen($color) === 7) {
          $color = '#'.substr($color, 5, 2).substr($color, 3, 2).substr($color, 1, 2);
        }

        if ($color[0] === '#') {
          if ((strlen($color) === 4 or strlen($color) === 7) and
              trim(substr($color, 1), 'a..fA..F0..9') === '') {
            $isValid = true;
            $color = strtoupper($color);
          }
        } elseif (trim($color, 'a..zA..Z0..9') === '') {
          $isValid = true;
        }

        if (isset($isValid)) {
          $this->htmlAttributes = array('style' => 'color: '.$color);
        } else {
          $error = $this->children[] = $this->NewElement('Ucolor_WrongColor');
          $error->format = array($color);
        }
      }
    }

  // todo: this method is 90% identical to Uinclude_Root's. Make dealing with expected inline ormatters automatic?
  function AllToHTML() {
    $result = $this->anchor ? $this->anchor->AllToHTML() : '';

    // we'll have 2 children on wrong heading structure: 1st - message,
    // 2nd - included doc's root. We only need the first child whatever it is.
    $root = $this->children[0];
    $endRendering = $root->doc !== $this->doc;
    $endRendering and $root->doc->BeginRenderingInto('html');

      if ($this->isBlock or $root instanceof UWikiFormatErrorMessage) {
        $result .= $root->AllToHTML();
      } elseif ($root->isBlock) {
        $parent = $root->FindInline();
        if ($parent === false) {
          $result .= $this->NewElement('Ucolor_OnlyBlockChildren')->AllToHTML();
        } elseif ($parent !== null) {
          $result .= $parent->ChildrenToHTML();
        }
      } else {
        $result .= $root->AllToHTML();
      }

    $endRendering and $root->doc->EndRenderingInto('html', $result);
    return $this->SelfToHtmlWith($result);
  }
}

  class Ucolor_WrongColor extends UWikiFormatErrorMessage {
    public $message = '{{color: wrong color';
    public $defaultMessage = 'Wrong color value ("%s") for {{Color}}: if it starts with "#" it can be either short (#FFF) or full (#FFFFFF) RGB value, otherwise it must be a color name containing just letters and digits (like "white"). It can also start with "$" to indicate reverted Pascal-style color value';
  }

  class Ucolor_OnlyBlockChildren extends UWikiFormatErrorMessage {
    public $message = '{{color: only blocks present';
    public $defaultMessage = 'Cannot inline {{Color}}\'s contents because it only has block elements.';
  }
