<?php

abstract class UWikiFormattedText extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;

  public $skipReplaceObjRegExps = array();   // 'regexp' => true, 'regexp' => true, ...
  public $skipReplaceObjClasses = array();   // 'className' => true, ...
  public $pieces;

  function SerializeTo(UWikiSerializer $ser) {
    parent::SerializeTo($ser);
    $ser->WriteArrayUsing(array($ser, 'WriteSupportedType'), $this->pieces);
  }

    function UnserializeFrom(UWikiUnserializer $ser) {
      parent::UnserializeFrom($ser);
      $this->pieces = $ser->ReadArrayUsing( array($ser, 'ReadSupportedType') );
    }

  function SetSettingsFrom(&$raw) {
    $allPieces = array($raw);
    $this->pieces = &$allPieces;

      if ($this->settings->fastTextFormatting) { return; }

    // 'regexp' => array(array('class', arg...), ...)  or  array('class', arg...)
    // in case of 1st variant objects are chosen based on the index of first non-empty
    // pochet excluding #0th (whole match) and #st (for '((a|c)|(d|e))' form).
    foreach ($this->settings->TextReplacements() as $regexp => $classes) {
      if (!empty( $this->skipReplaceObjRegExps[$regexp] )) { continue; }

      for ($pieceIndex = 0; isset( $allPieces[$pieceIndex] ); ++$pieceIndex) {
        $piece = &$allPieces[$pieceIndex];
        if (is_object($piece) or trim($piece) === '') { continue; }

        if (!preg_match_all($regexp, $piece, $matches, PREG_OFFSET_CAPTURE | PREG_SET_ORDER)) {
          EUWikiLastPCRE::ThrowIfPcreFailed();
        } else {
          $prevPos = 0;
          $pieces = array();

          foreach ($matches as &$match) {
              list($fullMatch, $pos) = $match[0];

            $pos > $prevPos and $pieces[] = substr($piece, $prevPos, $pos - $prevPos);
            $prevPos = $pos + strlen($fullMatch);

            if (is_array($classes[0])) {    // array of arrays of classes.
              $classIndex = 1;
              while ($match[++$classIndex][1] === -1) { }

                if (!isset($match[$classIndex])) {
                  throw new EUverseWiki('UWikiFormattedText could not determine class index.');
                }

              $args = $classes[$classIndex - 2];
            } else {
              $args = $classes;
            }

            $class = array_shift($args);
            if (!empty( $this->skipReplaceObjClasses[$class] )) { break; }

            $obj = $pieces[] = $this->NewElement($class);

              if (! $obj instanceof UWikiBaseReplacement) {
                throw new EUverseWiki(__CLASS__.": piece object of class $class isn't".
                                      ' an UWikiBaseReplacement.');
              }

            $obj->regexp = $regexp;
            $obj->matches = &$match;
            $obj->args = $args;
            $obj->SetRaw($match[0][0]);
            $obj->Prepare();
          }

          if (!empty( $this->skipReplaceObjClasses[$class] )) { continue; }

          isset( $piece[$prevPos] ) and $pieces[] = substr($piece, $prevPos);

          array_splice($allPieces, $pieceIndex, 1, $pieces);
          $pieceIndex += count($pieces) - 1;
        }
      }
    }
  }

  function SelfToHtmlWith($contents) {
    $contents = '';

    if ($this->pieces) {
      foreach ($this->pieces as $piece) {
        if (is_object($piece)) {
          $contents .= $piece->AllToHTML();
        } else {
          $html = self::QuoteHTML($piece);
          $contents .= $html;
        }
      }
    }

    return parent::SelfToHtmlWith($contents);
  }
}

abstract class UWikiBaseReplacement extends UWikiBaseElement {
  public $matches, $args;

  function SerializeTo(UWikiSerializer $ser) {
    parent::SerializeTo($ser);

    $toPack = array('vl*', count($this->matches));
    $tail = '';

      foreach ($this->matches as &$match) {
        $toPack[] = strlen($match[0]);
        $tail .= $match[0];

        $toPack[] = $match[1];
      }

    $buf = call_user_func_array('pack', $toPack).$tail;
    $count = fwrite($ser->handle, $buf, strlen($buf));
    isset($buf[$count + 1]) and $ser->WriteError($count, strlen($buf));

    $ser->WriteHashUsing(array($ser, 'WriteSupportedType'), $this->args);
  }

    function UnserializeFrom(UWikiUnserializer $ser) {
      parent::UnserializeFrom($ser);

      $this->matches = array();
      $count = unpack('v', fread($ser->handle, 2));

        if ($count[1]) {
          // *4 = size of 'l', *2 = one for match string length, another - for its offset.
          $counts = unpack('l*', fread($ser->handle, $count[1] * 4 * 2));
          if (!isset( $counts[$count[1]] )) {
            $ser->PrematureEOF($count[1] * 4 * 2, count($counts) * 4 * 2);
          }

          for ($i = 1; isset($counts[$i]); $i += 2) {
            if ($length = $counts[$i]) {
              if ($length > UWikiUnserializer::MaxStringLength) {
                $ser->TooLarge($length, UWikiUnserializer::MaxStringLength);
              }

              $str = fread($ser->handle, $length);
              if ($str === false or !isset($str[$length - 1])) {
                $ser->PrematureEOF($length, strlen($str));
              }
            } else {
              $str = '';
            }

            $this->matches[] = array($str, $counts[$i + 1]);
          }
        }

      $this->args = $ser->ReadHashUsing( array($ser, 'ReadSupportedType') );
    }

  function Prepare() {
    $obj->skipReplaceObjClasses[$this->className] = true;
  }
}


/* Classes for formatted text replacements: */

class UWikiReplacedTerm extends UWikiBaseReplacement {
  function SelfToHtmlWith($contents) {
    $meaning = $this->args[0];

    if ($meaning instanceof UWikiBaseElement) {
      $html = $meaning->AllToHTML();
    } else {
      $meaning = self::QuoteHTML($meaning, ENT_COMPAT);
      $html = "<abbr title=\"$meaning\">{$this->matches[1][0]}</abbr>";
    }

    return parent::SelfToHtmlWith($html);
  }
}

class UWikiReplacedNoWrap extends UWikiBaseReplacement {
  public $htmlTag = 'span';

  function Prepare() {
    parent::Prepare();

    $obj = $this->children[] = $this->NewElement('UWikiTextFromRaw');
    $obj->skipReplaceObjClasses[__CLASS__] = true;

    $punct = array_pop($this->matches);
    $obj->SetRaw($this->matches[1][0].$punct[0]);
    $obj->Parse();
  }

  function SelfHtmlAttributes() { return array('class' => 'nowrap'); }
}

class UWikiReplacement extends UWikiBaseReplacement {
  function SelfToHtmlWith($contents) {
    $substr = $this->matches[1][0];
    $item = &$this->args;

    if ($item['image'] === '' or $item['image'] === '-') {
      $html = $item['text'];
    } else {
      $src = $this->settings->smileyURL.$item['image'];
      $alt = self::QuoteHTML($item['text'] === '' ? $substr : $item['text'], ENT_COMPAT);
      $html = "<img src=\"$src\" title=\"$alt\" alt=\"$alt\" />";
    }

    return parent::SelfToHtmlWith($html);
  }
}
