<?php
  isset($markup) or $markup = 'wacko';
  if (!isset($tests)) {
    $tests = array();
      foreach (glob('tests/*.txt') as $file) {
        @list($singleline, $multiline) = preg_split("/(^|(\r?\n)+)\s*Multiline\s+tests[:]?\s*(\r?\n)+/iu",
                                         trim( file_get_contents($file) ), 2);

        $tests = array_merge( $tests, explode("\n", $singleline), explode("\n\n", $multiline) );
      }
  }
  $resultShortHands = array('&q;' => '"', '&b;' => '<br />');

    $cases = array();

      foreach ($tests as $line) {
        // we don't remove spaces, they can be used to test indentation and such.
        if ($line = trim($line, "\r\n")) {
          $line = preg_split('/(=>|;;)/', $line, 3);
            foreach ($line as &$part) { $part = stripcslashes( trim($part, "\r\n") ); }

          @list($test, $result, $comment) = $line;

            $result = strtr(trim($result), $resultShortHands);

          $cases[] = compact('test', 'result', 'comment');
        }
      }

  if (!$cases) { return; }
  $allOK = RunTestsFor($markup, $cases);

  if ($allOK) {
    echo '<em style="color: green"><strong>All OK</strong> ('.count($cases).' tests ran).</em>';
  } else { ?>
    <input type="checkbox" id="testrunnerhover" checked="checked" />
    <label for="testrunnerhover">Hover shows <kbd>must</kbd>.</label>

    <ul>
      <?php
        $id = 0;
        foreach ($cases as $case) {
          ++$id;
          if (!empty( $case['failed'] )) { ?>
            <li onmousemove="if (document.getElementById('testrunnerhover').checked) { document.getElementById('testfail_<?php echo $id?>').style.display = 'block'; }"
                onmouseout="document.getElementById('testfail_<?php echo $id?>').style.display = 'none';">
              <kbd><?php echo htmlspecialchars($case['test'])?></kbd>:
              <span style="color: maroon">Failed</span>
              <pre id="testfail_<?php echo $id?>" style="position: absolute; display: none; background: #EEE; margin: 0"
                > <u>must</u>: <?php echo htmlspecialchars( $case['result'] )?>
              </pre>
              <pre style="margin: 0"> got:  <?php echo Diff($case['testResult'], $case['result'])?> </pre>
            </li>
       <?php
          }
        }
      ?>
    </ul>
<?php
  }

  return $allOK;

    function RunTestsFor($markup, &$tests) {
      $breakOnFirstFail = 1;  // 1 or 0.

      $allOK = true;
      $settingsObj = new UWikiSettings;
      $settingsObj->pager = new UWikiFilePager( dirname(__FILE__) );
      $settingsObj->LoadFrom('config');
      $settingsObj->linkExt = '';
      $settingsObj->rootURL = '';
      $settingsObj->dubiousAsComments = false;
      $settingsObj->noLineBreaksInsideParagraph = true;
      $settingsObj->fetchRemoteTitles = false;
      $settingsObj->autoAnchorContractions['wacko_Paragraph'] = 'p';

        require_once 'uversewiki.php';

      foreach (glob('tests/*.php') as $testFile) {
        $scriptSettings = $settingsObj->FullClone();
        $scriptSettings->rootURL = '/root/';
        $scriptSettings->BaseURL('base');

        $error = RunTestScript($testFile, $scriptSettings);
        if ($error) {
          $tests[] = array('failed' => true, 'testResult' => $error['got'], 'result' => $error['must'],
                           'test' => basename($testFile), 'script' => $testFile);
          $allOK = false;
          if ($breakOnFirstFail) { break; }
        }
      }

      if ($breakOnFirstFail and !$allOK) { return $allOK; }

        $preserveTypographics = $keepListValues = $keepAnchors =
        $keepAutoAnchors = $keepMissingAnchorClass = $keepSoftBreaks = false;
        $settings = $strings = array();
      foreach ($tests as &$case) {
        if (!empty($case['script'])) { continue; }

          $test = $case['test'];
          $varName = substr(strtok($test, ' '), 1);

        if ($test[0] === '$' and isset($$varName)) {
          $$varName = substr($test, -2) === 'on';
        } elseif (strpos($test, 'setting ') === 0) {
          list(, $name, $value) = explode(' ', $test, 3);
          if ($value === '-') {
            unset( $settings[$name] );
          } else {
            $settings[$name] = ($value === 'true' ? true : ($value === 'false' ? false : $value));
          }
        } elseif (strpos($test, 'string ') === 0) {
          list($name, $value) = explode('=', $test, 2);
          $name = stripcslashes( trim(substr($name, 7)) );
          $value = stripcslashes(trim($value));

          if ($value === '-') {
            unset($strings[$name]);
          } else {
            $strings[$name] = $value;
          }
        } else {
            $doc = new UWikiDocument($test);
            $doc->settings = $settingsObj->FullClone();

            $doc->LoadMarkup($markup);
            $doc->settings->strings = $strings + $doc->settings->strings;

            $doc->settings->noLineBreaksInsideParagraph = false;

            $doc->settings->interwiki['int-raw'] = array('target' => '/int/{PATH}', 'root' => '');
            $doc->settings->interwiki['int-enc'] = array('target' => '/int/', 'root' => '/int-enc-root/');
            $doc->settings->numberlinks['num'] = array('target' => 'http://num/path/file', 'root' => '');

            $doc->settings->interwiki['both'] = array('target' => '/both/num/', 'root' => '/both-root');
            // root URL is always read from interwiki since it's impossible to refer to it via
            // a numberlink like ((num:#)) - trailing "#" with no chars following is considered
            // an anchor and is removed, supplying any chars will turn ((num:#)) into a target URL.
            $doc->settings->numberlinks['both'] = array('target' => '/both/num/', 'root' => '');

              foreach ($settings as $name => $value) {
                if ($name === 'baseURL') {
                  $doc->settings->BaseURL($value);
                } else {
                  $doc->settings->$name = $value;
                }
              }

          try {
            $doc->Parse();
          } catch (Exception $e) {
            HandleTestException($e, $case);
          }

          $got = $doc->ToHTML();

            $got = strtr($got, array('<p class="default">' => '<p>', '"round-brackets ' => '"',
                                    'missing-page ' => '', ' missing-page"' => '"',
                                    "\n<span class=\"forced-break\"></span>" => ''));
            $keepSoftBreaks or $got = strtr($got, array('<span class="soft-break"></span>' => ''));
            $got = preg_replace("~(<a [^>]+)\s+title=\"[^\"]+\"([^>]*>¶</a>)~u", '\1\2', $got);
            if (!$keepMissingAnchorClass) {
              $got = strtr($got, array('internal missing-anchor' => 'internal'));
            }
            $keepAutoAnchors or $got = preg_replace("~<a name=\"(wacko|p)_[^>]+>¶</a>~iu", '', $got);
            $keepAnchors or $got = preg_replace("~<a name=[^>]+>¶</a>~iu", '', $got);
            $got = preg_replace("~(<a [^>]+)\s+title=\"[^\"]+\"([^>]*>)~u", '\1\2', $got);
            $got = preg_replace("~^<p( style=\"text-align: left\")?( class=\"default\")?>\n(.*)\n</p>\s*$~siu", '\\3', $got);
            $got = preg_replace("~(<a)( href=\".*?\")? class=\"internal\"( href=\".*?\")?~iu", '\\1\\2\\3', $got);
            $got = preg_replace('~<span class="format-name">[^>]+</span>~u', '', $got);
            $got = preg_replace('~<li( value="[^"]+")? class="([a-z-]+)"~u', '<li style="list-style-type: \2"\1', $got);
            $keepListValues or $got = preg_replace("~(<li[^>]*) value=\"[^\"]+\"~iu", '\1', $got);
            $got = preg_replace("/< ([uod]l|d[td]|li) [^>]*>/xu", "\\0\n", $got);
            $got = preg_replace("/<\/ ([uod]l|d[td]|li) >/xu", "\n\\0\n", $got);
            $got = preg_replace('~(<blockquote class="inline">)\s*<ol>(.*?)\s*</ol>(\s*</blockquote>)~su', '\1\2\3', $got);
              $got = preg_replace('~<li( class="level-\d">)\s*<cite>(.*)</cite>\s*</li>~u', '<cite\1\2</cite>', $got);
            $got = preg_replace("/\n\n+/u", "\n", $got);
            $preserveTypographics or $got = preg_replace('/<span class="nowrap">(.+?)<\/span>/u', '\1', $got);
            $got = preg_replace('~<a class="image(-box)?" href="[^"]+">(\s*<img[^>]+/>\s*)</a>~iu', '\2', $got);

          $got = trim( rtrim($got), "\r\n");  // only rtrim() because there might be some indentation.

          $ok = $got === $case['result'];

            $case['failed'] = !$ok;
            $case['testResult'] = $got;
            $allOK &= $ok;

          if (!$ok and $breakOnFirstFail and ++$breakOnFirstFail > 5) { break; }
        }
      }

      return $allOK;
    }

      function RunTestScript($_file, &$settings) {
        try {
          return ! include($_file);
        } catch (Exception $e) {
          if (strpos($e->getMessage(), 'TestEquality') === false) {
            return array('must' => '', 'got' => $e->getMessage());
          } else {
            return array('must' => $e->args[0], 'got' => $e->args[1]);
          }
        }
      }

        function TestThat($mustBeTrue) { if (!$mustBeTrue) { throw new Exception('Assertion failed.'); } }

        function TestEquality($got, $expected) {
          if ($expected !== $got) {
            $e = new Exception('TestEquality() failed.');
            $e->args = array($expected, $got);
            throw $e;
          }
        }

      function HandleTestException($e, $test) {
        echo '<h1>Exception <kbd>'.get_class($e).'</kbd> occurred while running a test</h1>'.
             '<pre>'.htmlspecialchars($e->getMessage()).'</pre> <h2>Test data</h2>';
        var_dump($test);
        exit(1);
      }

  function Diff(&$first, &$second) {
    $result = '';
    $diffCount = 0;

      for ($i = 0; isset( $first[$i] ); ++$i) {
          $char = htmlspecialchars( $first[$i] );

        if (isset( $second[$i] ) and $first[$i] === $second[$i]) {
          $result .= $char;
        } else {
          $result .= '<span style="background: #fee">'.$char;
            if (++$diffCount > 5 or !isset( $second[$i] ) ) {
              $result .= htmlspecialchars( substr($first, $i + 1) );
              $i = 0xFFFF;
            }
          $result .= '</span>';
        }
      }

    return $result;
  }
