<?php
// There was a bug with tree pos collisions that generated anchors only for last list item.

  $src = '
== Заглавие ==
    Абзац 1.
=== Секция ==
Абзац 2.
  1. Пункт 1.
  1. Пункт 2.
  3. Пункт 3.
  Абзац 3.
';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->settings->anchorize['wacko_ListItem'] = true;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<h1>
Заглавие<a name="заглавие" href="#заглавие" title="#заглавие" class="anchor">¶</a>
</h1>
<p class="indent-2 default">
Абзац 1.
<a name="p_1-1" href="#p_1-1" title="#p_1-1" class="anchor">¶</a>
</p>
<h2>
Секция<a name="секция" href="#секция" title="#секция" class="anchor">¶</a>
</h2>
<p class="default">
Абзац 2.
<a name="p_1.1-1" href="#p_1.1-1" title="#p_1.1-1" class="anchor">¶</a>
</p>
<ol><li class="decimal" value="1">Пункт 1.<a name="wacko_listitem_1.1-1" href="#wacko_listitem_1.1-1" title="#wacko_listitem_1.1-1" class="anchor">¶</a></li><li class="decimal">Пункт 2.<a name="wacko_listitem_1.1-2" href="#wacko_listitem_1.1-2" title="#wacko_listitem_1.1-2" class="anchor">¶</a></li><li class="decimal" value="3">Пункт 3.<a name="wacko_listitem_1.1-3" href="#wacko_listitem_1.1-3" title="#wacko_listitem_1.1-3" class="anchor">¶</a></li></ol>
<p class="indent-1 default">
Абзац 3.
<a name="p_1.1-2" href="#p_1.1-2" title="#p_1.1-2" class="anchor">¶</a>
</p>
';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
