<?php
  self::$loadedHandlers[$markup]['block'][] = array(Uwacko_TildeToken, Uwacko_OneTokenEscape, Uwacko_DoesNotDivide | Uwacko_DeleteToken | Uwacko_EscTagAfterSelf);

  self::$loadedHandlers[$markup]['block'][] = array('(?<=\r\n|\n) \s* <\[', 'Uwacko_BlockQuote', Uwacko_StartTag);
  self::$loadedHandlers[$markup]['block'][] = array('\]> (?:\r?\n)+', 'Uwacko_BlockQuote', Uwacko_EndTag);

  self::$loadedHandlers[$markup]['block'][] = array('(?<=\r\n|\n) \s* \#\# (?: \(.+\) )? (?:\r?\n)+', 'Uwacko_Container', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);

abstract class Uwacko_BlockElement extends Uwacko_Tokenizer {
  public $isBlock = true;
  public $handlerGroup = 'block';
  public $defaultTokenClass = 'Uwacko_TextBlock';
}

  class Uwacko_Root extends Uwacko_BlockElement {
    public $isFormatter = true;
    public $isAction = false;
    public $formats, $dynamicFormats;

    function SerializeTo(UWikiSerializer $ser) {
      parent::SerializeTo($ser);

      ksort($this->dynamicFormats);
      $ser->WriteNestedArray($this->dynamicFormats, array('$', 'SerializeTo'));
    }

      function UnserializeFrom(UWikiUnserializer $ser) {
        parent::UnserializeFrom($ser);
        $this->dynamicFormats = $ser->ReadNestedArray(array('UWikiFormat', 'UnserializeFrom'));
      }

    function BeforeParsing() {
      parent::BeforeParsing();

      $this->formats = array();
      $this->dynamicFormats = array();

      if ($this->settings->dubiousAsComments) {
        $handler = array('(?<=\r\n|\n) \s* \?\? (?:\r?\n)+', 'Uwacko_BlockComment',
                         Uwacko_StartTag | Uwacko_EndTag | Uwacko_NoTokensInside);
        $this->settings->handlers->AddTo('block', $handler);
      }

      $anchor = self::PregQuoteX(Uwacko_AnchorChar);
      // no "=" so ((#anchor==)) is treated as ((#anchor==anchor)).
      $charlist = $this->settings->inlineAnchors ? '[^\s=]' : '[^\r\n=]';
      $handler = array('(?<=\r\n|\n) \s* \(\( '.$anchor.$charlist.'+? \)\) (?:\r?\n)+',
                       'Uwacko_Anchor', Uwacko_SingleTag);
      $this->settings->handlers->AddTo('block', $handler);
    }

    function AfterParsing() {
      parent::AfterParsing();

      $this->SortTree();

      // fill it now so we don't need to krsort() it on each change.
      $dynamicFormats = $staticFormats =
        array_combine( range(UWikiMaxPriority, 0), array_fill(0, UWikiMaxPriority + 1, array() ) );

      $initialPriority = 0;
      foreach ($this->formats as $format) {
        $dynamicFormat = $format->SplitDynamic();

        if ($dynamicFormat) { $dynamicFormats[ $dynamicFormat->Priority() ][] = $dynamicFormat; }

        if (!$format->IsEmpty()) {
          $format->userData['dynamicPart'] = &$dynamicFormat;
          $dynamicFormat->raw = &$format->raw;  // so that changes made by formatters will be reflected on static part.

            $priority = $format->Priority();
          $staticFormats[$priority][] = $format;
          $priority > $initialPriority and $initialPriority = $priority;
        }
      }

        $this->dynamicFormats = $dynamicFormats;

      self::RunFormats($staticFormats, null, $initialPriority);

      $this->SortTree();
    }

      function SortTree() {
        foreach ($this->settings->all as &$array) { ksort($array); }
      }

    function BeforeRenderingInto($renderFormat) {
      parent::BeforeRenderingInto($renderFormat);

      self::RunFormats($this->dynamicFormats, $renderFormat);

      if ($this->settings->footnotesAtTheEnd and !$this->settings->format) {
        foreach ($this->settings->all['blockFootnotes'] as $obj) {
          $this->children[] = clone $obj;

          $obj->htmlTag = null;
          $obj->children = array();
        }
      }

      $this->AnchorizeChildren();
    }

      function AnchorizeChildren() {
        $positions = array();

        foreach ($this->settings->anchorize as $elementName => $doAnchorize) {
          $elements = &$this->doc->elements[$elementName];
          if ($doAnchorize and $elements) {
            foreach ($elements as $obj) {
              $pos = $obj->TreePosID();
              // avoid tree pos collisions; we don't need a good-looking name - any
              // different yet close to original value string will suffice.
              while (!empty( $positions[$pos] )) { $pos .= '.'; }
              $positions[$pos] = $obj;
            }
          }
        }

        ksort($positions);
        foreach ($positions as $obj) { $obj->AnchorizeIfNeeds(); }
      }

      static function RunFormats($formats, $renderFormat, $priority = UWikiMaxPriority) {
        do {
          while ($format = array_shift($formats[$priority])) {
            $format->renderingIn = null;
            $format->ApplyOne();

            if ($format->stop) {
              $dynamic = &$format->userData['dynamicPart'];
              $dynamic and $dynamic->Clear();
            } elseif (!$format->IsEmpty()) {
                $newPriority = $format->Priority();
              $formats[$newPriority][] = $format;
              $newPriority > $priority and $priority = $newPriority;
            }
          }
        } while (--$priority >= 0);
      }
  }

  class Uwacko_BlockQuote extends Uwacko_BlockElement {
    public $htmlTag = 'blockquote';
    public $htmlClasses = array('block');

    function SetSettingsFrom(&$raw) { $raw = $this->UnindentBlockIfNeeds($raw); }
  }

  class Uwacko_BlockComment extends Uwacko_BlockElement {
    public $isBlock = true;
    public $removeEscInside = true;
    public $htmlTag = 'div';
    public $htmlClasses = array('comment');

    function SetSettingsFrom(&$raw) {
      $raw = $this->UnindentBlockIfNeeds($raw);
      parent::SetSettingsFrom($raw);
    }

    function SelfToHtmlWith($contents) {
      if ($this->settings->showComments) { return parent::SelfToHtmlWith($contents); }
    }
  }

  class Uwacko_Container extends Uwacko_BlockElement {
    public $htmlTag = 'div';
    public $htmlClasses = array('container');

    public $userStyles = array();
    public $legend;

    static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
      $tempToken = trim($token);
      if ($styles = $doc->style->ExtractMultipleFrom($tempToken, 2)) {
        $flags &= ~Uwacko_EndTag;
        return array($styles);
      } elseif (isset( $tempToken[3] )) {  // %%.<something>
        return Uwacko_SkipThisToken;
      }
    }

    function Parse() {
      parent::Parse();

      $this->callbackResult[0] or $this->Transform();
    }

      function SetSettingsFrom(&$raw) {
        $raw = $this->UnindentBlockIfNeeds($raw);

        $styles = $this->callbackResult[0] ? $this->callbackResult[0] : array(null);
        foreach ($styles as $style) {
          $this->htmlClasses[] = $this->userStyles[] = $this->RealStyleBy($style);
        }
      }

      function Transform() {
        $children = &$this->children;

        if (count($children) == 1 and $children[0] instanceof Uwacko_List) {
          $allAssoc = true;

          foreach ($children[0]->children[0]->children as $item) {
            if ((! $item instanceof Uwacko_ListItem) or $item->markerType !== 'assoc') {
              $allAssoc = false;
              break;
            }
          }

          if ($allAssoc) {
            $children = $this->TransformAssoc($children[0]->children[0]);
            return;
          }
        }
      }

        function TransformAssoc($list) {
          foreach ($list->children as $item) {
            $item->htmlTag = 'tr';
            $item->markerType = null;

            foreach ($item->children as $i => $child) {
              $child->htmlTag = $i > 0 ? 'td' : 'th';
            }
          }

          $list->htmlTag = null;

          $this->htmlTag = 'table';
          $this->htmlClasses[] = 'assoc-table';

          return array($list);
        }

    function AllToHTML() {
      if (!$this->legend) {
        foreach ($this->children as $element) {
          if ($element->kind === 'heading') {
            $element->htmlTag = 'legend';
            $this->legend = $element;
            break;
          }
        }

        $this->legend and $this->htmlTag = 'fieldset';
      }

      return parent::AllToHTML();
    }
  }
