<?php
/*
  This action extends wiki syntax by showing a JavaScript box with color sample when user
  moves mouse over a string like #RRGGBB (case-insensitive). It doesn't require anything
  from source document, simply copy this file to wacko/ directory in the UverseWiki root folder.

  Examples:  #123312  #AFFC34  #cc3fff  - and so on.
*/

UWikiDocument::$loadedHandlers['wacko']['inline'][] = array('(?<='.UWikiLeftWordBoundary.')\#[a-fA-F0-9]{6}(?='.UWikiRightWordBoundary.')', 'Uwacko_RGBox', Uwacko_SingleTag);

class Uwacko_RGBox extends Uwacko_Base {
  public $isFormatter = false;
  public $isAction = false;
  public $htmlTag = 'span';
  public $htmlClasses = array('rgbox');

  static $js;

  function Attachments() { return array('js'  => array('RGBox' => self::$js)); }

  function SelfToHtmlWith($content) { return parent::SelfToHtmlWith($this->startToken); }

    function SelfHtmlAttributes() {
      return array('onmouseover' => 'RGBox(event, this, true);', 'onmouseout' => 'RGBox(event, this, false);');
    }
}

Uwacko_RGBox::$js = <<<JAVASCRIPT
function RGBox_PageYFrom(event) {
  if (event.pageY) {
    return event.pageY;
  } else if (event.clientY) {
     return event.clientY + (document.documentElement.scrollTop ? document.documentElement.scrollTop
                                                                 : document.body.scrollTop);
  } else {
    return 0;
  }
}

function RGBox_PageXFrom(event) {
  if (event.pageX) {
    return event.pageX;
  } else if (event.clientX) {
     return event.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft
                                                                 : document.body.scrollLeft);
  } else {
    return 0;
  }
}

function RGBox(event, elem, show) {
  var box = window.rgbox;

    if (!box) {
      box = document.createElement('div');
      window.rgbox = box;
      document.body.appendChild(box);

      box.id = 'rgbox';
      box.style.width = '75px';
      box.style.height = '25px';
      box.style.position = 'absolute';
      box.style.zIndex = 100;
      box.style.display = 'none';
      box.style.marginTop = '5px';
      box.style.border = '1px outset';
    }

  box.style.backgroundColor = elem.innerHTML;
  box.style.left = RGBox_PageXFrom(event) + 'px';
  box.style.top = RGBox_PageYFrom(event) + 'px';
  box.style.display = show ? 'block' : 'none';
}
JAVASCRIPT;
