<?php
/*
  This action is used in chain - it'll make following actions/formatters operate
  on topmost document rather than on one that has embedded them. What is a "topmost doc"?

    topmost doc.wiki:
      == Topmost title ==
      {{Include embedded}}
    embedded.wiki:
      == Embedded title ==
      {{Include embed more}}
    embed more.wiki:
      == At last... ==
      {{TOC}}

  Here we have 3 documents: //topmost doc <- embedded <- embed more//. We have a sample
  {{TOC}} in most embedded doc. By default it will generate Table of Contents for the
  doc that has included it (embedded.wiki); however, if we rewrite last line as:
    {{TopDoc; TOC}}
  - TOC will operate on topmsot document instead, taking document title from
  "topmost doc.wiki" instead of that of "embedded.wiki".

  This action also supports custom level of going up - specify it as a number after
  TopDoc. Here's an interesting example:

    topmost doc.wiki:
      == Topmost title ==
      {{Include embedded}}
    embedded.wiki:
      == Embedded title ==
    embed more.wiki:
      == At last... ==
      {{TopDoc 1;   Tags for embedded}}
      {{TopDoc;     Tags for topmost}}
      {{TopDoc 999; Tags the same}}

  In the example above "for embedded" tag will be set for "Embedded title" document
  while other two - for "Topmost title".
*/

class Utopdoc_Root extends UWikiBaseAction {
  public $runsImmediately = true;
  public $parameterOrder = array('previous');

  function Execute($format, $params) {
    $prev = &$params['previous'];

      if ($prev) {
        do {
          $format->origDoc = $format->origDoc->settings->format->origDoc;
        } while (--$prev and $format->origDoc->settings->format);
      } Else {
        $format->origDoc = $format->topmostDoc;
      }

    $format->origRoot = $format->origDoc->root;
    $format->settings = &$format->origDoc->settings;
  }

  function IsDynamic($format, $params) { return $format->HasDynamic(); }
}
