<?php

  function_exists('mb_internal_encoding') and mb_internal_encoding('UTF-8');
  error_reporting(E_ALL & ~E_NOTICE);
  require_once 'tasks.php';

  array_shift($argv);  // script's name.
  // for some reason PHP passes -- when invoked by CreateProcess (but not from cmd.exe).
  $argv[0] === '--' and array_shift($argv);

  echo "\n";

  try {
    $cl = new UWikiTask($argv, false);
    $cl->progressCallback = 'ProgressCallback';
    $cl->Run();
  } catch (EUnknownTask $e) {
    $cl = null;
  } catch (OtherTaskError $e) {
    echo $e;
    exit(1);
  }

  if ($cl) {
    if (get_class($cl->task) === 'BuildTask') {
      $totalSrcSize = 0;
      $totalParseTime = 0;
      $files = &$cl->task->builtFileList;

        foreach ($files as $info) {
          $totalSrcSize += $info['srcSize'];
          $totalParseTime += $info['parseTimeMSec'];
        }

      if (!$cl->flags['q']) {
        printf("\nParsed %1.1f KiB in %d wiki files within %d msec (%d msec per 1 KiB).\n\n",
               $totalSrcSize / 1024, count($files), $totalParseTime,
               $totalSrcSize ? $totalParseTime / $totalSrcSize * 1024 : 0);

        $failedCount = 0;

          foreach ($files as $info) {
            if ($error = $info['error']) {
              ++$failedCount;

                if (get_class($error) === 'EUWikiLastPCRE') {
                  $message = 'PCRE call has failed - check if this file is in UTF-8 (see also --in-charset).';
                } else {
                  $message = (string) $error;
                }

              printf("  ! %s - <%s> error:\n    %s\n", $info['src'], get_class($error), $message);
            } else {
              printf("  * %s (%1.1fK) => %s (%1.1fK) | %d msec\n",
                     $info['baseName'], $info['srcSize'] / 1024,
                     $info['dest'], $info['destSize'] / 1024, $info['parseTimeMSec']);
            }
          }

        if ($failedCount) {
          echo "\nAll done, $failedCount files failed to convert.\n";
        } else {
          echo "\nAll files (".count($files).") were converted successfully.\n";
        }
      }
    } elseif (get_class($cl->task) === 'MultiLangBuildTask') {
      echo "\nFinished to build ".count($cl->task->langs)." languages.\n";
    }

    exit(0);
  }

    function ProgressCallback($total, $current, $info, $cl) {
      if (!$cl->flags['q']) {
        if (get_class($cl->task) === 'BuildTask') {
          if (is_array($info)) {
            static $firstTotal;
            $firstTotal or $firstTotal = $total;
            $l = strlen((string) $firstTotal);

            $left = $current === $total ? 'last one' : sprintf('%0'.$l.'d left', $total - $current);
            printf("  (%s) %s...\n", $left, $info['baseName']);
          } else {
            echo "$info...\n";
          }
        } elseif (get_class($cl->task) === 'MultiLangBuildTask') {
          if ($current !== 1) { echo "\n"; }
          printf("  Building pages for %s (%s more to go)\n  => %s\n\n", $info['code'],
                  $current === $total ? 'no' : ($total - $current), $info['path']);
        }
      }
    }

?>
Command-line syntax:
  wackodoc.exe -task [-flags] [--option=value] [--] [<argument_1> [...]]

  Normally, all arguments starting with "-" are considered flags or options but
you can change this using '--' - all arguments after it will be treated as
numerical even if they start with a dash.

  !! Highly recommended to encode files in UTF-8 to avoid PHP glitches !!

Tasks:
  -b         Build HTML from wiki sources. Is default if <arg_1> is a
             directory (useful for drag & drop).
  --list-handlers[]=markup,group
  --list-style-aliases
  --list-replacements[]=html
             Among other things this one lists typographic rules.
  --list-entities
             These tasks can be combined with others.
  --list-handlers[]=group
             Alias for --list-handlers[]=wacko,group

Arguments by task by index:
  -b
    #0       Path to wiki files (source). If prefixed with svn://, http://,
             https:// or file:// will be considered an URL to the SVN repo
             to checkout & build HTML from files changed in last commit when
             running in -u mode described below (see also --svn-command).
    [#1]     Path where to put generated HTML files. Defaults to #0\..\HTML.
             If exists the program will quit unless -q/-y flags were specified.
  -u         Update mode; the same as -b but instead of building each source
             file it's checked for 'updated' state which depends on soucre
             interface (for file system it's file change time, for SVN - if
             it was changed in last commit or not). Only newer files are built.
             Adds several new options, see below. Incompatible with -r (error).
             While -b task errors when there's nothing to build -u doesn't.
             This mode only works with the following interface combinations:
                                 SOURCE   DESTINATION
                                   file   file
                                    SVN   *

Flags:
  -q         Quite mode; implies -y.
  -y         Answer Yes - e.g. ignore warnings, write errors, etc. and proceed.
  -r         Remove destination folder <arg_2> before building (-b). Before
             that it'll be checked if it has any file with --inext to avoid
             accidentally removing the source folder. -y can be used to disable
             this check and always remove.

Options:
  --markup=wacko
             Markup of source files.
  --inext=wiki
             Extension of source files to generate documentation from.
  --outext=
             Target file extension including leading period. If not passed
             extension of page template file (--page) will be used.
  --link-ext=<--outext>
             Extension to append to generated local links; can be empty.
  --template=Template
             Template directory to use. All files there except the ones
             beginning with "_" will be copied to the dest folder.
  --page=_page.html|htm|php|txt|wiki|wacko - whatever exists (in this order)
             Documentation page's template (PHP-enabled).
  --chdir=   If passed, will chdir() there on startup.
  --load[]=path\module.php
             Include extra markup module(s).
  --include[]=path\script.php
             Invoke include_once() to load custom PHP scripts.
  --in-charset=UTF-8
  --out-charset=UTF-8
             Case-insensitive. "UTF" & "UTF8" are synonyms of "UTF-8". Only
             affect source files; other files (e.g. template) must always be
             encoded in UTF-8. Both options require iconv PHP extension.
  --src-interface=auto
  --dest-interface=auto
  --tpl-interface=auto
  --svn-command=svn
             Is used when doing updates from SVN repository.
  --svn-login=
  --svn-password=
  --prepend=path/to/file.wiki
  --append=path/to/file.wiki
             Files (always local path) that will be prefixed/suffixed to each
             source file; are affected by --in-charset.
  --static=0
             If 1 will remove any "<?php echo '<?'?>?" tags from page template.
  --index-file=index.<--inext>
             Index file can exist in each directory; affected by --in-charset.
  --source-url=
             If specified might be used in "View source" links of template.
             Format is the same as that of config/interwiki.conf except that
             it can't contain {ROOT} and it can contain {LANG}. Examples:
               --source-url=/svn/   /svn/{LANG}/{URL}?latest   /svn/{PATH}
  --history-url=
             If specified might be used in "Previous versions" links of
             template. Format is the same as that of --source-url.
  --copy-all=1
             Copies all files in source directory (recursive) except those
             starting with "_" or having --inext extension.
  --copy[dest/file]=src/file
             Copies single file. Note that value of this option is SOURCE
             file, not destination. Later occurrences overwrites previous.
             In Source path you can use {LANG} for multilanguage builds.
             The order:   template files -> --copy-all -> -copy[]
  --embed-css=0
             Some templates support per-dir and/or per-file extra CSS files.
             If this is on they'll embed them into HTML, if off - link using
             <link rel="stylesheet"> - regardless if --copy-all included
             that .css file or not (it'll be auto-added if it wasn't copied).

Options for -u (update mode):
  --delete-removed=1
             Files in destination will be removed if the source interface
             indicates they no longer exist (e.g. file interface asks file
             system, SVN scans last commit). Without this option they're kept.
  --existing-only=0
             Whether or not to update already rendered files only.

Options that handle multilanguage source files:
  If any of language options is specified source path (argument #1) is unused -
  you can omit it (arg #2 becomes arg #1). However, --src-interface is still
  used. You can also use any interface that is supported (file, SVN, etc.).
  Think of this as if running WackoDoc with several source paths at once.
  Don't mix ISO 639-1 (**) and ISO 639-2 (***) in one build. Later occurrences
  of the same ISO code (via --language or --languages) will override previous.
  Full ISO codes list: http://www.loc.gov/standards/iso639-2/ascii_8bits.html

  Note that --languageS can only be used for LOCAL PATHS - for other media
  explicitly supply language codes using --language[code]=any://path.

  --languages[]=path/
  --languages[]=path/**/
             Assumes all folders inside path/ that are named with 2 chars
             belong to particular language. If there's no matching dirs
             nothing happens (you can supply several --languages opts).
  --languages[]=path/***/
             Same as with ** but names are expected in ISO 639-2 format.
  --languages[]=path/**/dir/
  --languages[]=path/***/dir/
             Assumes source files are located under dir/ instead of directly
             in a language's folder.
  --language[code]=path/to/lang/
             Adds a language folder hosted elsewhere. Code must be either
             2 or 3 chars long; you can use this along with --languages.
             Character case of code doesn't matter.

Options that change processor settings (UWikiSettings):
  --letters=a-zA-Z...
             Case-sensitive; adds more characters to be considered as letters
             (similar to \w but also matching non-English letters). These chars
             are already treated as letters: a-z A-Z а-я А-Я
  --entities[name]=code;HTML
             Case-sensitive. Example:  --entities[ent]=100;&ent;  - processes
             "&&ent;" as a char having 100 (0x64) code and represented as
             "&ent;" in HTML.
  --anchors-as-identifiers=true
             A complex mode that changes the behaviour of ((#link)).
  --entities[name]=
             Case-sensitive; disables processing of "&&name;".
  --replace[regexp]=replacement
             Replaces a substring. Note that you can't use any markup, HTML
             isn't escaped and that replacement only happens inside texts (e.g.
             a replace rule like "**" won't match anything in doc "**bold**"
             since "**" here is a token rather than a text: in "~**bold**" both
             "**" will be replaced). Note that HTML has been encoded (e.g. ">"
             into "&gt;") before doing this replacements.
  --term[term]=explanation
             Adds term to be replaced as if it was defined using
             (?term==explanation?). Is not affected by settings (such as
             expandTerms or minTermLengthToExpand).
  --style-aliases[newalias]=style
             Aliases style "newalias" to "style". New alias must be lower case.
  --style-aliases[ClassName]=style
             Sets default style for an element (e.g. "wacko_BlockQuote").
  --anchorize[ClassName]=0|1
             Add <a name="..."></a> before this element or not. An example of
             ClassName is "wacko_BlockQuote". By default anchors are added
             before paragraphs and headings.
  --auto-anchor-contractions[ClassName]=contraction
             Autogenerated anchors are given names of their class by default,
             e.g. paragraphs -> "wacko_Paragraph". Using this option you can
             give different (shorter) names. By default paragraphs contract
             into one letter "p".
  --expand-terms=1
  --dubious-as-comments=0
  --no-line-breaks-inside-para=1
  --more-indent-breaks-para-line=0
  --unindent-blocks=0
  --enable-html5=0
  --heading-mode=normal (default)|shifted|extended
  --hide-doc-title=0
  --root-url=/
  --base-url=
             This will be prepended to image URLs, local links, etc.
  --media-url=/uversewiki/media
  --smiley-url=/uversewiki/media/smileys
             In these 3 options you can use {LANG} for multilanguage builds.
  --wackowiki-highl-dif=./wacko/highlight
  --inline-footnotes-as=tooltip
             Possible values: expanded, tooltip, block.
  --footnotes-at-the-end=0
             Moves all footnote explanations to the page end.
  --config-path=path/to/config/files/
             Will load config files from this path. Note that if at least one
             --config--path is passed the default config is not loaded so you
             either need to load it or include essential files (strings.conf)
             in your config path or documents might be rendered improperly.
             This and below version can contain {LANG} in multilang builds.
  --config-path[]=path/to/config/files/
             Load several config folders (settings will be merged together -
             usually option that comes later will override previous).
  --uwiki-path=.
             Directory containing the framework (uversewiki.php and others).

Modes (setting a bunch of options at once):
  --draft-mode=0
            If on, includes comments in the output.
  --novel-mode=0
            If on, ignores soft line breaks ([CR]LF) in paragraphs (still
            respecting forced ones using ---) and breaks line on indentation.
