<?php
  $selfUpDirsToEngineRoot = 1;
  require '../engine/page.php';
  set_time_limit(0);  // we never know how large posts and how many of them there might be.
  ignore_user_abort(false);

  $confirm = &$_REQUEST['confirm'];
  $ignoreLastModTime = !empty( $_REQUEST['ignoreLastModTime'] );

  if (empty($_REQUEST['changed'])) {
    $dir = BConfig::FromUTF8('file name', BConfig::$paths['posts']);
    $changed = GetChangedPostsIn($dir, $ignoreLastModTime);
    isset($confirm) or $confirm = true;
  } else {
    $confirm = false;

    $changed = array();
    // we explicitly encode value ($file) because UTF-8 gets broken upon form submission.
    foreach ($_REQUEST['changed'] as $post => $file) {
      $changed[urldecode($post)] = urldecode($file);
    }
  }

  // oldest first so if later posts ((link)) to previous links won't be highlighted as inexisting.
  // We'd best sort by file creation time but most *nix systems have none (and so does PHP).
  // We could get one from the post's .wiki but we'd need to parse it. todo: invent something.
  uasort($changed, 'NewestLast');

    function NewestLast($file1, $file2) {
      $f = filemtime($file1);
      $s = filemtime($file2);
      return ( $f > $s ? +1 : ($f < $s ? -1 : 0) );
    }

  if ($ignoreLastModTime) {
    $ignoreModTimeForm = '';
  } else {
    $ignoreModTimeForm = '
      <form action="'.$_SERVER['SCRIPT_NAME'].'" method="get">
        <input type="submit" name="ignoreLastModTime" value="Search again including posts that were not changed since last update." />
      </form>';
  }

  if (!$changed) {
    echo '<H3>Nothing to update.</h3>', $ignoreModTimeForm;
  } elseif (!$confirm) {
    $counts = Update($changed);

    foreach (array('updCount' => 'Updated', 'addCount' => 'Added') as $key => $str) {
      $count = $counts[$key];
      $s = $count === 1 ? '' : 's';
      echo $count ? '<strong>' : '', "<em>$str $count post$s.</em> <br />",
           $count ? '</strong>' : '';
    }
  } else {
    echo '<h3>Changed posts (', count($changed), ')</h3>', $ignoreModTimeForm; ?>

    <script type="text/javascript">
      function Toggle(state) {
        var all = document.getElementsByTagName('input');
        for (var i = 0; i < all.length; i++) {
          var el = all[i];

          if (el.type == 'checkbox') { el.checked = state; }
        }
      }
    </script>

    <form action="<?php echo $_SERVER['SCRIPT_NAME']?>" method="post">
      <input type="submit" value="Update selected" />

      <a href="#" onclick="Toggle(true); return false;">Check</a> /
      <a href="#" onclick="Toggle(false); return false;">uncheck</a> all

      <ol>
        <?php
          foreach ($changed as $post => $file) {
            $id = 'p_'.mt_rand(); ?>
          <li>
            <input type="checkbox" id="<?php echo $id?>"
                   name="changed[<?php echo urlencode($post)?>]"
                   value="<?php echo urlencode($file)?>" checked="checked" />

            <?php
              $isNew = !BPosts::Exists($post);

                if ($isNew) {
                  $lastChange = '';
                } else {
                  $time = BPosts::Get($post, 'lastChanged');
                  $lastChange = '&ndash; old version of '.date('d.m.y H:i.', $time);
                }

              printf( '<label for="%s">%s%s%s <em>%s</em></label>', $id,
                      $isNew ? '<strong>' : '', $post, $isNew ? '</strong>' : '',
                      $lastChange );
            ?>
          </li>
        <?php } ?>
      </ol>

      <input type="submit" value="Update selected" />
    </form>
  <?php }

    // $dir is expected to be in native FS charset (i.e. ran over FromUTF8()).
    // result: array('post' => 'file') - 'post' is in UTF8, 'file' is in native encoding.
    function GetChangedPostsIn($dir, $ignoreLastModTime, $prefix = '') {
      $dir = rtrim($dir, '\\/');
      $changed = array();
      $subdirs = array();

        $engineRoot = BConfig::FromUTF8('file name', BConfig::$enginePath);
        $engineRoot = rtrim($engineRoot, '\\/');

        $posts = scandir($dir);
        foreach ($posts as $file) {
          $full = "$dir/$file";

          if (is_file($full)) {
            if (ExtOf($file) === BConfig::$postFileExt) {
              $post = BConfig::ToUTF8('file name', $prefix.$file);
              if (!BPosts::Exists($post) or ($ignoreLastModTime or
                  BPosts::Get($post, 'lastChanged') < filemtime($full))) {
                $changed[$post] = $full;
              }
            }
          } elseif ($file !== '.' and $file !== '..' and is_dir($full)) {
            if ($engineRoot !== $full) {
              $subdirs[] = "$full/";
            }
          }
        }

      foreach ($subdirs as $subdir) {
        $changed += GetChangedPostsIn($subdir, $ignoreLastModTime,
                                      $prefix.basename($subdir).'/');
      }

      return $changed;
    }

    function Update($changed) {
      $updCount = $addCount = 0;
      echo '<ol>';

      foreach ($changed as $post => $file) {
        $isNew = !BPosts::Exists($post);
        $isNew ? ++$addCount : ++$updCount;

        $src = file_get_contents($file);
        $lastChanged = filemtime($file);
        BPosts::AddOrUpdate($post, $src, compact('lastChanged'));

        echo '<li>', $isNew ? 'Added' : 'Updated', " $post.</li>\n";
        flush();
      }

      echo '</ol>';
      return compact('addCount', 'updCount');
    }
