<?php

class BFilter {
  // "@date/=tag/or/and"; other components are ignored.
  static function Parse($str, &$lastPart) {
    $filter = array();

      $str = str_replace('\\', '/', $str);
      $str = trim($str, '/');

    foreach (explode('/', $str) as $part) {
      $part = trim($part);
      if (isset( $part[0] )) {
        if ($part[0] === '=') {
          $filter[] = array('tags', substr($part, 1));
        } elseif ($part[0] === '@') {
          $date = self::ParseDate( substr($part, 1), $range );
          $date and $filter[] = array('date'.$range, $date);
        } elseif (in_array(strtolower($part), array('or', 'and'))) {
          $filter[] = array( strtolower($part) );
        } else {
          $lastPart = $part;
        }
      }
    }

    return $filter;
  }

    // $str: DD.MM.YY, MM.YY, YY;   YY can be YYYY, DD - D, MM - M, '.' - any of: / -
    static function ParseDate($str, &$range) {
        $str = trim($str);

      foreach (array('.', '/', '-') as $separ) {
        $date = explode($separ, $str);

        $isWrong = false;
        foreach ($date as $component) {
          if (!is_numeric($component)) {
            $isWrong = true;
            break;
          }
        }

        if (!$isWrong) {
          $timestamp = null;

            switch (count($date)) {
            case 1:
              $timestamp = strtotime( date("$date[0]-m-d") );
              $range = 'year';
              break;
            case 2:
              $timestamp = strtotime( date("$date[1]-$date[0]-m") );
              $range = 'month';
              break;
            case 3:
              $timestamp = strtotime( date("$date[2]-$date[1]-$date[0]") );
              $range = 'day';
            }

          if (is_int($timestamp) and $timestamp > 0) { return $timestamp; }
        }
      }
    }

  static function Normalize($filter) {
    foreach ($filter as &$criteria) {
      if (is_array($criteria)) {
        $field = $criteria[0] = strtolower( $criteria[0] );
        if (in_array($field, array('or', 'and')) or BIndex::Exists($field)) {
          continue;
        }
      }

      $criteria = null;
    }

    return array_filter($filter);
  }
}
