<?php

class BThreadPage extends BListPage {
  // $options: posts, parent.
  function Generate($page, $options) {
    $post = $options['posts'][0];

    if (empty($options['parent'])) {
      RedirectTo(BPosts::UrlOf($post));
    }

    $comment = $options['parent'] = BComments::ReferrerFor($post, $options['parent']);

      if (!BComments::Exists($comment)) {
        throw new BException("Comment $options[parent] or post $post don't exist.");
      }

    $vars = $this->OnePost($post, $options + GetPageVars());
    $page->FillAs('blog comments', $vars);
  }

    function OnePost($post, $options) {
      $parent = $options['parent'];
      $vars = parent::OnePost($post, $options);

        // reply form is set up to reply directory to post but we're viewing a thread.
        BTplVars::Set('commenting', $vars, 'commenting', $options['parent'],
                      BConfig::$enableThreads);

      if (!BComments::BelongsToPost($parent)) {
        $vars['parentComment'] = BComments::Get($parent);
        BTplVars::Set('thread', $vars['parentComment'], $parent);
      }

      $parentThread = BComments::ParentCommentOf($parent);
      $parentThread or $parentThread = $parent;  // parent belongs to a post.
      $vars['parentThreadURL'] = BComments::UrlOf($parentThread);

      $vars['page'] = $vars['shortenedForThread'];
      return $vars;
    }

    function CommentsOf($post, $options) {
      return parent::CommentsOf($options['parent'], $options);
    }
}
